/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote;

import hep.aida.IAnnotation;
import hep.aida.IAxis;
import hep.aida.IBaseHistogram;
import hep.aida.IHistogram1D;
import hep.aida.dev.IDevMutableStore;
import hep.aida.ref.Annotation;
import hep.aida.ref.ReadOnlyException;
import hep.aida.ref.event.HistogramEvent;
import hep.aida.ref.histogram.FixedAxis;
import hep.aida.ref.remote.RemoteManagedObject;
import java.util.EventObject;

public class RemoteHistogram1D
extends RemoteManagedObject
implements IHistogram1D {
    private Annotation annotation = null;
    private IAxis axis = null;
    private double[] heights = null;
    private double[] errors = null;
    private int[] entries = null;
    private double[] means = null;
    private double[] rmss = null;
    private double mean = 0.0;
    private double rms = 0.0;
    private int inRangeEntries = 0;
    private int minBinEntries = 0;
    private int maxBinEntries = 0;
    private double inRangeHeights = 0.0;
    private double minBinHeights = 0.0;
    private double maxBinHeights = 0.0;

    public RemoteHistogram1D(String name) {
        this(null, name);
    }

    public RemoteHistogram1D(IDevMutableStore store, String name) {
        this(store, name, name, 50, 0.0, 1.0);
    }

    public RemoteHistogram1D(IDevMutableStore store, String name, String title, int bins, double min, double max) {
        super(name);
        this.aidaType = "IHistogram1D";
        this.store = store;
        this.annotation = new Annotation();
        this.annotation.setFillable(true);
        this.annotation.addItem(Annotation.titleKey, title, true);
        this.annotation.setFillable(false);
        this.dataIsValid = false;
        this.setAxis(bins, min, max);
    }

    protected EventObject createEvent() {
        return new HistogramEvent((IBaseHistogram)this);
    }

    private int convertAIDAIndex(int index) {
        int mi = index == -2 ? 0 : (index == -1 ? this.axis().bins() + 1 : index + 1);
        return mi;
    }

    public void setAxis(int bins, double min, double max) {
        this.axis = new FixedAxis(bins, min, max);
    }

    public void setRms(double rms) {
        this.rms = rms;
    }

    public void setMean(double mean) {
        this.mean = mean;
    }

    public void setHeights(double[] h) {
        if (h == null || h.length == 0) {
            this.heights = null;
            this.inRangeHeights = Double.NaN;
            this.minBinHeights = Double.NaN;
            this.maxBinHeights = Double.NaN;
            return;
        }
        this.heights = new double[h.length];
        this.inRangeHeights = 0.0;
        this.minBinHeights = Double.MAX_VALUE;
        this.maxBinHeights = Double.MIN_VALUE;
        for (int i = 1; i < h.length - 1; ++i) {
            this.heights[i] = h[i];
            this.inRangeHeights += h[i];
            if (h[i] > this.maxBinHeights) {
                this.maxBinHeights = h[i];
            }
            if (!(h[i] < this.minBinHeights)) continue;
            this.minBinHeights = h[i];
        }
        this.heights[0] = h[0];
        this.heights[h.length - 1] = h[h.length - 1];
    }

    public void setEntries(int[] h) {
        if (h == null || h.length == 0) {
            this.entries = null;
            this.inRangeEntries = Integer.MIN_VALUE;
            this.minBinEntries = Integer.MIN_VALUE;
            this.maxBinEntries = Integer.MIN_VALUE;
            return;
        }
        this.entries = new int[h.length];
        this.inRangeEntries = 0;
        this.minBinEntries = Integer.MAX_VALUE;
        this.maxBinEntries = Integer.MIN_VALUE;
        for (int i = 1; i < h.length - 1; ++i) {
            this.entries[i] = h[i];
            this.inRangeEntries += h[i];
            if (h[i] > this.maxBinEntries) {
                this.maxBinEntries = h[i];
            }
            if (h[i] >= this.minBinEntries) continue;
            this.minBinEntries = h[i];
        }
        this.entries[0] = h[0];
        this.entries[h.length - 1] = h[h.length - 1];
    }

    public void setErrors(double[] h) {
        if (h == null || h.length == 0) {
            this.errors = null;
            return;
        }
        this.errors = new double[h.length];
        System.arraycopy(h, 0, this.errors, 0, h.length);
    }

    public void setMeans(double[] h) {
        if (h == null || h.length == 0) {
            this.means = null;
            return;
        }
        this.means = new double[h.length];
        System.arraycopy(h, 0, this.means, 0, h.length);
    }

    public void setRmss(double[] h) {
        if (h == null || h.length == 0) {
            this.rmss = null;
            return;
        }
        this.rmss = new double[h.length];
        System.arraycopy(h, 0, this.rmss, 0, h.length);
    }

    public IAnnotation annotation() {
        this.makeSureDataIsValid();
        return this.annotation;
    }

    public IAxis axis() {
        this.makeSureDataIsValid();
        return this.axis;
    }

    public int dimension() {
        return 1;
    }

    public double mean() {
        this.makeSureDataIsValid();
        return this.mean;
    }

    public double rms() {
        this.makeSureDataIsValid();
        return this.rms;
    }

    public double equivalentBinEntries() {
        this.makeSureDataIsValid();
        if (this.entries == null) {
            return -2.147483648E9;
        }
        return (double)(this.allEntries() * this.allEntries()) * this.mean * this.mean / ((double)this.allEntries() * this.rms * this.rms + this.mean * this.mean);
    }

    public int entries() {
        this.makeSureDataIsValid();
        return this.inRangeEntries;
    }

    public int allEntries() {
        if (this.entries == null) {
            return Integer.MIN_VALUE;
        }
        return this.entries() + this.extraEntries();
    }

    public int extraEntries() {
        this.makeSureDataIsValid();
        if (this.entries == null) {
            return Integer.MIN_VALUE;
        }
        return this.entries[0] + this.entries[this.entries.length - 1];
    }

    public double maxBinHeight() {
        this.makeSureDataIsValid();
        return this.maxBinHeights;
    }

    public double minBinHeight() {
        this.makeSureDataIsValid();
        return this.minBinHeights;
    }

    public double sumAllBinHeights() {
        this.makeSureDataIsValid();
        if (this.heights == null) {
            return Double.NaN;
        }
        return this.sumBinHeights() + this.sumExtraBinHeights();
    }

    public double sumBinHeights() {
        this.makeSureDataIsValid();
        return this.inRangeHeights;
    }

    public double sumExtraBinHeights() {
        this.makeSureDataIsValid();
        if (this.heights == null) {
            return Double.NaN;
        }
        return this.heights[0] + this.heights[this.heights.length - 1];
    }

    public int binEntries(int param) throws IllegalArgumentException {
        this.makeSureDataIsValid();
        if (this.entries == null) {
            return Integer.MIN_VALUE;
        }
        return this.entries[this.convertAIDAIndex(param)];
    }

    public double binError(int param) throws IllegalArgumentException {
        this.makeSureDataIsValid();
        if (this.errors == null) {
            return Double.NaN;
        }
        return this.errors[this.convertAIDAIndex(param)];
    }

    public double binHeight(int param) throws IllegalArgumentException {
        this.makeSureDataIsValid();
        if (this.heights == null) {
            return Double.NaN;
        }
        return this.heights[this.convertAIDAIndex(param)];
    }

    public double binMean(int param) throws IllegalArgumentException {
        this.makeSureDataIsValid();
        if (this.means == null) {
            return Double.NaN;
        }
        return this.means[this.convertAIDAIndex(param)];
    }

    public double binRms(int param) {
        this.makeSureDataIsValid();
        if (this.rmss == null) {
            return Double.NaN;
        }
        return this.rmss[this.convertAIDAIndex(param)];
    }

    public int coordToIndex(double param) {
        this.makeSureDataIsValid();
        return this.axis.coordToIndex(param);
    }

    public String title() {
        this.makeSureDataIsValid();
        return this.annotation.value(Annotation.titleKey);
    }

    public void setTitle(String title) throws IllegalArgumentException {
        if (!this.fillable) {
            throw new ReadOnlyException();
        }
        this.annotation.setFillable(true);
        this.annotation.setValue(Annotation.titleKey, title);
        this.annotation.setFillable(false);
    }

    public void add(IHistogram1D iHistogram1D) throws IllegalArgumentException {
        throw new ReadOnlyException();
    }

    public void fill(double param) throws IllegalArgumentException {
        throw new ReadOnlyException();
    }

    public void fill(double param, double param1) throws IllegalArgumentException {
        throw new ReadOnlyException();
    }

    public void reset() throws RuntimeException {
        throw new ReadOnlyException();
    }

    public void scale(double param) throws IllegalArgumentException {
        throw new ReadOnlyException();
    }
}

