/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote;

import hep.aida.IAnnotation;
import hep.aida.IAxis;
import hep.aida.IBaseHistogram;
import hep.aida.IHistogram2D;
import hep.aida.dev.IDevMutableStore;
import hep.aida.ref.Annotation;
import hep.aida.ref.ReadOnlyException;
import hep.aida.ref.event.HistogramEvent;
import hep.aida.ref.histogram.FixedAxis;
import hep.aida.ref.remote.RemoteManagedObject;
import java.util.EventObject;

public class RemoteHistogram2D
extends RemoteManagedObject
implements IHistogram2D {
    private Annotation annotation = null;
    private IAxis xAxis = null;
    private IAxis yAxis = null;
    private double[][] heights = null;
    private double[][] errors = null;
    private int[][] entries = null;
    private double[][] binMeansX = null;
    private double[][] binRmssX = null;
    private double[][] binMeansY = null;
    private double[][] binRmssY = null;
    private int[] binEntriesX;
    private int[] binEntriesY;
    private double[] binHeightsX;
    private double[] binHeightsY;
    private double meanX = 0.0;
    private double rmsX = 0.0;
    private double meanY = 0.0;
    private double rmsY = 0.0;
    private int inRangeEntries = 0;
    private int extraEntries = 0;
    private double equivalentBinEntries = 0.0;
    private double inRangeBinHeights = 0.0;
    private double extraBinHeights = 0.0;
    private double minBinHeights = 0.0;
    private double maxBinHeights = 0.0;

    public RemoteHistogram2D(String name) {
        this(null, name);
    }

    public RemoteHistogram2D(IDevMutableStore store, String name) {
        super(name);
        this.aidaType = "IHistogram2D";
        this.store = store;
        this.annotation = new Annotation();
        this.annotation.setFillable(true);
        this.annotation.addItem(Annotation.titleKey, name, true);
        this.annotation.setFillable(false);
        this.dataIsValid = false;
        this.xAxis = new FixedAxis(50, 0.0, 1.0);
        this.yAxis = new FixedAxis(50, 0.0, 1.0);
    }

    public RemoteHistogram2D(IDevMutableStore store, String name, String title) {
        super(name);
        this.aidaType = "IHistogram2D";
        this.store = store;
        this.annotation = new Annotation();
        this.annotation.setFillable(true);
        this.annotation.addItem(Annotation.titleKey, title, true);
        this.annotation.setFillable(false);
        this.dataIsValid = false;
        this.xAxis = new FixedAxis(50, 0.0, 1.0);
        this.yAxis = new FixedAxis(50, 0.0, 1.0);
    }

    protected EventObject createEvent() {
        return new HistogramEvent((IBaseHistogram)this);
    }

    private int convertAIDAIndex(IAxis axis, int index) {
        int mi = index == -2 ? 0 : (index == -1 ? axis.bins() + 1 : index + 1);
        return mi;
    }

    public void setAnnotation(Annotation a) {
        this.annotation = a;
    }

    public void setXAxis(int bins, double min, double max) {
        this.xAxis = new FixedAxis(bins, min, max);
    }

    public void setYAxis(int bins, double min, double max) {
        this.yAxis = new FixedAxis(bins, min, max);
    }

    public void setRmsX(double rms) {
        this.rmsX = rms;
    }

    public void setRmsY(double rms) {
        this.rmsY = rms;
    }

    public void setMeanX(double mean) {
        this.meanX = mean;
    }

    public void setMeanY(double mean) {
        this.meanY = mean;
    }

    public void setHeights(double[][] h) {
        if (h == null || h.length == 0) {
            this.heights = null;
            this.inRangeBinHeights = Double.NaN;
            this.extraBinHeights = Double.NaN;
            this.minBinHeights = Double.NaN;
            this.maxBinHeights = Double.NaN;
            return;
        }
        this.heights = h;
    }

    public void setEntries(int[][] h) {
        if (h == null || h.length == 0) {
            this.entries = null;
            this.inRangeEntries = Integer.MIN_VALUE;
            this.extraEntries = Integer.MIN_VALUE;
            this.equivalentBinEntries = Double.NaN;
            return;
        }
        this.entries = h;
    }

    public void setErrors(double[][] h) {
        if (h == null || h.length == 0) {
            this.errors = null;
            return;
        }
        this.errors = h;
    }

    public void setBinMeansX(double[][] h) {
        if (h == null || h.length == 0) {
            this.binMeansX = null;
            return;
        }
        this.binMeansX = h;
    }

    public void setBinRmssX(double[][] h) {
        if (h == null || h.length == 0) {
            this.binRmssX = null;
            return;
        }
        this.binRmssX = h;
    }

    public void setBinMeansY(double[][] h) {
        if (h == null || h.length == 0) {
            this.binMeansY = null;
            return;
        }
        this.binMeansY = h;
    }

    public void setBinRmssY(double[][] h) {
        if (h == null || h.length == 0) {
            this.binRmssY = null;
            return;
        }
        this.binRmssY = h;
    }

    public void setBinEntriesX(int[] h) {
        if (h == null || h.length == 0) {
            this.binEntriesX = null;
            return;
        }
        this.binEntriesX = h;
    }

    public void setBinEntriesY(int[] h) {
        if (h == null || h.length == 0) {
            this.binEntriesY = null;
            return;
        }
        this.binEntriesY = h;
    }

    public void setBinHeightsX(double[] h) {
        if (h == null || h.length == 0) {
            this.binHeightsX = null;
            return;
        }
        this.binHeightsX = h;
    }

    public void setBinHeightsY(double[] h) {
        if (h == null || h.length == 0) {
            this.binHeightsY = null;
            return;
        }
        this.binHeightsY = h;
    }

    public void setInRangeEntries(int d) {
        this.inRangeEntries = d;
    }

    public void setExtraEntries(int d) {
        this.extraEntries = d;
    }

    public void setEquivalentBinEntries(double d) {
        this.equivalentBinEntries = d;
    }

    public void setInRangeBinHeights(double d) {
        this.inRangeBinHeights = d;
    }

    public void setExtraBinHeights(double d) {
        this.extraBinHeights = d;
    }

    public void setMinBinHeights(double d) {
        this.minBinHeights = d;
    }

    public void setMaxBinHeights(double d) {
        this.maxBinHeights = d;
    }

    public IAnnotation annotation() {
        this.makeSureDataIsValid();
        return this.annotation;
    }

    public int dimension() {
        return 2;
    }

    public int entries() {
        this.makeSureDataIsValid();
        return this.inRangeEntries;
    }

    public void reset() throws RuntimeException {
        throw new ReadOnlyException();
    }

    public String title() {
        this.makeSureDataIsValid();
        return this.annotation.value(Annotation.titleKey);
    }

    public void setTitle(String title) throws IllegalArgumentException {
        if (!this.fillable) {
            throw new ReadOnlyException();
        }
        this.annotation.setFillable(true);
        this.annotation.setValue(Annotation.titleKey, title);
        this.annotation.setFillable(false);
    }

    public int allEntries() {
        if (this.entries == null) {
            return Integer.MIN_VALUE;
        }
        return this.entries() + this.extraEntries();
    }

    public double equivalentBinEntries() {
        this.makeSureDataIsValid();
        return this.equivalentBinEntries;
    }

    public int extraEntries() {
        this.makeSureDataIsValid();
        return this.extraEntries;
    }

    public double maxBinHeight() {
        this.makeSureDataIsValid();
        return this.maxBinHeights;
    }

    public double minBinHeight() {
        this.makeSureDataIsValid();
        return this.minBinHeights;
    }

    public void scale(double param) throws IllegalArgumentException {
        throw new ReadOnlyException();
    }

    public double sumAllBinHeights() {
        this.makeSureDataIsValid();
        if (this.heights == null) {
            return Double.NaN;
        }
        return this.sumBinHeights() + this.sumExtraBinHeights();
    }

    public double sumBinHeights() {
        this.makeSureDataIsValid();
        if (this.heights == null) {
            return Double.NaN;
        }
        return this.inRangeBinHeights;
    }

    public double sumExtraBinHeights() {
        this.makeSureDataIsValid();
        if (this.heights == null) {
            return Double.NaN;
        }
        return this.extraBinHeights;
    }

    public void add(IHistogram2D iHistogram2D) throws IllegalArgumentException {
        throw new ReadOnlyException();
    }

    public int binEntries(int param1, int param2) throws IllegalArgumentException {
        this.makeSureDataIsValid();
        if (this.entries == null) {
            return Integer.MIN_VALUE;
        }
        return this.entries[this.convertAIDAIndex(this.xAxis, param1)][this.convertAIDAIndex(this.yAxis, param2)];
    }

    public int binEntriesX(int param) throws IllegalArgumentException {
        this.makeSureDataIsValid();
        if (this.binEntriesX == null) {
            return Integer.MIN_VALUE;
        }
        return this.binEntriesX[this.convertAIDAIndex(this.xAxis, param)];
    }

    public int binEntriesY(int param) throws IllegalArgumentException {
        this.makeSureDataIsValid();
        if (this.binEntriesY == null) {
            return Integer.MIN_VALUE;
        }
        return this.binEntriesY[this.convertAIDAIndex(this.yAxis, param)];
    }

    public double binError(int param1, int param2) throws IllegalArgumentException {
        this.makeSureDataIsValid();
        if (this.errors == null) {
            return Double.NaN;
        }
        return this.errors[this.convertAIDAIndex(this.xAxis, param1)][this.convertAIDAIndex(this.yAxis, param2)];
    }

    public double binHeight(int param1, int param2) throws IllegalArgumentException {
        this.makeSureDataIsValid();
        if (this.heights == null) {
            return Double.NaN;
        }
        return this.heights[this.convertAIDAIndex(this.xAxis, param1)][this.convertAIDAIndex(this.yAxis, param2)];
    }

    public double binHeightX(int param) throws IllegalArgumentException {
        this.makeSureDataIsValid();
        if (this.binHeightsX == null) {
            return Double.NaN;
        }
        return this.binHeightsX[this.convertAIDAIndex(this.xAxis, param)];
    }

    public double binHeightY(int param) throws IllegalArgumentException {
        this.makeSureDataIsValid();
        if (this.binHeightsY == null) {
            return Double.NaN;
        }
        return this.binHeightsY[this.convertAIDAIndex(this.yAxis, param)];
    }

    public double binMeanX(int param1, int param2) throws IllegalArgumentException {
        this.makeSureDataIsValid();
        if (this.binMeansX == null) {
            return Double.NaN;
        }
        return this.binMeansX[this.convertAIDAIndex(this.xAxis, param1)][this.convertAIDAIndex(this.yAxis, param2)];
    }

    public double binMeanY(int param1, int param2) throws IllegalArgumentException {
        this.makeSureDataIsValid();
        if (this.binMeansY == null) {
            return Double.NaN;
        }
        return this.binMeansY[this.convertAIDAIndex(this.xAxis, param1)][this.convertAIDAIndex(this.yAxis, param2)];
    }

    public double binRmsX(int param1, int param2) throws IllegalArgumentException {
        this.makeSureDataIsValid();
        if (this.binRmssX == null) {
            return Double.NaN;
        }
        return this.binRmssX[this.convertAIDAIndex(this.xAxis, param1)][this.convertAIDAIndex(this.yAxis, param2)];
    }

    public double binRmsY(int param1, int param2) throws IllegalArgumentException {
        this.makeSureDataIsValid();
        if (this.binRmssY == null) {
            return Double.NaN;
        }
        return this.binRmssY[this.convertAIDAIndex(this.xAxis, param1)][this.convertAIDAIndex(this.yAxis, param2)];
    }

    public int coordToIndexX(double param) {
        this.makeSureDataIsValid();
        return this.xAxis.coordToIndex(param);
    }

    public int coordToIndexY(double param) {
        this.makeSureDataIsValid();
        return this.xAxis.coordToIndex(param);
    }

    public void fill(double param, double param1) throws IllegalArgumentException {
        throw new ReadOnlyException();
    }

    public void fill(double param, double param1, double param2) throws IllegalArgumentException {
        throw new ReadOnlyException();
    }

    public double meanX() {
        this.makeSureDataIsValid();
        return this.meanX;
    }

    public double meanY() {
        this.makeSureDataIsValid();
        return this.meanY;
    }

    public double rmsX() {
        this.makeSureDataIsValid();
        return this.rmsX;
    }

    public double rmsY() {
        this.makeSureDataIsValid();
        return this.rmsY;
    }

    public IAxis xAxis() {
        this.makeSureDataIsValid();
        return this.xAxis;
    }

    public IAxis yAxis() {
        this.makeSureDataIsValid();
        return this.yAxis;
    }
}

