/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote;

import hep.aida.dev.IDevTree;
import hep.aida.ref.remote.RemoteConnectionException;
import hep.aida.ref.remote.RemoteServant;
import hep.aida.ref.remote.interfaces.AidaTreeClient;
import hep.aida.ref.remote.interfaces.AidaTreeServant;
import hep.aida.ref.remote.interfaces.AidaTreeServer;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class RemoteServer
implements AidaTreeServer {
    private IDevTree tree;
    private String treeName;
    private boolean duplex;
    private boolean appendAxisType;
    private Map servantHash;
    private boolean acceptNewConnections;
    protected Logger remoteLogger;

    public RemoteServer(IDevTree tree) {
        this(tree, true);
    }

    public RemoteServer(IDevTree tree, boolean duplex) {
        this(tree, duplex, false);
    }

    public RemoteServer(IDevTree tree, boolean duple, boolean appendAxisType) {
        this.tree = tree;
        this.duplex = this.duplex;
        this.appendAxisType = appendAxisType;
        this.treeName = tree.storeName();
        this.servantHash = new Hashtable();
        this.acceptNewConnections = true;
        this.remoteLogger = Logger.getLogger("hep.aida.ref.remote");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AidaTreeServant connect(Object clientRef) {
        this.remoteLogger.info("New connection from Client:  " + clientRef + ", acceptNewConnections=" + this.acceptNewConnections);
        if (clientRef == null) {
            throw new RemoteConnectionException("Can not connect with NULL Client Reference.");
        }
        AidaTreeServant servant = null;
        if (!this.acceptNewConnections) {
            return servant;
        }
        Map map = this.servantHash;
        synchronized (map) {
            servant = (AidaTreeServant)this.servantHash.get(clientRef);
            if (servant != null) {
                throw new RemoteConnectionException("This client is already connected. Please disconnect first.\nClient: " + clientRef.toString());
            }
            if (clientRef instanceof String) {
                servant = new RemoteServant(this.tree, (String)clientRef);
            } else if (clientRef instanceof AidaTreeClient) {
                servant = new RemoteServant(this.tree, (AidaTreeClient)clientRef);
            }
            ((RemoteServant)servant).setAppendAxisType(this.appendAxisType);
            this.servantHash.put(clientRef, servant);
        }
        return servant;
    }

    private boolean disconnect(Object clientRef) {
        this.remoteLogger.info("\tDisconnecting Client: " + clientRef + ", acceptNewConnections=" + this.acceptNewConnections);
        AidaTreeServant servant = (AidaTreeServant)this.servantHash.get(clientRef);
        if (servant != null) {
            if (servant instanceof RemoteServant) {
                ((RemoteServant)servant).close();
            }
            this.servantHash.remove(clientRef);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectAll() {
        Map map = this.servantHash;
        synchronized (map) {
            if (!this.servantHash.isEmpty()) {
                Set keySet = this.servantHash.keySet();
                int size = keySet.size();
                Object[] a = new Object[size];
                keySet.toArray(a);
                for (int i = 0; i < size; ++i) {
                    Object clientRef = a[i];
                    this.disconnect(clientRef);
                }
                this.servantHash.clear();
            }
        }
    }

    public void close() {
        this.acceptNewConnections = false;
        this.disconnectAll();
        this.servantHash.clear();
        this.servantHash = null;
        this.tree = null;
    }

    public AidaTreeServant connectDuplex(AidaTreeClient client) {
        return this.connect(client);
    }

    public AidaTreeServant connectNonDuplex(String clientID) {
        return this.connect(clientID);
    }

    public boolean disconnectDuplex(AidaTreeClient client) {
        return this.disconnect(client);
    }

    public boolean disconnectNonDuplex(String clientID) {
        return this.disconnect(clientID);
    }

    public boolean supportDuplexMode() {
        return this.duplex;
    }

    public String treeName() {
        return this.treeName;
    }
}

