/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote;

import hep.aida.IBaseHistogram;
import hep.aida.IDataPointSet;
import hep.aida.IManagedObject;
import hep.aida.ITree;
import hep.aida.dev.IDevMutableStore;
import hep.aida.dev.IDevTree;
import hep.aida.dev.IStore;
import hep.aida.dev.IStoreFactory;
import hep.aida.ref.AidaUtils;
import hep.aida.ref.Annotation;
import hep.aida.ref.ManagedObject;
import hep.aida.ref.event.AIDAObservable;
import hep.aida.ref.event.IsObservable;
import hep.aida.ref.remote.RemoteFolder;
import hep.aida.ref.remote.RemoteHistogram1D;
import hep.aida.ref.remote.RemoteManagedObject;
import hep.aida.ref.remote.RemoteUnavailableObject;
import hep.aida.ref.remote.RemoteUpdateEvent;
import hep.aida.ref.remote.interfaces.AidaUpdateEvent;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.freehep.util.FreeHEPLookup;
import org.openide.util.Lookup;

public class RemoteTree
extends AIDAObservable
implements IDevTree,
IsObservable {
    protected IStore aidaStore;
    private String storeName;
    private boolean readOnly;
    private boolean readOnlyUserDefined;
    private boolean appendAxisType;
    private boolean createNew;
    protected String storeType = null;
    protected Map optionsMap;
    protected boolean overwrite;
    protected Vector updateBuffer;
    protected Logger remoteLogger;
    private Object lock;
    protected TreeMap map = new TreeMap();

    public RemoteTree() {
        this("Tree");
    }

    public RemoteTree(String name) {
        this(name, null);
    }

    public RemoteTree(String name, IDevMutableStore aidaStore) {
        this(name, aidaStore, false);
    }

    public RemoteTree(String name, IDevMutableStore aidaStore, boolean overwrite) {
        this(name, aidaStore, overwrite, false);
    }

    public RemoteTree(String name, IDevMutableStore aidaStore, boolean overwrite, boolean appendAxisType) {
        this.storeName = name;
        this.aidaStore = aidaStore;
        this.lock = new Object();
        this.overwrite = overwrite;
        this.remoteLogger = Logger.getLogger("hep.aida.ref.remote");
        this.appendAxisType = appendAxisType;
        this.updateBuffer = new Vector();
        this.setIsValidAfterNotify(true);
        this.addFolder("/");
    }

    public void submitEventToListeners(AidaUpdateEvent ev) {
        this.remoteLogger.finest("RemoteTree.submitEventToListeners ::  id=" + ev.id() + ", path=" + ev.path());
        if (ev instanceof RemoteUpdateEvent) {
            this.fireStateChanged((EventObject)((Object)ev));
        } else {
            int id = ev.id();
            String path = ev.path();
            String type = ev.nodeType();
            RemoteUpdateEvent rev = new RemoteUpdateEvent(id, path, type);
            this.fireStateChanged(rev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String storeName, boolean readOnly, boolean createNew, String storeType, String options, boolean readOnlyUserDefined) throws IOException {
        this.storeName = storeName;
        this.readOnly = readOnly;
        this.readOnlyUserDefined = readOnlyUserDefined;
        this.createNew = createNew;
        this.storeType = storeType;
        if (readOnly && createNew) {
            throw new IllegalArgumentException("readOnly and createNew not allowed");
        }
        this.optionsMap = AidaUtils.parseOptions(options);
        if (storeName != null && storeName.length() > 0 && !createNew) {
            if (this.getLock() != null) {
                Object object = this.getLock();
                synchronized (object) {
                    this.createStore().read(this, this.optionsMap, readOnly, createNew);
                }
            } else {
                this.createStore().read(this, this.optionsMap, readOnly, createNew);
            }
        }
    }

    protected IStore createStore() throws IOException {
        if (this.aidaStore == null) {
            if (this.storeType == null || this.storeType.length() == 0) {
                this.storeType = "xml";
            }
            Lookup.Template template = new Lookup.Template(IStoreFactory.class);
            Lookup.Result result = FreeHEPLookup.instance().lookup(template);
            Iterator i = result.allInstances().iterator();
            while (i.hasNext()) {
                IStoreFactory factory = (IStoreFactory)i.next();
                if (!factory.supportsType(this.storeType)) continue;
                this.aidaStore = factory.createStore();
                if (!this.readOnlyUserDefined && this.aidaStore.isReadOnly()) {
                    this.readOnly = true;
                }
                if (this.aidaStore.isReadOnly() && !this.isReadOnly()) {
                    throw new IllegalArgumentException("When opening a read-only file, the associated tree must be read-only. Please correct the options with which you created the tree.");
                }
                return this.aidaStore;
            }
            throw new IOException("Unknown store type: " + this.storeType);
        }
        return this.aidaStore;
    }

    public String correctPath(String path, boolean isDir) {
        String tmpPath = path;
        if (tmpPath.equals("/")) {
            return tmpPath;
        }
        tmpPath.replaceAll("///", "/");
        tmpPath.replaceAll("//", "/");
        if (!tmpPath.startsWith("/")) {
            tmpPath = "/" + tmpPath;
        }
        if (isDir && !tmpPath.endsWith("/")) {
            tmpPath = tmpPath + "/";
        }
        if (!isDir && tmpPath.endsWith("/")) {
            tmpPath = tmpPath.substring(0, tmpPath.length() - 1);
        }
        return tmpPath;
    }

    protected String[] executeListObjectNames(String path, boolean recursive) {
        String[] names = null;
        this.remoteLogger.finest("RemoteTree.executeListObjectNames for recursive=" + recursive + ",  Path: " + path);
        SortedMap tailMap = this.map.tailMap(path);
        ArrayList<String> list = new ArrayList<String>(tailMap.size());
        Iterator tailIt = tailMap.keySet().iterator();
        while (tailIt.hasNext()) {
            String folder;
            String key = (String)tailIt.next();
            if (path.equals(key)) continue;
            if (recursive || path.equals("/")) {
                list.add(key);
                continue;
            }
            if (!key.startsWith(path) || !path.equals(folder = AidaUtils.parseDirName(key))) continue;
            list.add(key);
        }
        list.trimToSize();
        names = new String[list.size()];
        list.toArray(names);
        return names;
    }

    protected String[] executeListObjectTypes(String path, boolean recursive) {
        String[] types = null;
        this.remoteLogger.finest("RemoteTree.executeListObjectTypes for recursive=" + recursive + ",  Path: " + path);
        SortedMap tailMap = this.map.tailMap(path);
        ArrayList<String> list = new ArrayList<String>(tailMap.size());
        Iterator tailIt = tailMap.keySet().iterator();
        while (tailIt.hasNext()) {
            String folder;
            String key = (String)tailIt.next();
            String type = null;
            if (path.equals(key) || !key.startsWith(path)) continue;
            boolean acceptKey = false;
            if (recursive || path.equals("/")) {
                acceptKey = true;
            } else if (!path.equals(key) && path.equals(folder = AidaUtils.parseDirName(key))) {
                acceptKey = true;
            }
            if (!acceptKey) continue;
            Object obj = this.map.get(key);
            type = obj instanceof ManagedObject ? ((ManagedObject)obj).getAIDAType() : obj.getClass().getName();
            if (this.appendAxisType && obj instanceof RemoteManagedObject) {
                String tmp;
                String xType = "double";
                RemoteManagedObject rmo = (RemoteManagedObject)obj;
                rmo.setFillable(true);
                Annotation a = null;
                if (rmo instanceof IBaseHistogram) {
                    try {
                        a = (Annotation)((IBaseHistogram)rmo).annotation();
                        a.setFillable(true);
                        tmp = a.value("xAxisType");
                        if (tmp != null && !tmp.equals("")) {
                            xType = tmp;
                            type = type + ":" + xType;
                        }
                    }
                    catch (IllegalArgumentException e) {}
                } else if (rmo instanceof IDataPointSet) {
                    try {
                        a = (Annotation)((IDataPointSet)rmo).annotation();
                        a.setFillable(true);
                        tmp = a.value("xAxisType");
                        if (tmp != null && !tmp.equals("")) {
                            xType = tmp;
                            type = type + ":" + xType;
                        }
                    }
                    catch (IllegalArgumentException e) {
                        // empty catch block
                    }
                }
                if (a != null) {
                    a.setFillable(false);
                }
                rmo.setFillable(false);
            }
            list.add(type);
        }
        list.trimToSize();
        types = new String[list.size()];
        list.toArray(types);
        return types;
    }

    public IManagedObject executeFind(String path) {
        String p = this.correctPath(path, false);
        if (!this.map.containsKey(p)) {
            throw new IllegalArgumentException("Object does not exist for path: " + p);
        }
        IManagedObject obj = (IManagedObject)this.map.get(p);
        return obj;
    }

    protected void executeClose() {
        if (this.aidaStore != null) {
            try {
                this.aidaStore.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        this.map.clear();
    }

    public void addObject(String path, IManagedObject object) throws IllegalArgumentException {
        String p = this.correctPath(path, true);
        String fullPath = p + AidaUtils.modifyName(object.name());
        this.remoteLogger.finest("RemoteTree.addObject path=" + path + ", correctedPath=" + p + ",  fullPath=" + fullPath + ", object=" + object);
        if (this.map.containsKey(fullPath) && !this.overwrite) {
            throw new IllegalArgumentException("Object already exists for path: " + fullPath);
        }
        this.map.put(fullPath, object);
    }

    public void addFolder(String path) throws IllegalArgumentException {
        String p = this.correctPath(path, true);
        Object obj = this.map.get(p);
        if (obj != null) {
            return;
        }
        String objectName = AidaUtils.parseName(p);
        String folderName = AidaUtils.parseDirName(p);
        RemoteFolder f = new RemoteFolder(objectName);
        f.setTreeFolder(folderName);
        this.map.put(p, f);
    }

    void removeObject(String path) throws IllegalArgumentException {
        String p = this.correctPath(path, false);
        if (!this.map.containsKey(p)) {
            throw new IllegalArgumentException("Object does not exist for path: " + p);
        }
        Object obj = this.map.remove(p);
        this.remoteLogger.finest("RemoteTree.removeObject path=" + path + ", correctedPath=" + p + ", object=" + obj);
    }

    void removeFolder(String path) throws IllegalArgumentException {
        String p = this.correctPath(path, true);
        if (!this.map.containsKey(p)) {
            throw new IllegalArgumentException("Folder does not exist for path: " + p);
        }
        this.remoteLogger.finest("RemoteTree.removeFolder path=" + path + ", correctedPath=" + p);
        SortedMap tailMap = this.map.tailMap(p);
        Set keySet = tailMap.keySet();
        int size = keySet.size();
        Object[] a = new Object[size];
        keySet.toArray(a);
        for (int i = 0; i < size; ++i) {
            String key = (String)a[i];
            if (!key.startsWith(p)) continue;
            Object obj = this.map.remove(key);
        }
    }

    String executeFindPath(IManagedObject iManagedObject) {
        String path = null;
        String key = null;
        Iterator it = this.map.keySet().iterator();
        while (it.hasNext()) {
            key = (String)it.next();
            if (!this.map.get(key).equals(iManagedObject)) continue;
            path = key;
            break;
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int executeUpdate(String updatePath) {
        if (this.updateBuffer.isEmpty()) {
            return 0;
        }
        Object[] paths = null;
        if (this.lock != null) {
            Object object = this.lock;
            synchronized (object) {
                paths = this.updateBuffer.toArray();
                this.updateBuffer.clear();
            }
        } else {
            paths = this.updateBuffer.toArray();
            this.updateBuffer.clear();
        }
        int nObjects = paths.length;
        for (int i = 0; i < paths.length; ++i) {
            String path = (String)paths[i];
            if (updatePath != null && !updatePath.equals("/") && !path.startsWith(updatePath)) continue;
            try {
                IManagedObject obj = (IManagedObject)this.map.get(path);
                this.remoteLogger.finest("RemoteTree.executeUpdate: Path=" + path + ",  object=" + obj);
                System.out.println("RemoteTree.executeUpdate: Path=" + path + ",  object=" + obj);
                if (obj == null) continue;
                if (obj instanceof RemoteManagedObject) {
                    RemoteManagedObject rmo = (RemoteManagedObject)obj;
                    if (!rmo.isDataValid()) continue;
                    rmo.setDataValid(false);
                    continue;
                }
                if (!(obj instanceof ManagedObject)) continue;
                ManagedObject mo = (ManagedObject)obj;
                continue;
            }
            catch (Exception e) {
                this.remoteLogger.log(Level.INFO, "RemoteTree.executeUpdate  Exception for Path: " + path, e);
                this.remoteLogger.log(Level.FINEST, "", e.getStackTrace());
            }
        }
        return nObjects;
    }

    public int doUpdate(String updatePath) {
        if (this.lock != null) {
            return this.executeUpdate(updatePath);
        }
        return this.executeUpdate(updatePath);
    }

    public Object getLock() {
        return this.lock;
    }

    public void setLock(Object lock) {
        this.lock = lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.lock != null) {
            Object object = this.lock;
            synchronized (object) {
                this.executeClose();
            }
        } else {
            this.executeClose();
        }
        this.removeAllListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IManagedObject find(String path) throws IllegalArgumentException {
        String p = this.correctPath(path, false);
        IManagedObject mo = null;
        if (this.lock != null) {
            Object object = this.lock;
            synchronized (object) {
                mo = this.executeFind(p);
                if (!this.updateBuffer.contains(p)) {
                    this.updateBuffer.add(p);
                }
            }
        } else {
            mo = this.executeFind(p);
            if (!this.updateBuffer.contains(p)) {
                this.updateBuffer.add(p);
            }
        }
        return mo;
    }

    public void hasBeenFilled(String path) throws IllegalArgumentException {
    }

    public String[] listObjectNames(String path) throws IllegalArgumentException {
        return this.listObjectNames(path, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listObjectNames(String path, boolean param) throws IllegalArgumentException {
        String p = this.correctPath(path, true);
        if (this.lock != null) {
            Object object = this.lock;
            synchronized (object) {
                return this.executeListObjectNames(p, param);
            }
        }
        return this.executeListObjectNames(p, param);
    }

    public String[] listObjectTypes(String path) throws IllegalArgumentException {
        return this.listObjectTypes(path, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listObjectTypes(String path, boolean param) throws IllegalArgumentException {
        String p = this.correctPath(path, true);
        if (this.lock != null) {
            Object object = this.lock;
            synchronized (object) {
                return this.executeListObjectTypes(p, param);
            }
        }
        return this.executeListObjectTypes(p, param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findPath(IManagedObject iManagedObject) throws IllegalArgumentException {
        if (this.lock != null) {
            Object object = this.lock;
            synchronized (object) {
                return this.executeFindPath(iManagedObject);
            }
        }
        return this.executeFindPath(iManagedObject);
    }

    public void setOverwrite() {
        this.overwrite = true;
    }

    public void setOverwrite(boolean param) {
        this.overwrite = param;
    }

    public String storeName() {
        return this.storeName;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void add(String path, IManagedObject object) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public void mkdir(String str) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public void mkdirs(String str) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public void rm(String str) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public void rmdir(String str) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public void symlink(String str, String str1) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public void unmount(String str) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public void mount(String str, ITree iTree, String str2) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public void mv(String str, String str1) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public String pwd() {
        throw new UnsupportedOperationException();
    }

    public void ls() throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public void ls(String str) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public void ls(String str, boolean param) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public void ls(String str, boolean param, OutputStream outputStream) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public void cd(String str) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public void commit() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void cp(String str, String str1) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public void cp(String str, String str1, boolean param) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public ITree findTree(String str) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public String[] listObjectNames() throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public String[] listObjectTypes() throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public static void main(String[] args) {
        Logger remoteLogger = Logger.getLogger("hep.aida.ref.remote");
        remoteLogger.setLevel(Level.FINEST);
        Handler[] handlers = remoteLogger.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            handlers[i].setLevel(Level.FINEST);
        }
        RemoteTree tree = new RemoteTree();
        tree.addFolder("/hist/");
        tree.addFolder("/hist/dir0/");
        tree.addObject("/hist/dir0/", (IManagedObject)new RemoteHistogram1D("h01"));
        tree.addObject("/hist/dir0/", (IManagedObject)new RemoteHistogram1D("h02"));
        tree.addObject("/hist/dir0/", (IManagedObject)new RemoteHistogram1D("h03"));
        tree.addFolder("/hist/dir1/");
        tree.addObject("/hist/dir1/", (IManagedObject)new RemoteHistogram1D("h11"));
        tree.addObject("/hist/dir1/", (IManagedObject)new RemoteHistogram1D("h12"));
        tree.addObject("/hist/dir1/", (IManagedObject)new RemoteHistogram1D("h13"));
        tree.addFolder("/hist/dir1/subdir/");
        tree.addObject("/hist/dir1/subdir/", (IManagedObject)new RemoteHistogram1D("h13"));
        tree.addFolder("/hist/dir2/");
        tree.addObject("/hist/dir2/", (IManagedObject)new RemoteHistogram1D("h21"));
        tree.addObject("/hist/dir2/", (IManagedObject)new RemoteHistogram1D("h22"));
        tree.addObject("/hist/dir2/", (IManagedObject)new RemoteHistogram1D("h23"));
        String path = "/hist/dir1/h12";
        IManagedObject obj = tree.find(path);
        System.out.println("PATH=" + path + ",  FOUND=" + obj);
        path = "/hist/dir2/h22";
        obj = tree.find(path);
        System.out.println("PATH=" + path + ",  FOUND=" + obj);
        path = "/hist/dir2/h23";
        obj = tree.find(path);
        System.out.println("PATH=" + path + ",  FOUND=" + obj);
        path = "/JasServerInfo/Free\\/Used Memory";
        String name = AidaUtils.parseName(path);
        String objDir = AidaUtils.parseDirName(path);
        RemoteHistogram1D h = new RemoteHistogram1D(name);
        if (tree instanceof RemoteTree) {
            tree.addFolder(objDir);
        } else {
            tree.mkdirs(objDir);
        }
        if (tree instanceof RemoteTree) {
            tree.addObject(objDir, (IManagedObject)h);
        } else {
            tree.add(objDir, (IManagedObject)h);
        }
        if (h instanceof RemoteManagedObject) {
            ((RemoteManagedObject)h).setTreeFolder(objDir);
            if (h instanceof RemoteUnavailableObject) {
                ((RemoteManagedObject)h).setDataValid(true);
            } else {
                ((RemoteManagedObject)h).setDataValid(false);
            }
        }
        String[] names = tree.listObjectNames("/", false);
        String[] types = tree.listObjectTypes("/", false);
        for (int i = 0; i < names.length; ++i) {
            System.out.println("name=" + names[i] + "   type=" + types[i]);
        }
    }
}

