/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote.corba;

import hep.aida.IManagedObject;
import hep.aida.ref.remote.RemoteClient;
import hep.aida.ref.remote.RemoteManagedObject;
import hep.aida.ref.remote.RemoteMutableStore;
import hep.aida.ref.remote.corba.converters.CorbaConverter;
import hep.aida.ref.remote.corba.converters.CorbaDataPointSetDConverter;
import hep.aida.ref.remote.corba.converters.CorbaHist1DConverter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.freehep.util.FreeHEPLookup;
import org.openide.util.Lookup;

public final class CorbaMutableStore
extends RemoteMutableStore {
    private Map converters = new Hashtable();

    public CorbaMutableStore() {
        FreeHEPLookup.instance().add((Object)CorbaHist1DConverter.getInstance(), "IHistogram1D");
        FreeHEPLookup.instance().add((Object)CorbaDataPointSetDConverter.getInstance(), "IDataPointSet");
    }

    private String readIORFromFile(String fileURL) {
        String ior = null;
        try {
            URL url = new URL(fileURL);
            InputStream is = url.openStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            ior = br.readLine();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ior;
    }

    protected RemoteClient createClient(Map options) {
        String ior = "";
        String nsName = null;
        RemoteClient client = null;
        boolean duplex = true;
        if (options.isEmpty()) {
            throw new IllegalArgumentException("No information about AidaTreeServer");
        }
        Iterator it = options.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            String value = (String)options.get(key);
            System.out.println("Key = " + key + " \tValue = " + value);
            if (key.equalsIgnoreCase("ior")) {
                ior = value;
                continue;
            }
            if (key.equalsIgnoreCase("iorFileURL")) {
                ior = this.readIORFromFile(value);
                continue;
            }
            if (key.equalsIgnoreCase("ServerName")) {
                nsName = value;
                continue;
            }
            if (!key.equalsIgnoreCase("duplex")) continue;
            if (value.equalsIgnoreCase("true")) {
                duplex = true;
                continue;
            }
            duplex = false;
        }
        if (nsName == null) {
            client.setDuplex(duplex);
        } else {
            client.setDuplex(duplex);
        }
        return client;
    }

    public void updateData(String path, String aidaType) throws IllegalArgumentException {
        System.out.println("CorbaMutableStore.updateData:     path=" + path + ",   type=" + aidaType);
        CorbaConverter converter = null;
        if (this.converters.containsKey(aidaType)) {
            converter = (CorbaConverter)this.converters.get(aidaType);
        } else {
            Lookup.Template template = new Lookup.Template(CorbaConverter.class, aidaType, null);
            Lookup.Item item = FreeHEPLookup.instance().lookupItem(template);
            if (item == null) {
                throw new IllegalArgumentException("No Converter for AIDA Type: " + aidaType);
            }
            converter = (CorbaConverter)item.getInstance();
            this.converters.put(aidaType, converter);
        }
        IManagedObject mo = this.tree.find(path);
        Object data = this.client.find(path);
        System.out.println("CorbaMutableStore.updateData:    mo=" + mo + ",  data=" + data);
        converter.updateAidaObject(mo, data);
    }

    public IManagedObject createObject(String name, String aidaType) throws IllegalArgumentException {
        System.out.println("CorbaMutableStore.createObject:   name=" + name + ",   type=" + aidaType);
        CorbaConverter converter = null;
        if (this.converters.containsKey(aidaType)) {
            converter = (CorbaConverter)this.converters.get(aidaType);
        } else {
            Lookup.Template template = new Lookup.Template(CorbaConverter.class, aidaType, null);
            Lookup.Item item = FreeHEPLookup.instance().lookupItem(template);
            if (item == null) {
                throw new IllegalArgumentException("No Converter for AIDA Type: " + aidaType);
            }
            converter = (CorbaConverter)item.getInstance();
            this.converters.put(aidaType, converter);
        }
        IManagedObject mo = (IManagedObject)converter.createAidaObject(name);
        if (mo instanceof RemoteManagedObject) {
            ((RemoteManagedObject)mo).setStore(this);
        }
        return mo;
    }

    public void close() throws IOException {
        super.close();
        this.converters.clear();
        this.converters = null;
    }
}

