/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote.rmi.data;

import hep.aida.IAnalysisFactory;
import hep.aida.ICloud1D;
import hep.aida.ITree;
import hep.aida.ref.remote.RemoteCloud1D;
import hep.aida.ref.remote.rmi.converters.RmiCloud1DConverter;
import hep.aida.ref.remote.rmi.data.RmiHist1DData;
import java.io.Serializable;
import java.util.Random;

public class RmiCloud1DData
implements Serializable {
    static final long serialVersionUID = 3521807348319671978L;
    private RmiHist1DData hist = null;
    private boolean isConverted = false;
    private int maxEntries = 0;
    private int entries = 0;
    private double sumOfWeights = 0.0;
    private double lowerEdge = Double.NaN;
    private double upperEdge = Double.NaN;
    private double mean = Double.NaN;
    private double rms = Double.NaN;
    private double[] values = null;
    private double[] weights = null;

    public void setHist(RmiHist1DData hist) {
        this.hist = hist;
    }

    public RmiHist1DData getHist() {
        return this.hist;
    }

    public void setConverted(boolean b) {
        this.isConverted = b;
    }

    public void setMaxEntries(int i) {
        this.maxEntries = i;
    }

    public void setEntries(int i) {
        this.entries = i;
    }

    public void setSumOfWeights(double d) {
        this.sumOfWeights = d;
    }

    public void setLowerEdge(double d) {
        this.lowerEdge = d;
    }

    public void setUpperEdge(double d) {
        this.upperEdge = d;
    }

    public void setMean(double d) {
        this.mean = d;
    }

    public void setRms(double d) {
        this.rms = d;
    }

    public boolean getConverted() {
        return this.isConverted;
    }

    public int getMaxEntries() {
        return this.maxEntries;
    }

    public int getEntries() {
        return this.entries;
    }

    public double getSumOfWeights() {
        return this.sumOfWeights;
    }

    public double getLowerEdge() {
        return this.lowerEdge;
    }

    public double getUpperEdge() {
        return this.upperEdge;
    }

    public double getMean() {
        return this.mean;
    }

    public double getRms() {
        return this.rms;
    }

    public void setValues(double[] values) {
        this.values = values;
    }

    public void setWeights(double[] weights) {
        this.weights = weights;
    }

    public double[] getValues() {
        return this.values;
    }

    public double[] getWeights() {
        return this.weights;
    }

    public static void main(String[] args) throws Exception {
        IAnalysisFactory af = IAnalysisFactory.create();
        ITree tree = af.createTreeFactory().create();
        ICloud1D c1 = af.createHistogramFactory(tree).createCloud1D("Cloud-1D");
        Random rand = new Random();
        for (int i = 0; i < 1000; ++i) {
            c1.fill(rand.nextGaussian());
        }
        RmiCloud1DConverter converter = RmiCloud1DConverter.getInstance();
        RmiCloud1DData data = (RmiCloud1DData)converter.extractData(c1);
        RemoteCloud1D rc1 = (RemoteCloud1D)converter.createAidaObject("Cloud-1D");
        converter.updateAidaObject(rc1, data);
        System.out.println("Entries=" + rc1.entries());
    }
}

