/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote.rmi.server;

import hep.aida.ref.ManagedObject;
import hep.aida.ref.remote.interfaces.AidaTreeClient;
import hep.aida.ref.remote.interfaces.AidaTreeServant;
import hep.aida.ref.remote.interfaces.AidaUpdateEvent;
import hep.aida.ref.remote.rmi.converters.RmiConverter;
import hep.aida.ref.remote.rmi.interfaces.RmiClient;
import hep.aida.ref.remote.rmi.interfaces.RmiServant;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Hashtable;
import java.util.Map;
import org.freehep.util.FreeHEPLookup;
import org.openide.util.Lookup;

public class RmiServantImpl
extends UnicastRemoteObject
implements RmiServant,
AidaTreeClient {
    static final long serialVersionUID = 5141620123191080485L;
    private RmiClient rmiClient;
    private AidaTreeServant aidaServant;
    private Map converters;

    public RmiServantImpl() throws RemoteException {
        this(null, null);
    }

    public RmiServantImpl(RmiClient rmiClient) throws RemoteException {
        this(rmiClient, null);
    }

    public RmiServantImpl(AidaTreeServant aidaServant) throws RemoteException {
        this(null, aidaServant);
    }

    public RmiServantImpl(RmiClient rmiClient, AidaTreeServant aidaServant) throws RemoteException {
        this.rmiClient = rmiClient;
        this.aidaServant = aidaServant;
        this.converters = new Hashtable();
        this.connect();
    }

    void connect() {
    }

    void setAidaTreeServant(AidaTreeServant aidaServant) {
        this.aidaServant = aidaServant;
    }

    void setRmiClient(RmiClient rmiClient) {
        this.rmiClient = rmiClient;
    }

    void disconnect() {
        try {
            RmiServantImpl.unexportObject(this, true);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.rmiClient = null;
        this.aidaServant = null;
    }

    protected RmiConverter findConverter(String aidaType) {
        RmiConverter converter = null;
        if (this.converters.containsKey(aidaType)) {
            converter = (RmiConverter)this.converters.get(aidaType);
        } else {
            Lookup.Template template = new Lookup.Template(RmiConverter.class, aidaType, null);
            Lookup.Item item = FreeHEPLookup.instance().lookupItem(template);
            if (item == null) {
                throw new IllegalArgumentException("No Converter for AIDA Type: " + aidaType);
            }
            converter = (RmiConverter)item.getInstance();
            this.converters.put(aidaType, converter);
        }
        return converter;
    }

    public Object find(String path) throws RemoteException {
        Object mo = this.aidaServant.find(path);
        String aidaType = null;
        aidaType = mo instanceof ManagedObject ? ((ManagedObject)mo).getAIDAType() : mo.getClass().getName();
        RmiConverter converter = this.findConverter(aidaType);
        Object data = converter.extractData(mo);
        return data;
    }

    public String[] listObjectNames(String path) throws RemoteException {
        return this.aidaServant.listObjectNames(path);
    }

    public String[] listObjectTypes(String path) throws RemoteException {
        return this.aidaServant.listObjectTypes(path);
    }

    public void setValid(String[] nodePaths) throws RemoteException {
        this.aidaServant.setValid(nodePaths);
    }

    public AidaUpdateEvent[] updates() throws RemoteException {
        return this.aidaServant.updates();
    }

    public void stateChanged(AidaUpdateEvent[] events) {
        try {
            this.rmiClient.stateChanged(events);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }
}

