/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote.testRemote;

import hep.aida.ref.remote.RemoteConnectionException;
import hep.aida.ref.remote.interfaces.AidaTreeClient;
import hep.aida.ref.remote.interfaces.AidaTreeServant;
import hep.aida.ref.remote.interfaces.AidaTreeServer;
import hep.aida.ref.remote.testRemote.AidaTreeServantTest;
import hep.aida.ref.remote.testRemote.TestUtils;
import java.util.Hashtable;
import java.util.Map;

public class AidaTreeServerTest
implements AidaTreeServer {
    private Map hash;
    private boolean supportDuplex;
    private String treeName;
    private long serverUpdateInterval;

    public AidaTreeServerTest() {
        this(null);
    }

    public AidaTreeServerTest(String treeName) {
        this(treeName, true);
    }

    public AidaTreeServerTest(String treeName, boolean supportDuplex) {
        this(treeName, supportDuplex, -1L);
    }

    public AidaTreeServerTest(String treeName, boolean supportDuplex, long serverUpdateInterval) {
        this.treeName = treeName;
        this.supportDuplex = supportDuplex;
        this.serverUpdateInterval = serverUpdateInterval;
        this.initServerTest();
    }

    public void initServerTest() {
        if (this.hash == null) {
            this.hash = new Hashtable();
        } else {
            this.hash.clear();
        }
    }

    public boolean disconnect(Object client) {
        boolean ok = false;
        AidaTreeServant servant = (AidaTreeServant)this.hash.remove(client);
        if (servant instanceof AidaTreeServantTest) {
            ((AidaTreeServantTest)servant).disconnect();
        }
        ok = true;
        return ok;
    }

    public AidaTreeServant connectDuplex(AidaTreeClient client) {
        if (this.hash.containsKey(client)) {
            throw new RemoteConnectionException("AidaTreeServerTest.connectDuplex This client is already connected: " + client);
        }
        if (!this.supportDuplex) {
            throw new RemoteConnectionException("AidaTreeServerTest.connectDuplex This server does not support duplex mode!");
        }
        AidaTreeServantTest servant = new AidaTreeServantTest(client, true, this.serverUpdateInterval);
        this.hash.put(client, servant);
        return servant;
    }

    public AidaTreeServant connectNonDuplex(String clientID) {
        if (this.hash.containsKey(clientID)) {
            throw new RemoteConnectionException("AidaTreeServerTest.connectNonDuplex This client is already connected: " + clientID);
        }
        AidaTreeServantTest servant = new AidaTreeServantTest(null, false, this.serverUpdateInterval);
        this.hash.put(clientID, servant);
        return servant;
    }

    public boolean disconnectDuplex(AidaTreeClient client) {
        return this.disconnect(client);
    }

    public boolean disconnectNonDuplex(String clientID) {
        return this.disconnect(clientID);
    }

    public boolean supportDuplexMode() {
        return this.supportDuplex;
    }

    public String treeName() {
        if (this.treeName == null) {
            return TestUtils.treeName();
        }
        return this.treeName;
    }
}

