/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote.testRemote;

import java.text.DateFormat;
import java.util.Date;
import java.util.StringTokenizer;

public class TestUtils {
    private static String treeName = "TestTreeName";
    private static String[] dirNames1 = new String[]{"dir1-1", "dir1-2", "Object1"};
    private static String[] dirNames2 = new String[]{"dir2-1", "dir2-2", "Object2"};
    private static String[] dirNames3 = new String[]{"dir3-1", "dir3-2", "Object3"};
    private static Object[] dirs = new Object[]{dirNames1, dirNames2, dirNames3};
    private static String[] dirTypes = new String[]{"dir", "dir", "RemoteManagedObjectTest"};

    public static String[] stringToArray(String path) {
        String[] result = null;
        if (path == null || path.equals("")) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(path, "/");
        int nTokens = tokenizer.countTokens();
        result = new String[nTokens];
        for (int i = 0; i < nTokens; ++i) {
            result[i] = tokenizer.nextToken().trim();
        }
        return result;
    }

    public static String arrayToString(String[] path) {
        String result = "";
        if (path == null || path.length == 0) {
            return null;
        }
        for (int i = 0; i < path.length; ++i) {
            result = result + "/" + path[i].trim();
        }
        return result;
    }

    public static String getCurrentTime() {
        Date date = new Date(System.currentTimeMillis());
        String tmpString = DateFormat.getDateTimeInstance().format(date);
        StringTokenizer st = new StringTokenizer(tmpString);
        String dateString = "";
        while (st.hasMoreTokens()) {
            dateString = dateString + st.nextToken();
            if (!st.hasMoreTokens()) continue;
            dateString = dateString + "_";
        }
        int index = dateString.indexOf(",");
        if (index > 0 && index < dateString.length() - 1) {
            dateString = dateString.substring(0, index - 1) + dateString.substring(index + 1);
        }
        return dateString;
    }

    public static Object find(String path) throws IllegalArgumentException {
        System.out.println("TestUtils.find: path=" + path);
        String[] p = TestUtils.stringToArray(path);
        String time = null;
        if (p == null || !p[p.length - 1].startsWith("Object")) {
            throw new IllegalArgumentException("Illegal path: " + path);
        }
        time = p[p.length - 1] + "_" + TestUtils.getCurrentTime();
        return time;
    }

    public static String[] listObjectNames(String path) throws IllegalArgumentException {
        System.out.println("TestUtils.listObjectNames: path=" + path);
        if (path.equals("/")) {
            return new String[]{"Tests"};
        }
        String[] p = TestUtils.stringToArray(path);
        if (p.length < 4) {
            String[] tmp = (String[])dirs[p.length - 1];
            String[] result = new String[tmp.length];
            for (int i = 0; i < tmp.length; ++i) {
                result[i] = path + "/" + tmp[i];
            }
            return result;
        }
        if (p.length == 4) {
            return null;
        }
        throw new IllegalArgumentException("Illegal path: " + path);
    }

    public static String[] listObjectTypes(String path) throws IllegalArgumentException {
        System.out.println("TestUtils.listObjectTypes: path=" + path);
        if (path.equals("/")) {
            return new String[]{"dir"};
        }
        String[] p = TestUtils.stringToArray(path);
        if (p.length < 4) {
            return dirTypes;
        }
        if (p.length == 4) {
            return null;
        }
        throw new IllegalArgumentException("Illegal path: " + path);
    }

    public static String treeName() {
        return treeName;
    }
}

