/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.root;

import hep.aida.ITuple;
import hep.aida.ref.root.TLeafBColumn;
import hep.aida.ref.root.TLeafCColumn;
import hep.aida.ref.root.TLeafColumn;
import hep.aida.ref.root.TLeafDColumn;
import hep.aida.ref.root.TLeafFColumn;
import hep.aida.ref.root.TLeafFolderColumn;
import hep.aida.ref.root.TLeafIColumn;
import hep.aida.ref.root.TLeafObjectColumn;
import hep.aida.ref.tuple.AbstractTuple;
import hep.io.root.RootClassNotFound;
import hep.io.root.interfaces.TKey;
import hep.io.root.interfaces.TLeaf;
import hep.io.root.interfaces.TLeafB;
import hep.io.root.interfaces.TLeafC;
import hep.io.root.interfaces.TLeafD;
import hep.io.root.interfaces.TLeafF;
import hep.io.root.interfaces.TLeafI;
import hep.io.root.interfaces.TTree;
import hep.tuple.Cursor;
import hep.tuple.interfaces.FTuple;
import hep.tuple.interfaces.FTupleColumn;
import hep.tuple.interfaces.FTupleCursor;
import java.io.IOException;
import org.freehep.util.Value;

class TTreeTuple
extends AbstractTuple
implements FTuple {
    private Cursor cursor;
    private TKey key;
    private Value theValue;
    private TLeafColumn[] columns;
    private int nCol;

    TTreeTuple(TKey key, String name) {
        super(name);
        this.setTitle(key.getTitle());
        this.key = key;
        this.nCol = this.tree().getLeaves().size();
        this.cursor = new Cursor(0, this.rows(), true);
        this.columns = new TLeafColumn[this.nCol];
        this.theValue = new Value();
        TLeafFolderColumn subTuple = null;
        TLeafI lastDim = null;
        int n = 0;
        for (int i = 0; i < this.nCol; ++i) {
            TLeaf leaf = (TLeaf)this.tree().getLeaves().get(i);
            int nDim = leaf.getArrayDim();
            if (nDim == 0) {
                if (leaf instanceof TLeafI) {
                    this.columns[n++] = new TLeafIColumn((TLeafI)leaf);
                    continue;
                }
                if (leaf instanceof TLeafF) {
                    this.columns[n++] = new TLeafFColumn((TLeafF)leaf);
                    continue;
                }
                if (leaf instanceof TLeafD) {
                    this.columns[n++] = new TLeafDColumn((TLeafD)leaf);
                    continue;
                }
                if (leaf instanceof TLeafB) {
                    this.columns[n++] = new TLeafBColumn((TLeafB)leaf);
                    continue;
                }
                if (leaf instanceof TLeafC) {
                    this.columns[n++] = new TLeafCColumn((TLeafC)leaf);
                    continue;
                }
                System.out.println("Ignored column " + leaf.getName() + " of type " + leaf.getClass());
                continue;
            }
            TLeafI dim = (TLeafI)leaf.getLeafCount();
            if (dim == null) {
                this.columns[n++] = new TLeafObjectColumn(leaf);
                continue;
            }
            if (dim == lastDim) {
                subTuple.addColumn(leaf);
                continue;
            }
            subTuple = new TLeafFolderColumn(dim);
            this.columns[n++] = subTuple;
            subTuple.addColumn(leaf);
            lastDim = dim;
        }
        this.nCol = n;
    }

    public boolean getBoolean(int col) throws ClassCastException {
        this.columns[col].getValue(this.cursor.row(), this.theValue);
        return this.theValue.getBoolean();
    }

    public byte getByte(int col) throws ClassCastException {
        this.columns[col].getValue(this.cursor.row(), this.theValue);
        return this.theValue.getByte();
    }

    public char getChar(int col) throws ClassCastException {
        this.columns[col].getValue(this.cursor.row(), this.theValue);
        return this.theValue.getChar();
    }

    public double getDouble(int col) throws ClassCastException {
        this.columns[col].getValue(this.cursor.row(), this.theValue);
        return this.theValue.getDouble();
    }

    public float getFloat(int col) throws ClassCastException {
        this.columns[col].getValue(this.cursor.row(), this.theValue);
        return this.theValue.getFloat();
    }

    public boolean isInMemory() {
        return false;
    }

    public int getInt(int col) throws ClassCastException {
        this.columns[col].getValue(this.cursor.row(), this.theValue);
        return this.theValue.getInt();
    }

    public long getLong(int col) throws ClassCastException {
        this.columns[col].getValue(this.cursor.row(), this.theValue);
        return this.theValue.getLong();
    }

    public Object getObject(int col) throws ClassCastException {
        this.columns[col].getValue(this.cursor.row(), this.theValue);
        return this.theValue.getObject();
    }

    public void setRow(int row) throws IllegalArgumentException {
        this.cursor.setRow(row);
    }

    public short getShort(int col) throws ClassCastException {
        this.columns[col].getValue(this.cursor.row(), this.theValue);
        return this.theValue.getShort();
    }

    public String getString(int col) throws ClassCastException {
        this.columns[col].getValue(this.cursor.row(), this.theValue);
        return this.theValue.getString();
    }

    public ITuple getTuple(int col) {
        this.columns[col].getValue(this.cursor.row(), this.theValue);
        return (ITuple)this.theValue.getObject();
    }

    public FTuple tuple(int col) {
        this.columns[col].getValue(this.cursor.row(), this.theValue);
        return (FTuple)this.theValue.getObject();
    }

    public void close() {
    }

    public FTupleColumn column(int index) {
        return this.columns[index];
    }

    public FTupleColumn columnByName(String name) {
        int n = this.columnIndexByName(name);
        if (n < 0) {
            return null;
        }
        return this.column(n);
    }

    public int columnIndexByName(String name) {
        for (int i = 0; i < this.columns.length; ++i) {
            if (!this.columns[i].name().equals(name)) continue;
            return i;
        }
        return -1;
    }

    public double columnMax(int index) throws IllegalArgumentException {
        this.columns[index].maxValue(this.theValue);
        return this.theValue.getDouble();
    }

    public double columnMean(int index) throws IllegalArgumentException {
        this.columns[index].meanValue(this.theValue);
        return this.theValue.getDouble();
    }

    public double columnMin(int index) throws IllegalArgumentException {
        this.columns[index].minValue(this.theValue);
        return this.theValue.getDouble();
    }

    public String columnName(int index) throws IllegalArgumentException {
        return this.columns[index].name();
    }

    public String[] columnNames() throws IllegalArgumentException {
        String[] names = new String[this.columns.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.columns[i].name();
        }
        return names;
    }

    public double columnRms(int index) throws IllegalArgumentException {
        this.columns[index].rmsValue(this.theValue);
        return this.theValue.getDouble();
    }

    public Class columnType(int index) throws IllegalArgumentException {
        return this.columns[index].type();
    }

    public Class[] columnTypes() throws IllegalArgumentException {
        Class[] types = new Class[this.columns.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = this.columns[i].type();
        }
        return types;
    }

    public void columnValue(int index, FTupleCursor cursor, Value value) {
        this.columns[index].getValue(cursor.row(), value);
    }

    public int columns() {
        return this.nCol;
    }

    public FTupleCursor cursor() throws IllegalStateException {
        return new Cursor(0, this.rows(), true);
    }

    public int findColumn(String name) throws IllegalArgumentException {
        int n = this.columnIndexByName(name);
        if (n < 0) {
            throw new IllegalArgumentException("Unknown column " + name);
        }
        return n;
    }

    public boolean next() {
        return this.cursor.next();
    }

    public int rows() {
        return (int)this.tree().getEntries();
    }

    public void skip(int n) throws IllegalArgumentException {
        this.cursor.skip(n);
    }

    public void start() {
        this.cursor.start();
    }

    public boolean supportsMultipleCursors() {
        return true;
    }

    public boolean supportsRandomAccess() {
        return true;
    }

    private TTree tree() {
        try {
            return (TTree)this.key.getObject();
        }
        catch (RootClassNotFound x) {
            throw new RuntimeException("Root Class Not Found " + x.getClassName());
        }
        catch (IOException x) {
            throw new RuntimeException("IOException reading root file");
        }
    }
}

