/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.tuple;

import hep.aida.IAnalysisFactory;
import hep.aida.IFilter;
import hep.aida.ITree;
import hep.aida.ITuple;
import hep.aida.ITupleFactory;
import hep.aida.ref.tuple.AbstractTuple;
import hep.tuple.interfaces.FTuple;
import hep.tuple.interfaces.FTupleColumn;
import hep.tuple.interfaces.FTupleCursor;
import hep.tuple.interfaces.FillableTuple;
import java.util.Random;
import org.freehep.util.Value;

public class ChainedTuple
extends AbstractTuple {
    private ITuple[] set;
    private int currentRow;
    private ITuple currentTuple;
    private int currentTupleID;
    private int currentTupleRow;
    private ChainedColumn[] columns;
    private ChainedTuple[] tuples;
    private Value v = new Value();
    static /* synthetic */ Class class$hep$aida$ITuple;

    public ChainedTuple(String name, String title, ITuple[] set) {
        super(name);
        int nCol = 0;
        if (set.length > 1) {
            nCol = set[0].columns();
            String[] colNames = new String[nCol];
            Class[] colTypes = new Class[nCol];
            for (int i = 0; i < nCol; ++i) {
                colNames[i] = set[0].columnName(i);
                colTypes[i] = set[0].columnType(i);
            }
            for (int n = 1; n < set.length; ++n) {
                if (set[n].columns() != nCol) {
                    throw new IllegalArgumentException("ITuples in the set have different number of columns!");
                }
                for (int i = 0; i < nCol; ++i) {
                    if (!colNames[i].equals(set[n].columnName(i))) {
                        throw new IllegalArgumentException("ITuples in the set have different column names!");
                    }
                    if (colTypes[i] == set[n].columnType(i)) continue;
                    throw new IllegalArgumentException("ITuples in the set have different column types!");
                }
            }
        } else {
            throw new IllegalArgumentException("Not enough tuples provided. Two or more tuples must be chained together.");
        }
        this.columns = new ChainedColumn[nCol];
        this.tuples = new ChainedTuple[nCol];
        for (int i = 0; i < nCol; ++i) {
            this.columns[i] = new ChainedColumn(set, i);
            if (this.columns[i].type() != (class$hep$aida$ITuple == null ? ChainedTuple.class$("hep.aida.ITuple") : class$hep$aida$ITuple)) continue;
            ITuple[] folders = new ITuple[set.length];
            for (int j = 0; j < set.length; ++j) {
                set[j].start();
                folders[j] = set[j].getTuple(i);
            }
            this.tuples[i] = new ChainedTuple(this.columns[i].name(), "", folders);
        }
        this.setTitle(title);
        this.set = set;
        this.currentRow = -1;
        this.currentTuple = set[0];
        this.currentTuple.start();
        this.currentTupleID = 0;
        this.currentTupleRow = -1;
    }

    public String columnDefaultString(int column) {
        this.columns[column].defaultValue(this.v);
        return this.v.toString();
    }

    public int columns() {
        return this.columns.length;
    }

    public String columnName(int column) {
        return this.set[0].columnName(column);
    }

    public String[] columnNames() {
        return this.set[0].columnNames();
    }

    public Class columnType(int column) {
        return this.set[0].columnType(column);
    }

    public Class[] columnTypes() {
        return this.set[0].columnTypes();
    }

    public double columnMin(int column) {
        double min = Double.NaN;
        for (int i = 0; i < this.set.length; ++i) {
            double tmp = this.set[i].columnMin(column);
            if (!Double.isNaN(min) && !(tmp < min)) continue;
            min = tmp;
        }
        return min;
    }

    public double columnMax(int column) {
        double max = Double.NaN;
        for (int i = 0; i < this.set.length; ++i) {
            double tmp = this.set[i].columnMax(column);
            if (!Double.isNaN(max) && !(tmp > max)) continue;
            max = tmp;
        }
        return max;
    }

    public double columnMean(int column) {
        double mean = 0.0;
        int rows = 0;
        for (int i = 0; i < this.set.length; ++i) {
            double m = this.set[i].columnMean(column);
            int r = this.set[i].rows();
            if (r <= 0) continue;
            if (!Double.isNaN(m)) {
                mean += m * (double)r;
                rows += r;
                continue;
            }
            return Double.NaN;
        }
        return mean / (double)rows;
    }

    public double columnRms(int column) {
        double rms = 0.0;
        int rows = 0;
        for (int i = 0; i < this.set.length; ++i) {
            double m = this.set[i].columnMean(column);
            double rm = this.set[i].columnRms(column);
            int r = this.set[i].rows();
            if (r <= 0) continue;
            if (!Double.isNaN(m) && !Double.isNaN(rm)) {
                rms += (rm * rm + m * m) * (double)r;
                rows += r;
                continue;
            }
            return Double.NaN;
        }
        return Math.sqrt(rms / (double)rows - Math.pow(this.columnMean(column), 2.0));
    }

    public int rows() {
        int rows = 0;
        for (int i = 0; i < this.set.length; ++i) {
            int r = this.set[i].rows();
            if (r <= 0) continue;
            rows += r;
        }
        return rows;
    }

    public int getRow() {
        return this.currentRow;
    }

    public ITuple getTuple(int column) {
        return this.tuples[column];
    }

    public void setRow(int row) {
        if (row > this.rows()) {
            throw new IllegalArgumentException("Row " + row + " is bigger than the length of this ChainedTuple (" + this.rows() + ")");
        }
        int rows = 0;
        int i = 0;
        int r = 0;
        Object tup = null;
        for (i = 0; i < this.set.length; ++i) {
            r = this.set[i].rows();
            if (rows < row && rows + r > row) break;
            if (r <= 0) continue;
            rows += r;
        }
        this.currentRow = row;
        this.currentTupleID = i;
        this.currentTuple = this.set[this.currentTupleID];
        this.currentTupleRow = row - rows;
        this.currentTuple.setRow(this.currentTupleRow);
    }

    public void start() {
        this.currentRow = -1;
        this.currentTupleID = 0;
        this.currentTuple = this.set[this.currentTupleID];
        this.currentTuple.start();
        this.currentTupleRow = -1;
    }

    public void skip(int rows) {
        this.setRow(this.currentRow + rows);
    }

    public boolean next() {
        if (this.currentTuple.next()) {
            ++this.currentRow;
            ++this.currentTupleRow;
            return true;
        }
        if (this.currentTupleID < this.set.length - 1) {
            ++this.currentTupleID;
            this.currentTuple = this.set[this.currentTupleID];
            this.currentTuple.start();
            this.currentTupleRow = 0;
            if (!this.currentTuple.next()) {
                return this.next();
            }
            ++this.currentRow;
            return true;
        }
        return false;
    }

    public int findColumn(String name) throws IllegalArgumentException {
        return this.set[0].findColumn(name);
    }

    public int getInt(int column) throws ClassCastException {
        return this.currentTuple.getInt(column);
    }

    public short getShort(int column) throws ClassCastException {
        return this.currentTuple.getShort(column);
    }

    public long getLong(int column) throws ClassCastException {
        return this.currentTuple.getLong(column);
    }

    public float getFloat(int column) throws ClassCastException {
        return this.currentTuple.getFloat(column);
    }

    public double getDouble(int column) throws ClassCastException {
        return this.currentTuple.getDouble(column);
    }

    public boolean getBoolean(int column) throws ClassCastException {
        return this.currentTuple.getBoolean(column);
    }

    public byte getByte(int column) throws ClassCastException {
        return this.currentTuple.getByte(column);
    }

    public char getChar(int column) throws ClassCastException {
        return this.currentTuple.getChar(column);
    }

    public String getString(int column) throws ClassCastException {
        return this.currentTuple.getString(column);
    }

    public Object getObject(int column) throws ClassCastException {
        return this.currentTuple.getObject(column);
    }

    public void addColumn(FTupleColumn column) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public void addTuple(FillableTuple tuple) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public void close() {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public FTupleColumn column(int index) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public FTupleColumn columnByName(String name) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public int columnIndexByName(String name) {
        return this.findColumn(name);
    }

    public void columnMaxValue(int column, Value value) {
        value.set(this.columnMax(column));
    }

    public void columnMeanValue(int column, Value value) {
        value.set(this.columnMean(column));
    }

    public void columnMinValue(int column, Value value) {
        value.set(this.columnMin(column));
    }

    public void columnRmsValue(int column, Value value) {
        value.set(this.columnRms(column));
    }

    public void columnValue(int column, FTupleCursor cursor, Value value) {
        if (this.currentTuple instanceof FTuple) {
            ((FTuple)this.currentTuple).columnValue(column, cursor, value);
        }
    }

    public FTupleCursor cursor() throws IllegalStateException {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public void fill(int column, Value value) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public void removeColumn(FTupleColumn column) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public void removeTuple(FillableTuple tuple) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public boolean supportsMultipleCursors() {
        return false;
    }

    public boolean supportsRandomAccess() {
        return false;
    }

    public FTuple tuple(int index) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public static void main(String[] args) {
        IAnalysisFactory af = IAnalysisFactory.create();
        ITree tree = af.createTreeFactory().create();
        ITupleFactory tf = af.createTupleFactory(tree);
        Random r = new Random();
        ITuple tup1 = tf.create("tup1", "tup1", "int n, double x");
        ITuple tup2 = tf.create("tup2", "tup2", "int n, double x");
        ITuple tup3 = tf.create("tup3", "tup3", "int n, double x");
        ITuple tup4 = tf.create("tup4", "tup4", "int n, double x");
        for (int i = 0; i < 20; ++i) {
            tup1.fill(0, i);
            tup2.fill(0, i + 20);
            tup3.fill(0, i + 40);
            tup4.fill(0, i + 60);
            tup1.fill(1, r.nextDouble() * 10.0);
            tup2.fill(1, r.nextDouble() * 10.0);
            tup3.fill(1, r.nextDouble() * 10.0);
            tup4.fill(1, r.nextDouble() * 10.0);
            tup1.addRow();
            tup2.addRow();
            tup3.addRow();
            tup4.addRow();
        }
        ITuple[] set = new ITuple[]{tup1, tup2, tup3, tup4};
        ITuple chain = tf.createChained("ChainedTuple", "New Chained Tuple", set);
        chain.start();
        System.out.println("\n\nChained Tuple:");
        while (chain.next()) {
            System.out.println(chain.getInt(0) + "\t" + chain.getDouble(1));
        }
        IFilter filter = tf.createFilter("n>14 && n<46");
        filter.initialize(chain);
        ITuple filteredTuple = tf.createFiltered("FilteredTuple", chain, filter);
        filteredTuple.start();
        System.out.println("\n\nFiltered Tuple:");
        while (filteredTuple.next()) {
            System.out.println(filteredTuple.getInt(0) + "\t" + filteredTuple.getDouble(1));
        }
    }

    public boolean isInMemory() {
        throw new UnsupportedOperationException("This method has not been implemented. Please report this problem.");
    }

    private class ChainedColumn
    implements FTupleColumn {
        private ITuple[] set;
        private int index;
        private boolean hasDefaultValue = false;

        ChainedColumn(ITuple[] set, int index) {
            this.set = set;
            this.index = index;
            if (set[0] instanceof AbstractTuple) {
                this.hasDefaultValue = true;
            }
        }

        public void defaultValue(Value value) {
            if (this.hasDefaultValue) {
                value.set(((AbstractTuple)this.set[0]).columnDefaultString(this.index));
            }
        }

        public boolean hasDefaultValue() {
            return this.hasDefaultValue();
        }

        public void maxValue(Value value) {
            double max = Double.NaN;
            for (int i = 0; i < this.set.length; ++i) {
                double tmp = this.set[i].columnMax(this.index);
                if (!Double.isNaN(max) && !(tmp > max)) continue;
                max = tmp;
            }
            value.set(max);
        }

        public void meanValue(Value value) {
            double mean = 0.0;
            int rows = 0;
            for (int i = 0; i < this.set.length; ++i) {
                double m = this.set[i].columnMean(this.index);
                int r = this.set[i].rows();
                if (r <= 0) continue;
                if (!Double.isNaN(m)) {
                    mean += m * (double)r;
                    rows += r;
                    continue;
                }
                value.set(Double.NaN);
                return;
            }
            value.set(mean / (double)rows);
        }

        public void minValue(Value value) {
            double min = Double.NaN;
            for (int i = 0; i < this.set.length; ++i) {
                double tmp = this.set[i].columnMin(this.index);
                if (!Double.isNaN(min) && !(tmp < min)) continue;
                min = tmp;
            }
            value.set(min);
        }

        public String name() {
            return this.set[0].columnName(this.index);
        }

        public void rmsValue(Value value) {
            double rms = 0.0;
            int rows = 0;
            for (int i = 0; i < this.set.length; ++i) {
                double m = this.set[i].columnMean(this.index);
                double rm = this.set[i].columnRms(this.index);
                int r = this.set[i].rows();
                if (r <= 0) continue;
                if (!Double.isNaN(m) && !Double.isNaN(rm)) {
                    rms += (rm * rm + m * m) * (double)r;
                    rows += r;
                    continue;
                }
                value.set(Double.NaN);
                return;
            }
            value.set(Math.sqrt(rms / (double)rows - Math.pow(ChainedTuple.this.columnMean(this.index), 2.0)));
        }

        public Class type() {
            return this.set[0].columnType(this.index);
        }
    }
}

