/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.tuple;

import hep.aida.ITuple;
import hep.aida.ref.AidaUtils;
import hep.aida.ref.tuple.AbstractTuple;
import hep.tuple.TupleFactory;
import hep.tuple.interfaces.FTuple;
import hep.tuple.interfaces.FTupleColumn;
import hep.tuple.interfaces.FTupleCursor;
import hep.tuple.interfaces.FTupleFactory;
import hep.tuple.interfaces.FillableTuple;
import hep.tuple.interfaces.FillableTupleColumn;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import org.freehep.util.Value;

public class Tuple
extends AbstractTuple
implements FTuple,
FillableTuple {
    private Value tupleValue = new Value();
    private String tupColumnsString = "";
    private String[] columnDefaultValues;
    private String options;
    private Map optionMap;
    private FillableTuple fTuple;
    private FTupleCursor cursor;
    private FTupleFactory fTupleFactory;
    private Hashtable folderHash = new Hashtable();
    static /* synthetic */ Class class$java$lang$String;

    public Tuple(String name, String title, String[] columnName, Class[] columnType, String options) {
        this(name, title, columnName, columnType, options, null);
    }

    public Tuple(String name, String title, String[] columnName, Class[] columnType, String options, FTupleFactory fTupleFactory) {
        super(name);
        if (fTupleFactory == null) {
            fTupleFactory = new TupleFactory();
        }
        this.initTuple(name, title, columnName, columnType, options, fTupleFactory);
    }

    public Tuple(String name, String title, String columnsString, String options) {
        this(name, title, columnsString, options, null);
    }

    public Tuple(String name, String title, String columnsString, String options, FTupleFactory fTupleFactory) {
        super(name);
        if (fTupleFactory == null) {
            fTupleFactory = new TupleFactory();
        }
        this.initTuple(name, title, columnsString, options, fTupleFactory);
    }

    protected void initTuple(String name, String title, String columnsString, String options, FTupleFactory fTupleFactory) {
        this.setTitle(title);
        this.tupColumnsString = columnsString;
        this.fTupleFactory = fTupleFactory;
        this.fTuple = fTupleFactory.createFTuple(name, title, options);
        this.cursor = this.fTuple.cursor();
        this.optionMap = AidaUtils.parseOptions(options);
        this.inspectOptions();
        if (options != null) {
            this.options = options;
        }
        StringTokenizer strT = new StringTokenizer(columnsString, ",;");
        int bracketCounter = 0;
        int nCol = 0;
        while (strT.hasMoreTokens()) {
            String token = strT.nextToken();
            if (bracketCounter == 0) {
                ++nCol;
            }
            if (token.indexOf("{") > 0) {
                ++bracketCounter;
            }
            if (token.indexOf("}") <= 0) continue;
            --bracketCounter;
        }
        if (nCol < 1) {
            throw new IllegalArgumentException("Cannot build Tuple with no columns\n");
        }
        StringTokenizer st = new StringTokenizer(columnsString, ",;");
        boolean columnIndex = false;
        bracketCounter = 0;
        String iTupleColString = "";
        String type = "";
        int colDefCount = 0;
        this.columnDefaultValues = new String[nCol];
        while (st.hasMoreTokens()) {
            String colName;
            String token = st.nextToken();
            token.trim();
            if (token.indexOf("{") > 0) {
                ++bracketCounter;
            }
            if (token.indexOf("}") > 0) {
                --bracketCounter;
            }
            iTupleColString = iTupleColString + token;
            if (st.hasMoreTokens()) {
                iTupleColString = iTupleColString + ";";
            }
            if (bracketCounter != 0) continue;
            String defaultValue = "";
            int brPos = (iTupleColString = iTupleColString.trim()).indexOf("{");
            if (brPos > 0) {
                iTupleColString.trim();
                int pos = iTupleColString.indexOf("(");
                if (pos > 0 && pos < brPos) {
                    type = iTupleColString.substring(0, pos).trim();
                    colName = iTupleColString.substring(iTupleColString.indexOf(")") + 1, brPos).trim();
                    if (colName.endsWith("=")) {
                        colName = colName.substring(0, colName.length() - 1).trim();
                    }
                    defaultValue = defaultValue + iTupleColString.substring(pos + 1, iTupleColString.indexOf(")")).trim();
                    defaultValue = defaultValue + iTupleColString.substring(brPos);
                } else {
                    int spPos = iTupleColString.indexOf(" ");
                    int eqPos = iTupleColString.indexOf("=");
                    type = iTupleColString.substring(0, spPos).trim();
                    colName = iTupleColString.substring(spPos + 1, eqPos).trim();
                    defaultValue = iTupleColString.substring(brPos).trim();
                }
            } else {
                StringTokenizer t = new StringTokenizer(token, "=");
                int tokens = t.countTokens();
                String nameAndType = t.nextToken().trim();
                if (tokens == 2) {
                    defaultValue = t.nextToken().trim();
                } else if (tokens != 1) {
                    throw new IllegalArgumentException("Wrong format " + token + "\n");
                }
                StringTokenizer tt = new StringTokenizer(nameAndType, " ");
                if (tt.countTokens() == 2) {
                    type = tt.nextToken().trim();
                }
                colName = tt.nextToken().trim();
            }
            Value value = new Value();
            Class colType = null;
            if (type.endsWith("ITuple")) {
                String defVal = defaultValue.substring(defaultValue.indexOf("{") + 1, defaultValue.lastIndexOf("}"));
                Tuple ata = new Tuple(colName, "", defVal, options, fTupleFactory);
                FillableTuple tup = ata.fTuple();
                this.fTuple.addTuple(tup);
                this.folderHash.put(tup, ata);
                this.columnDefaultValues[colDefCount++] = defVal;
            } else {
                if (type.equals("int")) {
                    colType = Integer.TYPE;
                } else if (type.equals("short")) {
                    colType = Short.TYPE;
                } else if (type.equals("long")) {
                    colType = Long.TYPE;
                } else if (type.equals("float")) {
                    colType = Float.TYPE;
                } else if (type.equals("double")) {
                    colType = Double.TYPE;
                } else if (type.equals("boolean")) {
                    colType = Boolean.TYPE;
                } else if (type.equals("byte")) {
                    colType = Byte.TYPE;
                } else if (type.equals("char")) {
                    colType = Character.TYPE;
                } else if (type.equals("string")) {
                    colType = class$java$lang$String == null ? Tuple.class$("java.lang.String") : class$java$lang$String;
                } else {
                    try {
                        colType = Class.forName(type);
                    }
                    catch (ClassNotFoundException cnfe) {
                        throw new IllegalArgumentException("Unsupported type " + type);
                    }
                }
                this.columnDefaultValues[colDefCount++] = defaultValue;
                this.fillDefaultValue(colType, defaultValue, value);
                this.fTuple.addColumn(fTupleFactory.createFTupleColumn(colName, colType, value, options));
            }
            iTupleColString = "";
        }
        this.start();
    }

    protected void initTuple(String name, String title, String[] columnName, Class[] columnType, String options, FTupleFactory fTupleFactory) {
        this.setTitle(title);
        this.fTupleFactory = fTupleFactory;
        this.fTuple = fTupleFactory.createFTuple(name, title, options);
        this.cursor = this.fTuple.cursor();
        this.optionMap = AidaUtils.parseOptions(options);
        this.inspectOptions();
        if (options != null) {
            this.options = options;
        }
        int colNames = columnName.length;
        int colTypes = columnType.length;
        if (colNames < 1) {
            throw new IllegalArgumentException("columnName cannot be empty\n");
        }
        if (colTypes < 1) {
            throw new IllegalArgumentException("columnType cannot be empty\n");
        }
        if (colNames != colTypes) {
            throw new IllegalArgumentException("The number of column names " + colNames + " is different than the number of column types " + colTypes + "\n");
        }
        int colDefCount = 0;
        this.columnDefaultValues = new String[colNames];
        for (int i = 0; i < colNames; ++i) {
            Class colType = columnType[i];
            String colName = "";
            String defaultValue = "";
            this.tupColumnsString = this.tupColumnsString + colType + " " + columnName[i];
            if (i < colNames) {
                this.tupColumnsString = this.tupColumnsString + ";";
            }
            Value value = new Value();
            if (colType == (class$hep$aida$ITuple == null ? Tuple.class$("hep.aida.ITuple") : class$hep$aida$ITuple)) {
                String iTupleString = columnName[i];
                int pos = iTupleString.indexOf(")");
                if (pos > 0) {
                    colName = iTupleString.substring(pos + 1, iTupleString.indexOf("{")).trim();
                    if (colName.endsWith("=")) {
                        colName = colName.substring(0, colName.length() - 1).trim();
                    }
                    defaultValue = defaultValue + iTupleString.substring(iTupleString.indexOf("(") + 1, pos);
                } else {
                    colName = iTupleString.indexOf("=") > 0 ? iTupleString.substring(0, iTupleString.indexOf("=")).trim() : iTupleString.trim();
                }
                if (iTupleString.indexOf("{") > 0) {
                    defaultValue = defaultValue + iTupleString.substring(iTupleString.indexOf("{"), iTupleString.lastIndexOf("}") + 1).trim();
                }
                String defVal = defaultValue.substring(defaultValue.indexOf("{") + 1, defaultValue.lastIndexOf("}"));
                Tuple ata = new Tuple(colName, "", defVal, options, fTupleFactory);
                FillableTuple tup = ata.fTuple();
                this.fTuple.addTuple(tup);
                this.folderHash.put(tup, ata);
                this.columnDefaultValues[colDefCount++] = defVal;
                continue;
            }
            colName = columnName[i];
            StringTokenizer st = new StringTokenizer(colName, "=");
            colName = st.nextToken().trim();
            if (st.hasMoreTokens()) {
                defaultValue = st.nextToken().trim();
            }
            this.fillDefaultValue(colType, defaultValue, value);
            this.columnDefaultValues[colDefCount++] = defaultValue;
            this.fTuple.addColumn(fTupleFactory.createFTupleColumn(colName, colType, value, options));
        }
        this.start();
    }

    private void fillDefaultValue(Class type, String defaultValue, Value value) {
        if (type == Integer.TYPE) {
            value.set(defaultValue.equals("") ? 0 : Integer.parseInt(defaultValue));
        } else if (type == Short.TYPE) {
            value.set(defaultValue.equals("") ? (short)0 : Short.parseShort(defaultValue));
        } else if (type == Long.TYPE) {
            value.set(defaultValue.equals("") ? 0L : Long.parseLong(defaultValue));
        } else if (type == Float.TYPE) {
            value.set(defaultValue.equals("") ? 0.0f : Float.parseFloat(defaultValue));
        } else if (type == Double.TYPE) {
            value.set(defaultValue.equals("") ? 0.0 : Double.parseDouble(defaultValue));
        } else if (type == Boolean.TYPE) {
            value.set(defaultValue.equals("") ? false : Boolean.valueOf(defaultValue));
        } else if (type == Byte.TYPE) {
            value.set(defaultValue.equals("") ? (byte)0 : Byte.parseByte(defaultValue));
        } else if (type == Character.TYPE) {
            value.set(defaultValue.equals("") ? (char)'\u0000' : defaultValue.charAt(0));
        } else {
            value.set(defaultValue);
        }
    }

    public String columnDefaultString(int column) {
        if (this.columnType(column) != ITuple.class) {
            return this.columnDefaultValues[column];
        }
        Tuple tup = (Tuple)this.folderHash.get(this.fTuple.tuple(column));
        if (tup != null) {
            return "( " + tup.getOptions() + " ) " + tup.name() + " = {" + tup.getColString() + "}";
        }
        return "null";
    }

    public boolean isInMemory() {
        return true;
    }

    protected void inspectOptions() {
    }

    public String getOptions() {
        return this.options;
    }

    public String getColString() {
        return this.tupColumnsString;
    }

    public double columnMin(int column) {
        this.fTuple.column(column).minValue(this.tupleValue);
        return this.tupleValue.getDouble();
    }

    public double columnMax(int column) {
        this.fTuple.column(column).maxValue(this.tupleValue);
        return this.tupleValue.getDouble();
    }

    public double columnMean(int column) {
        this.fTuple.column(column).meanValue(this.tupleValue);
        return this.tupleValue.getDouble();
    }

    public double columnRms(int column) {
        this.fTuple.column(column).rmsValue(this.tupleValue);
        return this.tupleValue.getDouble();
    }

    public int findColumn(String str) throws IllegalArgumentException {
        return this.fTuple.columnIndexByName(str);
    }

    public boolean getBoolean(int param) throws ClassCastException {
        this.fTuple.columnValue(param, this.cursor, this.tupleValue);
        return this.tupleValue.getBoolean();
    }

    public byte getByte(int param) throws ClassCastException {
        this.fTuple.columnValue(param, this.cursor, this.tupleValue);
        return this.tupleValue.getByte();
    }

    public char getChar(int param) throws ClassCastException {
        this.fTuple.columnValue(param, this.cursor, this.tupleValue);
        return this.tupleValue.getChar();
    }

    public double getDouble(int param) throws ClassCastException {
        this.fTuple.columnValue(param, this.cursor, this.tupleValue);
        return this.tupleValue.getDouble();
    }

    public float getFloat(int param) throws ClassCastException {
        this.fTuple.columnValue(param, this.cursor, this.tupleValue);
        return this.tupleValue.getFloat();
    }

    public int getInt(int param) throws ClassCastException {
        this.fTuple.columnValue(param, this.cursor, this.tupleValue);
        return this.tupleValue.getInt();
    }

    public long getLong(int param) throws ClassCastException {
        this.fTuple.columnValue(param, this.cursor, this.tupleValue);
        return this.tupleValue.getLong();
    }

    public Object getObject(int param) throws ClassCastException {
        this.fTuple.columnValue(param, this.cursor, this.tupleValue);
        if (this.columnType(param) != ITuple.class) {
            return this.tupleValue.getObject();
        }
        return (ITuple)this.folderHash.get(this.tupleValue.getObject());
    }

    public short getShort(int param) throws ClassCastException {
        this.fTuple.columnValue(param, this.cursor, this.tupleValue);
        return this.tupleValue.getShort();
    }

    public String getString(int param) throws ClassCastException {
        this.fTuple.columnValue(param, this.cursor, this.tupleValue);
        return this.tupleValue.getString();
    }

    public ITuple getTuple(int param) {
        return (ITuple)this.folderHash.get(this.fTuple.tuple(param));
    }

    public void fill(int column, int value) throws IllegalArgumentException {
        this.fTuple.fill(column, this.tupleValue.set(value));
    }

    public void fill(int column, short value) throws IllegalArgumentException {
        this.fTuple.fill(column, this.tupleValue.set(value));
    }

    public void fill(int column, long value) throws IllegalArgumentException {
        this.fTuple.fill(column, this.tupleValue.set(value));
    }

    public void fill(int column, double value) throws IllegalArgumentException {
        this.fTuple.fill(column, this.tupleValue.set(value));
    }

    public void fill(int column, float value) throws IllegalArgumentException {
        this.fTuple.fill(column, this.tupleValue.set(value));
    }

    public void fill(int column, boolean value) throws IllegalArgumentException {
        this.fTuple.fill(column, this.tupleValue.set(value));
    }

    public void fill(int column, byte value) throws IllegalArgumentException {
        this.fTuple.fill(column, this.tupleValue.set(value));
    }

    public void fill(int column, char value) throws IllegalArgumentException {
        this.fTuple.fill(column, this.tupleValue.set(value));
    }

    public void fill(int column, String string) throws IllegalArgumentException {
        this.fTuple.fill(column, this.tupleValue.set(string));
    }

    public void fill(int column, Object obj) throws IllegalArgumentException {
        this.fTuple.fill(column, this.tupleValue.set(obj));
    }

    public void fill(float[] values) throws IllegalArgumentException {
        int nCol = this.columns();
        if (values.length != nCol) {
            throw new IllegalArgumentException("Wrong number of values provided " + values.length + ". It has to match the number of columns " + nCol);
        }
        for (int i = 0; i < nCol; ++i) {
            this.fTuple.fill(i, this.tupleValue.set(values[i]));
        }
    }

    public void fill(double[] values) throws IllegalArgumentException {
        int nCol = this.columns();
        if (values.length != nCol) {
            throw new IllegalArgumentException("Wrong number of values provided " + values.length + ". It has to match the number of columns " + nCol);
        }
        for (int i = 0; i < nCol; ++i) {
            this.fTuple.fill(i, this.tupleValue.set(values[i]));
        }
    }

    public int row() {
        return this.cursor.row();
    }

    public void setRow(int row) {
        this.cursor.setRow(row);
    }

    public void start() {
        this.cursor = this.fTuple.cursor();
        this.cursor.start();
    }

    public void skip(int rows) {
        this.cursor.skip(rows);
    }

    public boolean next() {
        return this.cursor.next();
    }

    public void addRow() {
        this.fTuple.addRow();
    }

    public String columnName(int param) {
        return this.fTuple.columnName(param);
    }

    public String[] columnNames() {
        String[] colNames = new String[this.fTuple.columns()];
        for (int i = 0; i < colNames.length; ++i) {
            colNames[i] = this.columnName(i);
        }
        return colNames;
    }

    public Class columnType(int param) {
        Class type = this.fTuple.columnType(param);
        if (type == FillableTuple.class) {
            return ITuple.class;
        }
        return type;
    }

    public Class[] columnTypes() {
        Class[] colTypes = new Class[this.fTuple.columns()];
        for (int i = 0; i < colTypes.length; ++i) {
            colTypes[i] = this.columnType(i);
        }
        return colTypes;
    }

    public int columns() {
        return this.fTuple.columns();
    }

    public void reset() {
        this.fTuple.reset();
    }

    public void resetRow() {
        this.fTuple.resetRow();
    }

    public int rows() {
        return this.fTuple.rows();
    }

    protected FillableTuple fTuple() {
        return this.fTuple;
    }

    public void addColumn(FillableTupleColumn column) {
        this.fTuple.addColumn(column);
    }

    public void addTuple(FillableTuple tuple) {
        this.fTuple.addTuple(tuple);
    }

    public void close() {
        this.fTuple.close();
    }

    public FTupleColumn column(int index) {
        return this.fTuple.column(index);
    }

    public FTupleColumn columnByName(String name) {
        return this.fTuple.columnByName(name);
    }

    public int columnIndexByName(String name) {
        return this.fTuple.columnIndexByName(name);
    }

    public void columnValue(int column, FTupleCursor cursor, Value value) {
        this.fTuple.columnValue(column, cursor, value);
    }

    public FTupleCursor cursor() throws IllegalStateException {
        return this.fTuple.cursor();
    }

    public void fill(int column, Value value) {
        this.fTuple.fill(column, value);
    }

    public void removeColumn(FillableTupleColumn column) {
        this.fTuple.removeColumn(column);
    }

    public void removeTuple(FillableTuple tuple) {
        this.fTuple.removeTuple(tuple);
    }

    public boolean supportsMultipleCursors() {
        return this.fTuple.supportsMultipleCursors();
    }

    public boolean supportsRandomAccess() {
        return this.fTuple.supportsRandomAccess();
    }

    public FTuple tuple(int index) {
        return this.fTuple.tuple(index);
    }
}

