/*
 * Decompiled with CFR 0.152.
 */
package hep.io.hbook;

import hep.io.hbook.ColumnwiseBlock;
import hep.io.hbook.CompositeHbookObject;
import hep.io.hbook.Hbook;
import hep.io.hbook.Tuple;
import java.util.Enumeration;
import java.util.Hashtable;

public class ColumnwiseTuple
extends Tuple {
    private int id;
    private int idx;
    private Hashtable blocks = new Hashtable();
    int mapCount = 0;

    ColumnwiseTuple(CompositeHbookObject parent, String name, int length, int id, int idx) {
        super(parent, name, 1, length);
        this.id = id;
        this.idx = idx;
    }

    int getID() {
        return this.id;
    }

    public int id() {
        return this.idx;
    }

    ColumnwiseBlock getBlock(String name) {
        ColumnwiseBlock block = (ColumnwiseBlock)this.blocks.get(name);
        if (block != null) {
            return block;
        }
        block = new ColumnwiseBlock(this.id, name, this);
        this.blocks.put(name, block);
        return block;
    }

    public String toString() {
        String result = "CW Tuple: " + this.idx + " " + this.getName() + " (" + this.nChildren() + " columns " + this.getRows() + " rows)";
        return result;
    }

    void close() {
        super.close();
        Enumeration e = this.blocks.elements();
        while (e.hasMoreElements()) {
            ColumnwiseBlock b = (ColumnwiseBlock)e.nextElement();
            b.close();
        }
        Hbook.delete(this.id);
    }

    public void setCurrentRow(int row) {
        super.setCurrentRow(row);
        if (row == 1) {
            this.clearMap();
        } else if (this.mapCount > 0) {
            Hbook.setCWEvent(this.id, this.ievent);
        }
    }

    private void clearMap() {
        Enumeration e = this.blocks.elements();
        while (e.hasMoreElements()) {
            ColumnwiseBlock b = (ColumnwiseBlock)e.nextElement();
            b.clearMap();
        }
        this.mapCount = 0;
    }
}

