/*
 * Decompiled with CFR 0.152.
 */
package hep.io.hbook;

import hep.io.hbook.CompositeHbookObject;
import hep.io.hbook.HbookFileHObj;
import hep.io.hbook.HbookObject;
import java.io.IOException;

abstract class Hbook {
    private static final int VERSION = 1;
    private static boolean init = false;
    private static boolean[] luns;

    Hbook() {
    }

    static boolean getCWDataBoolean(long buffer, int offset, int size) {
        return Hbook.getCWDataInt(buffer, offset, size) != 0;
    }

    static native double getCWDataDouble(long var0, int var2, int var3);

    static native int getCWDataInt(long var0, int var2, int var3);

    static native long getCWDataLong(long var0, int var2, int var3);

    static native String getCWDataString(long var0, int var2, int var3);

    static synchronized native void setCWEvent(int var0, int var1);

    static native double getRWData(long var0, int var2);

    static synchronized native void setRWEvent(int var0, int var1, long var2);

    static native void CWClearMap(int var0, String var1, long var2);

    static native void CWMap(int var0, String var1, long var2, String var4, int var5, int var6);

    static native double[] CWgetMinMax(int var0, long var1, int var3, int var4, int var5, int var6, int var7);

    static native double[] CWrebin(int var0, long var1, int var3, int var4, int var5, int var6, int var7, int var8, double var9, double var11);

    static native double[] Hist1DData(int var0, int var1);

    static native double[] Hist1DErrors(int var0, int var1);

    static native double[][] Hist2DData(int var0, int var1, int var2);

    static native double[][] Hist2DErrors(int var0, int var1, int var2);

    static native double[] RWrebin(int var0, int var1, int var2, int var3, double var4, double var6);

    static synchronized native long allocBuffer(int var0);

    static synchronized void close(String s, int lun) {
        Hbook.closeFile(s, lun);
        Hbook.freeLun(lun);
    }

    static synchronized native void delete(int var0);

    static synchronized native void freeBuffer(long var0);

    static native int init();

    static synchronized HbookFileHObj openFile(String s) throws IOException {
        CompositeHbookObject result;
        if (!init) {
            Hbook.doInit();
        }
        if ((result = Hbook.openFile(s, Hbook.getLun())) == null) {
            throw new IOException("Could not open " + s);
        }
        return (HbookFileHObj)result;
    }

    static synchronized native int visitChildren(HbookObject var0);

    private static synchronized int getLun() {
        for (int i = 10; i < luns.length; ++i) {
            if (!luns[i]) continue;
            Hbook.luns[i] = false;
            return i;
        }
        throw new RuntimeException("No free luns");
    }

    private static native void closeFile(String var0, int var1);

    private static void doInit() {
        String libName = "hbookAdapter";
        try {
            System.out.println("Loading " + libName + " ...");
            System.loadLibrary(libName);
            int version = Hbook.init();
            if (version != 1) {
                throw new RuntimeException("Hbook library version mismatch, expected 1 got " + version);
            }
            luns = new boolean[100];
            for (int i = 0; i < luns.length; ++i) {
                Hbook.luns[i] = true;
            }
            init = true;
        }
        catch (Throwable t) {
            RuntimeException x = new RuntimeException("Error loading native library: " + libName);
            x.initCause(t);
            throw x;
        }
    }

    private static synchronized void freeLun(int lun) {
        Hbook.luns[lun] = true;
    }

    private static native CompositeHbookObject openFile(String var0, int var1);
}

