/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.core;

import hep.io.root.RootClassNotFound;
import hep.io.root.RootFileReader;
import hep.io.root.core.BasicRootClass;
import hep.io.root.core.DefaultClassFactory;
import hep.io.root.core.GenericRootClass;
import hep.io.root.core.RootClassFactory;
import hep.io.root.core.RootClassLoader;
import hep.io.root.core.StreamerInfoNew;
import hep.io.root.interfaces.TKey;
import hep.io.root.interfaces.TStreamerInfo;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FileClassFactory
implements RootClassFactory {
    private Map classMap = new HashMap();
    private RootClassFactory defaultClassFactory;
    private RootFileReader rfr;

    public FileClassFactory(TKey streamerInfo, RootClassFactory defaultClassFactory, RootFileReader rfr) throws RootClassNotFound, IOException {
        this.defaultClassFactory = defaultClassFactory;
        this.rfr = rfr;
        List tList = (List)((Object)streamerInfo.getObject());
        Iterator<Object> i = tList.iterator();
        while (i.hasNext()) {
            TStreamerInfo element = (TStreamerInfo)i.next();
            String key = element.getName();
            StreamerInfoNew info = new StreamerInfoNew(element);
            this.classMap.put(key, DefaultClassFactory.findClass(key, info));
        }
        i = this.classMap.values().iterator();
        while (i.hasNext()) {
            GenericRootClass info = (GenericRootClass)i.next();
            try {
                info.resolve(this);
            }
            catch (RootClassNotFound x) {
                x.printStackTrace();
            }
        }
    }

    public RootClassLoader getLoader() {
        return this.defaultClassFactory.getLoader();
    }

    public BasicRootClass create(String name) throws RootClassNotFound {
        BasicRootClass klass = (BasicRootClass)this.classMap.get(name);
        if (klass != null) {
            return klass;
        }
        return this.defaultClassFactory.create(name);
    }
}

