/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.core;

import hep.io.root.RootClass;
import hep.io.root.RootMember;
import hep.io.root.core.BasicRootClass;
import hep.io.root.core.RootClassFactory;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.Type;

abstract class IntrinsicRootClass
extends BasicRootClass {
    private static final Type[] objectArrayArgType = new Type[]{new ArrayType((Type)Type.OBJECT, 1)};
    private static final RootClass[] none = new RootClass[0];
    private static final RootMember[] noMembers = new RootMember[0];
    private BasicType type;
    private Class javaClass;
    private String name;
    private String readMethod;
    private Type[] arrayArgType;

    IntrinsicRootClass(String name, BasicType type, Class javaClass, String readMethod) {
        this.name = name;
        this.type = type;
        this.javaClass = javaClass;
        this.readMethod = readMethod;
        this.arrayArgType = new Type[]{new ArrayType((Type)type, 1)};
    }

    public int getCheckSum() {
        return 0;
    }

    public String getClassName() {
        return this.name;
    }

    public Class getJavaClass() {
        return this.javaClass;
    }

    public Type getJavaType() {
        return this.type;
    }

    public RootMember[] getMembers() {
        return noMembers;
    }

    public RootClass[] getSuperClasses() {
        return none;
    }

    public int getVersion() {
        return 0;
    }

    public void generateReadArrayCode(InstructionList il, InstructionFactory factory, ConstantPoolGen cp, int dim, int[] maxIndex) {
        for (int i = 0; i < dim; ++i) {
            il.append((CompoundInstruction)new PUSH(cp, maxIndex[i]));
        }
        il.append(factory.createNewArray((Type)this.type, (short)dim));
        il.append((Instruction)InstructionFactory.DUP_X1);
        if (dim == 1) {
            il.append((Instruction)factory.createInvoke("hep.io.root.core.RootInput", "readFixedArray", (Type)Type.VOID, this.arrayArgType, (short)185));
        } else {
            il.append((Instruction)factory.createInvoke("hep.io.root.core.RootInput", "readMultiArray", (Type)Type.VOID, objectArrayArgType, (short)185));
        }
    }

    public void generateReadCode(InstructionList il, InstructionFactory factory, ConstantPoolGen cp) {
        il.append((Instruction)factory.createInvoke("hep.io.root.core.RootInput", this.readMethod, (Type)this.type, Type.NO_ARGS, (short)185));
    }

    public boolean instanceOf(RootClass superClass) {
        return superClass == this;
    }

    public void resolve(RootClassFactory factory) {
    }
}

