/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.core;

import hep.io.root.RootClass;
import hep.io.root.RootClassNotFound;
import hep.io.root.core.BasicMember;
import hep.io.root.core.BasicRootClass;
import hep.io.root.core.GenericRootClass;
import hep.io.root.core.IntrinsicRootClass;
import hep.io.root.core.RootClassFactory;
import hep.io.root.core.StreamerInfo;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.Type;

public class StreamerInfoString
extends StreamerInfo {
    private String description;

    public StreamerInfoString(String description) {
        this.description = description;
    }

    int getBits() {
        return 0;
    }

    int getCheckSum() {
        return 0;
    }

    int getVersion() {
        return 0;
    }

    void resolve(RootClassFactory factory) throws RootClassNotFound {
        if (this.description != null) {
            Vector<BasicRootClass> sv = new Vector<BasicRootClass>();
            Vector<MemberString> mv = new Vector<MemberString>();
            StringTokenizer tokenizer = new StringTokenizer(this.description, ";");
            while (tokenizer.hasMoreTokens()) {
                int pos;
                String token = tokenizer.nextToken();
                StringTokenizer t2 = new StringTokenizer(token, " ");
                if (t2.countTokens() == 1) {
                    String className = t2.nextToken();
                    BasicRootClass superClass = factory.create(className);
                    sv.addElement(superClass);
                    continue;
                }
                int index = 1;
                String type = t2.nextToken();
                String name = t2.nextToken();
                boolean pointer = type.endsWith("*");
                if (pointer) {
                    type = type.substring(0, type.length() - 1);
                }
                if ((pos = type.indexOf(91)) > 0) {
                    int l = type.length();
                    index = Integer.parseInt(type.substring(pos + 1, l - 1));
                    type = type.substring(0, pos);
                }
                BasicRootClass memberClass = factory.create(type);
                mv.addElement(new MemberString(memberClass, name, pointer, index));
            }
            this.superClasses = new RootClass[sv.size()];
            sv.copyInto(this.superClasses);
            this.members = new MemberString[mv.size()];
            mv.copyInto(this.members);
            this.description = null;
        }
    }

    private class MemberString
    extends BasicMember {
        private BasicRootClass type;
        private String name;
        private boolean pointer;
        private int dim;

        MemberString(BasicRootClass type, String name, boolean pointer, int dim) {
            this.type = type;
            this.name = name;
            this.pointer = pointer;
            this.dim = dim;
        }

        public int getArrayDim() {
            return this.dim == 1 ? 0 : 1;
        }

        public String getComment() {
            return null;
        }

        public Type getJavaType() {
            Type t = this.type.getJavaTypeForMethod();
            if (this.dim > 1) {
                t = new ArrayType(t, 1);
            }
            return t;
        }

        public int getMaxIndex(int index) {
            return this.dim;
        }

        public String getName() {
            return this.name;
        }

        public RootClass getType() {
            return this.type;
        }

        public void generateReadCode(InstructionList il, InstructionFactory factory, ConstantPoolGen cp, String className) {
            if (this.pointer) {
                ((GenericRootClass)this.type).generateReadPointerCode(il, factory, cp);
            } else if (this.dim == 1) {
                this.type.generateReadCode(il, factory, cp);
            } else {
                ((IntrinsicRootClass)this.type).generateReadArrayCode(il, factory, cp, 1, new int[]{this.dim});
            }
            if (this.type.getConvertMethod() != null) {
                il.append((Instruction)factory.createInvoke("hep.io.root.interfaces." + this.type.getClassName(), this.type.getConvertMethod(), this.type.getJavaTypeForMethod(), Type.NO_ARGS, (short)185));
            }
        }

        boolean isPointer() {
            return this.pointer;
        }
    }
}

