/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.reps;

import hep.io.root.core.AbstractRootObject;
import hep.io.root.core.RootInput;
import hep.io.root.interfaces.TBasket;
import hep.io.root.interfaces.TDatime;
import hep.io.root.interfaces.TLeaf;
import java.io.IOException;
import java.util.Date;

public abstract class TBasketRep
extends AbstractRootObject
implements TBasket {
    private Date fDatime;
    private RootInput data;
    private RootInput rin;
    private String fClassName;
    private String fName;
    private String fTitle;
    private byte[] fBufferRef;
    private int[] fDisplacement;
    private int[] fEntryOffset;
    private byte flag;
    private int fBufferSize;
    private int fLast;
    private int fNbytes;
    private int fNevBuf;
    private int fNevBufSize;
    private int fObjlen;
    private int fSeekKey;
    private int fSeekPdir;
    private short fCycle;
    private short fKeylen;

    public RootInput setPosition(int index, int offset, TLeaf leaf) throws IOException {
        int i = index - offset;
        if (this.fEntryOffset == null) {
            this.data.setPosition(this.fKeylen + i * this.fNevBufSize);
        } else {
            this.data.setPosition(this.fEntryOffset[i]);
        }
        return this.data;
    }

    public void readEntryOffsets(int len) throws IOException {
        int last = this.getLast();
        this.data.setPosition(last);
        this.fEntryOffset = new int[len];
        this.data.readArray(this.fEntryOffset);
    }

    public void readMembers(RootInput in) throws IOException {
        this.fNbytes = in.readInt();
        int v = in.readVersion();
        this.fObjlen = in.readInt();
        this.fDatime = ((TDatime)in.readObject("TDatime")).getDate();
        this.fKeylen = in.readShort();
        this.fCycle = in.readShort();
        this.fSeekKey = in.readInt();
        this.fSeekPdir = in.readInt();
        this.fClassName = in.readObject("TString").toString();
        this.fName = in.readObject("TString").toString();
        this.fTitle = in.readObject("TString").toString();
        this.rin = in.getTop();
        v = in.readVersion(this);
        this.fBufferSize = in.readInt();
        this.fNevBufSize = in.readInt();
        this.fNevBuf = in.readInt();
        this.fLast = in.readInt();
        if (this.fLast > this.fBufferSize) {
            this.fBufferSize = this.fLast;
        }
        this.flag = in.readByte();
        if (this.flag != 0 && this.flag % 10 != 2) {
            this.fEntryOffset = new int[this.fNevBufSize];
            if (this.fNevBuf != 0) {
                in.readArray(this.fEntryOffset);
            }
            if (20 < this.flag && this.flag < 40) {
                int i = 0;
                while (i < this.fNevBuf) {
                    int n = i++;
                    this.fEntryOffset[n] = this.fEntryOffset[n] & 0xFFFFFF;
                }
            }
            if (this.flag > 40) {
                this.fDisplacement = new int[this.fNevBufSize];
                in.readArray(this.fDisplacement);
            }
        }
        if (this.flag == 1 || this.flag > 10) {
            int len = v > 1 ? this.fLast : in.readInt();
            this.data = in.slice(len);
        }
        in.checkLength(this);
        if (this.data == null) {
            this.data = this.getData();
        }
    }

    abstract RootInput getData() throws IOException;
}

