/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.reps;

import hep.io.root.core.AbstractRootObject;
import hep.io.root.core.RootInput;
import hep.io.root.interfaces.TBranch;
import hep.io.root.interfaces.TLeafF;
import hep.io.root.interfaces.TLeafI;
import java.io.IOException;
import org.apache.bcel.Constants;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.Type;

public abstract class TLeafFRep
extends AbstractRootObject
implements TLeafF,
Constants {
    private Object lastValue;
    private TBranch branch;
    private float lastFloat;
    private int lastFloatIndex;
    private int lastValueIndex;

    public void setBranch(TBranch branch) {
        this.branch = branch;
        this.lastValueIndex = -1;
        this.lastFloatIndex = -1;
    }

    public float getValue(int index) throws IOException {
        try {
            if (index == this.lastFloatIndex) {
                return this.lastFloat;
            }
            this.lastFloatIndex = index;
            RootInput in = this.branch.setPosition(this, this.lastFloatIndex);
            this.lastFloat = in.readFloat();
            return this.lastFloat;
        }
        catch (IOException x) {
            this.lastFloatIndex = -1;
            throw x;
        }
    }

    public Object getWrappedValue(int index) throws IOException {
        try {
            if (index == this.lastValueIndex) {
                return this.lastValue;
            }
            this.lastValueIndex = index;
            RootInput in = this.branch.setPosition(this, index);
            int arrayDim = this.getArrayDim();
            if (arrayDim == 0) {
                this.lastValue = new Float(in.readFloat());
                return this.lastValue;
            }
            if (arrayDim == 1) {
                TLeafI count = (TLeafI)this.getLeafCount();
                int len = count == null ? this.getLen() : count.getValue(index);
                float[] array = new float[len];
                in.readFixedArray(array);
                this.lastValue = array;
                return array;
            }
            this.lastValue = this.readMultiArray(in, Float.TYPE, index);
            return this.lastValue;
        }
        catch (IOException x) {
            this.lastValueIndex = -1;
            throw x;
        }
    }

    public void generateReadCode(InstructionList il, InstructionFactory factory, ConstantPoolGen cp, String className) {
        String leafClassName = this.getClass().getName();
        int arrayDim = this.getArrayDim();
        if (arrayDim == 0) {
            il.append((Instruction)factory.createInvoke(leafClassName, "getValue", (Type)Type.FLOAT, new Type[]{Type.INT}, (short)182));
        } else {
            il.append((Instruction)factory.createInvoke(leafClassName, "getWrappedValue", (Type)Type.OBJECT, new Type[]{Type.INT}, (short)182));
        }
    }

    abstract Object[] readMultiArray(RootInput var1, Class var2, int var3);
}

