/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.reps;

import hep.io.root.core.AbstractRootObject;
import hep.io.root.core.RootInput;
import hep.io.root.interfaces.TBranch;
import hep.io.root.interfaces.TLeafI;
import java.io.IOException;
import org.apache.bcel.Constants;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.Type;

public abstract class TLeafIRep
extends AbstractRootObject
implements TLeafI,
Constants {
    private Object lastValue;
    private TBranch branch;
    private int lastInteger;
    private int lastIntegerIndex;
    private int lastValueIndex;

    public void setBranch(TBranch branch) {
        this.branch = branch;
        this.lastIntegerIndex = -1;
        this.lastValueIndex = -1;
    }

    public int getValue(int index) throws IOException {
        try {
            if (this.lastIntegerIndex == index) {
                return this.lastInteger;
            }
            this.lastIntegerIndex = index;
            RootInput in = this.branch.setPosition(this, this.lastIntegerIndex);
            this.lastInteger = in.readInt();
            return this.lastInteger;
        }
        catch (IOException x) {
            this.lastIntegerIndex = -1;
            throw x;
        }
    }

    public Object getWrappedValue(int index) throws IOException {
        try {
            if (index == this.lastValueIndex) {
                return this.lastValue;
            }
            this.lastValueIndex = index;
            RootInput in = this.branch.setPosition(this, index);
            int arrayDim = this.getArrayDim();
            if (arrayDim == 0) {
                this.lastValue = new Integer(in.readInt());
                return this.lastValue;
            }
            if (arrayDim == 1) {
                TLeafI count = (TLeafI)this.getLeafCount();
                int len = count == null ? this.getLen() : count.getValue(index);
                int[] array = new int[len];
                in.readFixedArray(array);
                this.lastValue = array;
                return array;
            }
            this.lastValue = this.readMultiArray(in, Integer.TYPE, index);
            return this.lastValue;
        }
        catch (IOException x) {
            this.lastValueIndex = -1;
            throw x;
        }
    }

    public void generateReadCode(InstructionList il, InstructionFactory factory, ConstantPoolGen cp, String className) {
        String leafClassName = this.getClass().getName();
        int arrayDim = this.getArrayDim();
        if (arrayDim == 0) {
            il.append((Instruction)factory.createInvoke(leafClassName, "getValue", (Type)Type.INT, new Type[]{Type.INT}, (short)182));
        } else {
            il.append((Instruction)factory.createInvoke(leafClassName, "getWrappedValue", (Type)Type.OBJECT, new Type[]{Type.INT}, (short)182));
        }
    }

    abstract Object[] readMultiArray(RootInput var1, Class var2, int var3);
}

