/*
 * Decompiled with CFR 0.152.
 */
package hep.io.root.util;

import hep.io.root.RootClassNotFound;
import hep.io.root.RootFileReader;
import hep.io.root.RootObject;
import hep.io.root.daemon.RootAuthenticator;
import hep.io.root.daemon.RootURLStreamFactory;
import hep.io.root.interfaces.TKey;
import hep.io.root.interfaces.TNamed;
import hep.io.root.util.BranchEntry;
import hep.io.root.util.RootDirectoryTreeCellRenderer;
import hep.io.root.util.RootDirectoryTreeModel;
import hep.io.root.util.RootObjectTreeCellRenderer;
import hep.io.root.util.RootObjectTreeModel;
import hep.io.root.util.StreamerInfoBrowser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.Authenticator;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class RootObjectBrowser
extends JPanel
implements TreeSelectionListener {
    private static final String aboutMessage = "<HTML>RootObjectBrowser $Id: RootObjectBrowser.java,v 1.17 2004/06/28 15:21:26 tonyj Exp $<br>Author: Tony Johnson (tonyj@slac.stanford.edu)";
    private static final TreeModel emptyTree = null;
    private JTree objTree;
    private JTree tree = new JTree(emptyTree);
    private RootFileReader reader;
    private RootMenuBar menuBar;

    public RootObjectBrowser() {
        super(new BorderLayout());
        this.tree.setCellRenderer(new RootDirectoryTreeCellRenderer());
        this.tree.addTreeSelectionListener(this);
        this.objTree = new JTree(emptyTree);
        this.objTree.setCellRenderer(new RootObjectTreeCellRenderer());
        ToolTipManager.sharedInstance().registerComponent(this.objTree);
        JSplitPane split = new JSplitPane(1, new JScrollPane(this.tree), new JScrollPane(this.objTree));
        this.add((Component)split, "Center");
        this.menuBar = new RootMenuBar();
        this.add((Component)this.menuBar, "North");
        this.menuBar.setFileOpen(false);
        this.setPreferredSize(new Dimension(500, 300));
        split.setDividerLocation(245);
        ToolTipManager.sharedInstance().setEnabled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRootFile(File file) throws IOException {
        Cursor old = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.reader = new RootFileReader(file);
            RootDirectoryTreeModel model = new RootDirectoryTreeModel(this.reader){

                public void handleException(IOException x) {
                    RootObjectBrowser.this.error(x);
                    x.printStackTrace();
                    super.handleException(x);
                }
            };
            this.tree.setModel(model);
            this.tree.setRowHeight(20);
            this.tree.setLargeModel(true);
            this.menuBar.setFileOpen(true);
        }
        finally {
            this.setCursor(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRootFile(URL url) throws IOException {
        Cursor old = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.reader = new RootFileReader(url);
            RootDirectoryTreeModel model = new RootDirectoryTreeModel(this.reader){

                public void handleException(IOException x) {
                    RootObjectBrowser.this.error(x);
                    x.printStackTrace();
                    super.handleException(x);
                }
            };
            this.tree.setModel(model);
            this.tree.setRowHeight(20);
            this.tree.setLargeModel(true);
            this.menuBar.setFileOpen(true);
        }
        finally {
            this.setCursor(old);
        }
    }

    public static void main(String[] argv) throws IOException {
        if (argv.length > 1) {
            RootObjectBrowser.usage();
        }
        if (argv.length == 1 && argv[0].startsWith("-")) {
            RootObjectBrowser.usage();
        }
        URL.setURLStreamHandlerFactory(new RootURLStreamFactory());
        JFrame frame = new JFrame("Root Object Browser");
        RootObjectBrowser browser = new RootObjectBrowser();
        Authenticator.setDefault(new RootAuthenticator(browser));
        URLConnection.setDefaultAllowUserInteraction(true);
        if (argv.length == 1) {
            if (argv[0].startsWith("root:")) {
                browser.setRootFile(new URL(argv[0]));
            } else {
                browser.setRootFile(new File(argv[0]));
            }
        }
        frame.setContentPane(browser);
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void valueChanged(TreeSelectionEvent event) {
        if (!event.isAddedPath()) {
            return;
        }
        Cursor old = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            TreePath path = this.tree.getSelectionPath();
            if (path == null) {
                this.objTree.setModel(emptyTree);
            } else {
                List save = this.saveToggledBranches(this.objTree);
                Object node = path.getLastPathComponent();
                if (node instanceof BranchEntry) {
                    node = ((BranchEntry)node).getValue();
                }
                if (node instanceof TKey) {
                    TKey key = (TKey)node;
                    this.objTree.setModel(new RootObjectTreeModel(key.getObject(), key.getName()));
                } else if (node instanceof TNamed) {
                    this.objTree.setModel(new RootObjectTreeModel(node, ((TNamed)node).getName()));
                } else if (node instanceof RootObject) {
                    this.objTree.setModel(new RootObjectTreeModel(node, ""));
                } else if (node.getClass().isArray()) {
                    this.objTree.setModel(new RootObjectTreeModel(node, ""));
                } else if (node instanceof List) {
                    this.objTree.setModel(new RootObjectTreeModel(node, ""));
                } else {
                    this.objTree.setModel(emptyTree);
                }
                this.restoreToggledBranches(this.objTree, save);
            }
        }
        catch (RootClassNotFound x) {
            this.objTree.setModel(emptyTree);
            x.printStackTrace();
            this.error(x);
        }
        catch (IOException x) {
            this.objTree.setModel(emptyTree);
            x.printStackTrace();
            this.error(x);
        }
        finally {
            this.setCursor(old);
        }
    }

    private static void usage() {
        System.out.println("java RootObjectBrowser [<file>]");
        System.exit(0);
    }

    private void error(Throwable x) {
        x.printStackTrace();
        JOptionPane.showMessageDialog(this, x.getMessage(), "Error", 0);
    }

    private void restoreToggledBranches(JTree tree, List save) {
        TreeModel model = tree.getModel();
        if (model == null) {
            return;
        }
        Object root = model.getRoot();
        Iterator iter = save.iterator();
        block0: while (iter.hasNext()) {
            Object parent = root;
            TreePath realPath = new TreePath(root);
            TreePath path = (TreePath)iter.next();
            Object[] nodes = path.getPath();
            for (int i = 1; i < nodes.length; ++i) {
                Object n;
                String node = (String)nodes[i];
                int pos = node.indexOf(32);
                int index = Integer.parseInt(node.substring(0, pos));
                if (index >= model.getChildCount(parent)) continue block0;
                parent = n = model.getChild(parent, index);
                if (!n.toString().equals(node.substring(pos + 1))) continue block0;
                realPath = realPath.pathByAddingChild(n);
            }
            tree.expandPath(realPath);
        }
    }

    private List saveToggledBranches(JTree tree) {
        ArrayList<TreePath> save = new ArrayList<TreePath>();
        TreeModel model = tree.getModel();
        if (model == null) {
            return save;
        }
        Object root = model.getRoot();
        TreePath rootPath = new TreePath(new Object[]{root});
        Enumeration<TreePath> e = tree.getExpandedDescendants(rootPath);
        if (e == null) {
            return save;
        }
        while (e.hasMoreElements()) {
            Object parent = root;
            TreePath path = e.nextElement();
            Object[] nodes = path.getPath();
            if (nodes.length < 2) continue;
            for (int i = 0; i < nodes.length; ++i) {
                Object node = nodes[i];
                int index = model.getIndexOfChild(parent, node);
                parent = node;
                nodes[i] = String.valueOf(index) + " " + node.toString();
            }
            TreePath newPath = new TreePath(nodes);
            save.add(newPath);
        }
        return save;
    }

    private void showStreamerInfo() {
        try {
            Comparator sortByName = new Comparator(){

                public int compare(Object a, Object b) {
                    return ((TNamed)a).getName().compareTo(((TNamed)b).getName());
                }

                public boolean equals(Object o) {
                    return o.getClass() == this.getClass();
                }
            };
            ArrayList streamerInfo = new ArrayList(this.reader.streamerInfo());
            Collections.sort(streamerInfo, sortByName);
            StreamerInfoBrowser browser = new StreamerInfoBrowser(streamerInfo);
            JFrame f = new JFrame("Root Streamer Info Browser");
            f.setContentPane(browser);
            f.setDefaultCloseOperation(2);
            f.pack();
            f.setVisible(true);
        }
        catch (IOException x) {
            this.error(x);
        }
    }

    static /* synthetic */ void access$500(RootObjectBrowser x0) {
        x0.showStreamerInfo();
    }

    private class RootToolsMenu
    extends JMenu {
        private JMenuItem view;

        RootToolsMenu() {
            super("Tools");
            this.view = new JMenuItem(this, "View Streamer Info..."){
                private final /* synthetic */ RootToolsMenu this$1;
                {
                    this.this$1 = this$1;
                    super(x0);
                }

                public void fireActionPerformed(ActionEvent e) {
                    RootObjectBrowser.access$500(RootToolsMenu.access$400(this.this$1));
                }
            };
            this.add(this.view);
        }

        void setFileOpen(boolean state) {
            this.view.setEnabled(state);
        }

        static /* synthetic */ RootObjectBrowser access$400(RootToolsMenu x0) {
            return x0.RootObjectBrowser.this;
        }
    }

    private class RootMenuBar
    extends JMenuBar {
        private RootToolsMenu tools;

        RootMenuBar() {
            this.add(new RootFileMenu());
            this.tools = new RootToolsMenu();
            this.add(this.tools);
            this.add(new RootHelpMenu());
        }

        void setFileOpen(boolean state) {
            this.tools.setFileOpen(state);
        }
    }

    private class RootHelpMenu
    extends JMenu {
        RootHelpMenu() {
            super("Help");
            this.add(new JMenuItem(this, "About...", RootObjectBrowser.this){
                private final /* synthetic */ RootObjectBrowser val$this$0;
                private final /* synthetic */ RootHelpMenu this$1;
                {
                    this.this$1 = this$1;
                    this.val$this$0 = val$this$0;
                    super(x0);
                }

                public void fireActionPerformed(ActionEvent e) {
                    JOptionPane.showMessageDialog(RootHelpMenu.access$300(this.this$1), "<HTML>RootObjectBrowser $Id: RootObjectBrowser.java,v 1.17 2004/06/28 15:21:26 tonyj Exp $<br>Author: Tony Johnson (tonyj@slac.stanford.edu)");
                }
            });
        }

        static /* synthetic */ RootObjectBrowser access$300(RootHelpMenu x0) {
            return x0.RootObjectBrowser.this;
        }
    }

    private class RootFileMenu
    extends JMenu {
        RootFileMenu() {
            super("File");
            this.add(new JMenuItem(this, "Open File...", RootObjectBrowser.this){
                private final /* synthetic */ RootObjectBrowser val$this$0;
                private final /* synthetic */ RootFileMenu this$1;
                {
                    this.this$1 = this$1;
                    this.val$this$0 = val$this$0;
                    super(x0);
                }

                public void fireActionPerformed(ActionEvent e) {
                    JFileChooser dlg = new JFileChooser("Open Root File...");
                    dlg.setFileFilter(new RootFileFilter());
                    int rc = dlg.showOpenDialog(RootFileMenu.access$200(this.this$1));
                    if (rc == 0) {
                        try {
                            RootFileMenu.access$200(this.this$1).setRootFile(dlg.getSelectedFile());
                        }
                        catch (IOException x) {
                            RootObjectBrowser.access$000(RootFileMenu.access$200(this.this$1), x);
                        }
                    }
                }
            });
            this.add(new JMenuItem(this, "Open URL...", RootObjectBrowser.this){
                private final /* synthetic */ RootObjectBrowser val$this$0;
                private final /* synthetic */ RootFileMenu this$1;
                {
                    this.this$1 = this$1;
                    this.val$this$0 = val$this$0;
                    super(x0);
                }

                public void fireActionPerformed(ActionEvent e) {
                    String url = JOptionPane.showInputDialog(RootFileMenu.access$200(this.this$1), "URL", "root://");
                    if (url != null) {
                        try {
                            RootFileMenu.access$200(this.this$1).setRootFile(new URL(url));
                        }
                        catch (IOException x) {
                            RootObjectBrowser.access$000(RootFileMenu.access$200(this.this$1), x);
                        }
                    }
                }
            });
            this.add(new JMenuItem(this, "Exit"){
                private final /* synthetic */ RootFileMenu this$1;
                {
                    this.this$1 = this$1;
                    super(x0);
                }

                public void fireActionPerformed(ActionEvent e) {
                    System.exit(0);
                }
            });
        }

        static /* synthetic */ RootObjectBrowser access$200(RootFileMenu x0) {
            return x0.RootObjectBrowser.this;
        }
    }

    private static class RootFileFilter
    extends FileFilter {
        private RootFileFilter() {
        }

        public String getDescription() {
            return "Root Files (*.root)";
        }

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().endsWith(".root");
        }
    }
}

