/*
 * Decompiled with CFR 0.152.
 */
package hep.io.xdr;

import hep.io.xdr.XDRDataInput;
import hep.io.xdr.XDRDataOutput;
import java.io.IOException;
import java.io.RandomAccessFile;

public class XDRRandomAccessFile
extends RandomAccessFile
implements XDRDataInput,
XDRDataOutput {
    public XDRRandomAccessFile(String name, String mode) throws IOException {
        super(name, mode);
    }

    public void pad() throws IOException {
        int offset = (int)(this.getFilePointer() % 4L);
        if (offset != 0) {
            this.skipBytes(4 - offset);
        }
    }

    public double[] readDoubleArray(double[] buffer) throws IOException {
        int l = this.readInt();
        if (l > Short.MAX_VALUE) {
            throw new IOException("String too long: " + l);
        }
        double[] result = buffer;
        if (buffer == null || l > buffer.length) {
            result = new double[l];
        }
        for (int i = 0; i < l; ++i) {
            result[i] = this.readDouble();
        }
        return result;
    }

    public float[] readFloatArray(float[] buffer) throws IOException {
        int l = this.readInt();
        if (l > Short.MAX_VALUE) {
            throw new IOException("String too long: " + l);
        }
        float[] result = buffer;
        if (buffer == null || l > buffer.length) {
            result = new float[l];
        }
        for (int i = 0; i < l; ++i) {
            result[i] = this.readFloat();
        }
        return result;
    }

    public int[] readIntArray(int[] buffer) throws IOException {
        int l = this.readInt();
        if (l > Short.MAX_VALUE) {
            throw new IOException("String too long: " + l);
        }
        int[] result = buffer;
        if (buffer == null || l > buffer.length) {
            result = new int[l];
        }
        for (int i = 0; i < l; ++i) {
            result[i] = this.readInt();
        }
        return result;
    }

    public String readString(int l) throws IOException {
        byte[] ascii = new byte[l];
        this.readFully(ascii);
        this.pad();
        return new String(ascii);
    }

    public String readString() throws IOException {
        int l = this.readInt();
        if (l > Short.MAX_VALUE) {
            throw new IOException("String too long: " + l);
        }
        return this.readString(l);
    }

    public void writeDoubleArray(double[] array) throws IOException {
        this.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            this.writeDouble(array[i]);
        }
    }

    public void writeDoubleArray(double[] array, int start, int n) throws IOException {
        this.writeInt(n);
        for (int i = start; i < n; ++i) {
            this.writeDouble(array[i]);
        }
    }

    public void writeFloatArray(float[] array) throws IOException {
        this.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            this.writeFloat(array[i]);
        }
    }

    public void writeFloatArray(float[] array, int start, int n) throws IOException {
        this.writeInt(n);
        for (int i = start; i < n; ++i) {
            this.writeFloat(array[i]);
        }
    }

    public void writeIntArray(int[] array) throws IOException {
        this.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            this.writeInt(array[i]);
        }
    }

    public void writeIntArray(int[] array, int start, int n) throws IOException {
        this.writeInt(n);
        for (int i = start; i < n; ++i) {
            this.writeInt(array[i]);
        }
    }

    public void writeString(String s) throws IOException {
        this.writeInt(s.length());
        byte[] ascii = s.getBytes();
        this.write(ascii);
        this.pad();
    }

    public void writeStringChars(String s) throws IOException {
        byte[] ascii = s.getBytes();
        this.write(ascii);
        this.pad();
    }
}

