/*
 * Decompiled with CFR 0.152.
 */
package hep.tuple;

import hep.tuple.Tuple;
import hep.tuple.interfaces.FTupleCursor;

public class Cursor
implements FTupleCursor {
    private int endRow;
    private int startRow;
    private int currentRow;
    private boolean hasRandomAccess;

    protected Cursor(Tuple tuple) {
        this.startRow = tuple.startRow();
        this.endRow = this.startRow + tuple.rows();
        this.hasRandomAccess = tuple.supportsRandomAccess();
        this.initCursor();
    }

    private Cursor(int startRow, int endRow) {
        this(startRow, endRow, false);
    }

    public Cursor(int startRow, int endRow, boolean hasRandomAccess) {
        if (endRow < startRow) {
            throw new IllegalArgumentException("Wrong endRow. It has to be greater or equal to startRow");
        }
        this.endRow = endRow;
        this.startRow = startRow;
        this.hasRandomAccess = hasRandomAccess;
        this.initCursor();
    }

    private void initCursor() {
        this.currentRow = this.startRow - 1;
    }

    public int row() {
        return this.currentRow;
    }

    public void start() {
        this.initCursor();
    }

    public boolean next() {
        if (this.currentRow + 1 < this.endRow) {
            ++this.currentRow;
            return true;
        }
        return false;
    }

    public void setRow(int n) {
        if (!this.hasRandomAccess) {
            throw new IllegalArgumentException("The FTuple does not support random access");
        }
        if (n < 0 || n >= this.endRow) {
            throw new IndexOutOfBoundsException();
        }
        this.currentRow = n;
    }

    public void close() {
    }

    public void skip(int rows) {
        if (rows < 0) {
            throw new IllegalArgumentException("Illegal number of rows " + rows);
        }
        this.setRow(this.currentRow + rows);
    }
}

