/*
 * Decompiled with CFR 0.152.
 */
package hep.tuple;

import hep.tuple.TupleColumn;
import org.freehep.util.Value;

public class TupleColumnInt
extends TupleColumn {
    private int[] data;

    TupleColumnInt(String name, Value value, String options) {
        super(name, Integer.TYPE, value, options);
    }

    protected void createArray(int size) {
        int[] data = new int[size];
        if (this.hasDefaultValue()) {
            for (int i = 0; i < size; ++i) {
                data[i] = this.getDefaultValue().getInt();
            }
        }
        this.arrayList.add(data);
    }

    public void value(int index, Value value) {
        this.setCurrentArray(index);
        value.set(this.data[index % this.arraySize]);
    }

    public void setValue(int index, Value value) {
        try {
            this.setCurrentArray(index);
            this.data[index % this.arraySize] = value.getInt();
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("Wrong argument for TupleColumnInt");
        }
    }

    protected boolean hasStatistics() {
        return true;
    }

    public void defaultValue(Value value) {
        if (this.hasDefaultValue()) {
            value.set(this.getDefaultValue().getInt());
        }
    }

    protected void currentArrayUpdated() {
        this.data = (int[])this.currentArray;
    }
}

