/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.util.xml.XMLNodeTraverser;
import java.util.StringTokenizer;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

class Bins2DNodeTraverser
extends XMLNodeTraverser {
    private String title;
    private double[][][] data;
    private int xSize;
    private int ySize;

    Bins2DNodeTraverser(Node node) throws XMLNodeTraverser.BadXMLException {
        this.traverse(node);
    }

    protected void handleAttributeNode(Attr attr, String string, String string2) throws XMLNodeTraverser.BadXMLException {
        if (string.equals("title")) {
            this.title = string2;
        } else if (string.equals("xSize")) {
            this.xSize = this.toInt(string2);
        } else if (string.equals("ySize")) {
            this.ySize = this.toInt(string2);
        } else {
            super.handleAttributeNode(attr, string, string2);
        }
    }

    protected void handleTextNode(Text text, String string) throws XMLNodeTraverser.BadXMLException {
        StringTokenizer stringTokenizer = new StringTokenizer(text.getData(), "\n\r");
        int n = stringTokenizer.countTokens();
        if (n < this.xSize * this.ySize || n > this.xSize * this.ySize + 1) {
            throw new XMLNodeTraverser.BadXMLException("Inconsistent data length for bins2d (lines=" + n + ")");
        }
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.xSize * this.ySize; ++i) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken().trim(), ",");
            int n4 = stringTokenizer2.countTokens();
            if (this.data == null) {
                this.data = new double[n4][this.xSize][this.ySize];
            } else if (n4 != this.data.length) {
                throw new XMLNodeTraverser.BadXMLException("Inconsistent number of entries in bins2d data at line " + i);
            }
            for (int j = 0; j < n4; ++j) {
                this.data[j][n2][n3] = this.toDouble(stringTokenizer2.nextToken());
            }
            if (++n3 != this.ySize) continue;
            n3 = 0;
            ++n2;
        }
    }

    String getTitle() {
        return this.title;
    }

    double[][][] getData() {
        return this.data;
    }
}

