/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.DataManager;
import jas.hist.DataSource;
import jas.hist.ExtendedStatistics;
import jas.hist.HasDataSource;
import jas.hist.HasStatistics;
import jas.hist.HasStyle;
import jas.hist.HistogramUpdate;
import jas.hist.JASHist1DHistogramStyle;
import jas.hist.JASHistData;
import jas.hist.JASHistStyle;
import jas.hist.OneDOverlay;
import jas.hist.Rebinnable1DHistogramData;
import jas.hist.Statistics;
import jas.hist.XMLPrintWriter;
import jas.hist.XYDataSource;
import jas.plot.Overlay;
import jas.util.ColorConverter;
import jas.util.xml.HasXMLRepresentation;
import java.io.Serializable;
import java.util.Observable;

class JASHist1DHistogramData
extends JASHistData {
    private DataSource dataSource;
    JASHist1DHistogramStyle style;
    private boolean hurry;
    private boolean isBinned = false;
    private boolean yLimitsValid = false;
    private boolean xLimitsValid = false;
    private double[] data;
    private double[] dataX;
    private double[] plusError;
    private double[] minusError;
    private int xBins;
    private double xMin;
    private double xMax;
    private double xLow;
    private double xHigh;
    private double yLow;
    private double yHigh;
    private static final HistogramUpdate hu = new HistogramUpdate(2, true);
    static final long serialVersionUID = -3529869583896718619L;
    private FittableDataSource fittableDataSource = new FittableDataSource();

    JASHist1DHistogramData(DataManager dataManager, DataSource dataSource) {
        super(dataManager);
        this.dataSource = dataSource;
        this.initTransientData();
        JASHistStyle jASHistStyle = null;
        if (dataSource instanceof HasStyle) {
            jASHistStyle = ((HasStyle)((Object)dataSource)).getStyle();
        }
        if (jASHistStyle == null) {
            jASHistStyle = new JASHist1DHistogramStyle();
        }
        this.setStyle(jASHistStyle);
        String string = System.getProperty("hurry", "false");
        this.hurry = string != null && string.equalsIgnoreCase("true");
    }

    private void initTransientData() {
        this.yLimitsValid = false;
        this.isBinned = false;
    }

    public void setStyle(JASHistStyle jASHistStyle) {
        if (!(jASHistStyle instanceof JASHist1DHistogramStyle)) {
            throw new IllegalArgumentException("Style is not subclass of JASHist1DHistogramStyle");
        }
        if (this.style != null) {
            this.style.deleteObserver(this);
        }
        this.style = (JASHist1DHistogramStyle)jASHistStyle;
        this.style.addObserver(this);
    }

    public String getTitle() {
        return this.dataSource.getTitle();
    }

    String[] getAxisLabels() {
        return this.dataSource instanceof Rebinnable1DHistogramData ? ((Rebinnable1DHistogramData)this.dataSource).getAxisLabels() : null;
    }

    Overlay createOverlay() {
        return new OneDOverlay(this);
    }

    void writeAsXML(XMLPrintWriter xMLPrintWriter, boolean bl) {
        xMLPrintWriter.setAttribute("axis", "y" + this.getYAxis());
        xMLPrintWriter.openTag("data1d");
        String string = XMLPrintWriter.convertAxisTypeToString(this.getAxisType());
        if (bl) {
            Statistics statistics;
            if (this.dataSource instanceof Rebinnable1DHistogramData) {
                xMLPrintWriter.setAttribute("title", this.getTitle());
                xMLPrintWriter.openTag("bins1d");
                for (int i = 0; i < this.data.length; ++i) {
                    xMLPrintWriter.print(this.data[i]);
                    xMLPrintWriter.print(",");
                    xMLPrintWriter.print(this.plusError[i]);
                    xMLPrintWriter.print(",");
                    xMLPrintWriter.print(this.minusError[i]);
                    xMLPrintWriter.println();
                }
                xMLPrintWriter.closeTag();
                xMLPrintWriter.printBinnedDataAxisAttributes("x", "" + this.xLow, "" + this.xHigh, "" + this.xBins, string);
                if (string.equals("string")) {
                    xMLPrintWriter.setAttribute("type", "x0");
                    xMLPrintWriter.openTag("axisLabels");
                    String[] stringArray = this.getAxisLabels();
                    for (int i = 0; i < stringArray.length; ++i) {
                        xMLPrintWriter.setAttribute("value", stringArray[i]);
                        xMLPrintWriter.printTag("axisLabel");
                    }
                    xMLPrintWriter.closeTag();
                }
            } else {
                xMLPrintWriter.setAttribute("title", this.getTitle());
                xMLPrintWriter.openTag("points");
                for (int i = 0; i < this.data.length; ++i) {
                    xMLPrintWriter.print(this.dataX[i]);
                    xMLPrintWriter.print(44.0);
                    xMLPrintWriter.print(this.data[i]);
                    xMLPrintWriter.print(44.0);
                    xMLPrintWriter.print(this.plusError[i]);
                    xMLPrintWriter.print(44.0);
                    xMLPrintWriter.print(this.minusError[i]);
                    xMLPrintWriter.println();
                }
                xMLPrintWriter.closeTag();
                xMLPrintWriter.setAttribute("axis", "x");
                xMLPrintWriter.setAttribute("type", string);
                xMLPrintWriter.printTag("pointDataAxisAttributes");
            }
            if (this.dataSource instanceof HasStatistics && (statistics = ((HasStatistics)((Object)this.dataSource)).getStatistics()) != null) {
                xMLPrintWriter.openTag("statistics");
                String[] stringArray = statistics.getStatisticNames();
                for (int i = 0; i < stringArray.length; ++i) {
                    Object object;
                    String string2 = stringArray[i];
                    xMLPrintWriter.setAttribute("name", string2);
                    String string3 = null;
                    if (statistics instanceof ExtendedStatistics && (object = ((ExtendedStatistics)statistics).getExtendedStatistic(string2)) != null) {
                        string3 = object.toString();
                    }
                    if (string3 == null) {
                        string3 = String.valueOf(statistics.getStatistic(string2));
                    }
                    xMLPrintWriter.setAttribute("value", string3);
                    xMLPrintWriter.printTag("statistic");
                }
                xMLPrintWriter.closeTag();
            }
        } else if (this.dataSource instanceof HasXMLRepresentation) {
            ((HasXMLRepresentation)((Object)this.dataSource)).writeAsXML(xMLPrintWriter);
        } else {
            if (this.dataSource instanceof HasDataSource) {
                xMLPrintWriter.setAttribute("name", this.dataSource.getClass().getName());
            } else {
                xMLPrintWriter.setAttribute("name", "???");
            }
            xMLPrintWriter.setAttribute("param", "???");
            xMLPrintWriter.printTag("class");
        }
        xMLPrintWriter.setAttribute("histogramBarsFilled", this.style.getHistogramFill());
        xMLPrintWriter.setAttribute("histogramBarColor", ColorConverter.colorToString(this.style.getHistogramBarColor()));
        xMLPrintWriter.setAttribute("errorBarColor", ColorConverter.colorToString(this.style.getErrorBarColor()));
        xMLPrintWriter.setAttribute("dataPointColor", ColorConverter.colorToString(this.style.getDataPointColor()));
        xMLPrintWriter.setAttribute("dataPointStyle", XMLPrintWriter.convertStyleToString(this.style.getDataPointStyle()));
        xMLPrintWriter.setAttribute("dataPointSize", this.style.getDataPointSize());
        xMLPrintWriter.setAttribute("lineColor", ColorConverter.colorToString(this.style.getLineColor()));
        xMLPrintWriter.setAttribute("showHistogramBars", this.style.getShowHistogramBars());
        xMLPrintWriter.setAttribute("showErrorBars", this.style.getShowErrorBars());
        xMLPrintWriter.setAttribute("showDataPoints", this.style.getShowDataPoints());
        xMLPrintWriter.setAttribute("showLinesBetweenPoints", this.style.getShowLinesBetweenPoints());
        xMLPrintWriter.printTag("style1d");
        xMLPrintWriter.closeTag();
    }

    boolean isRebinnable() {
        return this.dataSource instanceof Rebinnable1DHistogramData ? ((Rebinnable1DHistogramData)this.dataSource).isRebinnable() : false;
    }

    double getXMin() {
        if (this.dataSource instanceof Rebinnable1DHistogramData) {
            return ((Rebinnable1DHistogramData)this.dataSource).getMin();
        }
        if (!this.xLimitsValid) {
            this.calcXLimits();
        }
        return this.xMin;
    }

    double getXMax() {
        if (this.dataSource instanceof Rebinnable1DHistogramData) {
            return ((Rebinnable1DHistogramData)this.dataSource).getMax();
        }
        if (!this.xLimitsValid) {
            this.calcXLimits();
        }
        return this.xMax;
    }

    void setXRange(int n, double d, double d2) {
        if (this.isRebinnable()) {
            if (n != this.xBins || d != this.xLow || d2 != this.xHigh) {
                this.xBins = n;
                this.isBinned = false;
            }
        } else if (this.dataSource instanceof Rebinnable1DHistogramData) {
            this.xBins = ((Rebinnable1DHistogramData)this.dataSource).getBins();
        }
        this.yLimitsValid = false;
        this.xLow = d;
        this.xHigh = d2;
    }

    private void doXYBin() {
        this.isBinned = true;
        XYDataSource xYDataSource = (XYDataSource)this.dataSource;
        int n = xYDataSource.getNPoints();
        this.dataX = new double[n];
        this.data = new double[n];
        this.plusError = new double[n];
        this.minusError = new double[n];
        for (int i = 0; i < n; ++i) {
            this.dataX[i] = xYDataSource.getX(i);
            this.data[i] = xYDataSource.getY(i);
            this.plusError[i] = xYDataSource.getPlusError(i);
            this.minusError[i] = xYDataSource.getMinusError(i);
        }
        if (this.normalization != null) {
            double d = 1.0 / this.normalization.getNormalizationFactor();
            double[] dArray = new double[n];
            double[] dArray2 = new double[n];
            double[] dArray3 = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = this.data[i] * d;
                dArray2[i] = this.plusError[i] * d;
                dArray3[i] = this.minusError[i] * d;
            }
            if (this.overlay instanceof OneDOverlay) {
                ((OneDOverlay)this.overlay).setData(this.dataX, dArray, dArray2, dArray3);
            }
        } else if (this.overlay instanceof OneDOverlay) {
            ((OneDOverlay)this.overlay).setData(this.dataX, this.data, this.plusError, this.minusError);
        }
    }

    private void doBin() {
        if (this.dataSource instanceof XYDataSource) {
            this.doXYBin();
        } else {
            double d;
            double d2;
            int n = this.getAxisType();
            String[] stringArray = null;
            if (n == 2) {
                stringArray = this.getAxisLabels();
                this.xBins = stringArray.length;
                d2 = 0.0;
                d = stringArray.length;
            } else if (this.isRebinnable()) {
                d2 = this.xLow;
                d = this.xHigh;
            } else {
                d2 = ((Rebinnable1DHistogramData)this.dataSource).getMin();
                d = ((Rebinnable1DHistogramData)this.dataSource).getMax();
            }
            this.isBinned = true;
            double[][] dArray = ((Rebinnable1DHistogramData)this.dataSource).rebin(this.xBins, d2, d, true, this.hurry);
            if (dArray == null) {
                dArray = new double[1][this.xBins];
            }
            this.data = dArray[0];
            if (this.data.length != this.xBins) {
                System.err.println("Warning xbins=" + this.xBins + " data.length=" + this.data.length);
            }
            if (dArray.length > 1) {
                this.plusError = dArray[1];
                this.minusError = dArray.length > 2 ? dArray[2] : this.plusError;
            } else {
                this.plusError = new double[this.xBins];
                for (int i = 0; i < this.xBins; ++i) {
                    this.plusError[i] = Math.sqrt(Math.abs(this.data[i]));
                }
                this.minusError = this.plusError;
            }
            if (this.plusError.length != this.xBins) {
                System.err.println("Warning xbins=" + this.xBins + " plusError.length=" + this.plusError.length);
            }
            if (this.minusError.length != this.xBins) {
                System.err.println("Warning xbins=" + this.xBins + " minusError.length=" + this.minusError.length);
            }
            if (this.normalization != null) {
                double d3 = 1.0 / this.normalization.getNormalizationFactor();
                double[] dArray2 = new double[this.xBins];
                double[] dArray3 = new double[this.xBins];
                double[] dArray4 = new double[this.xBins];
                for (int i = 0; i < this.data.length; ++i) {
                    dArray2[i] = this.data[i] * d3;
                    dArray3[i] = this.plusError[i] * d3;
                    dArray4[i] = this.minusError[i] * d3;
                }
                if (this.overlay instanceof OneDOverlay) {
                    if (n == 2) {
                        ((OneDOverlay)this.overlay).setData(dArray2, dArray3, dArray4, stringArray);
                    } else {
                        ((OneDOverlay)this.overlay).setData(dArray2, dArray3, dArray4, d2, d);
                    }
                }
            } else if (this.overlay instanceof OneDOverlay) {
                if (n == 2) {
                    ((OneDOverlay)this.overlay).setData(this.data, this.plusError, this.minusError, stringArray);
                } else {
                    ((OneDOverlay)this.overlay).setData(this.data, this.plusError, this.minusError, d2, d);
                }
            }
        }
    }

    private void calcXLimits() {
        this.xLimitsValid = true;
        XYDataSource xYDataSource = (XYDataSource)this.dataSource;
        int n = xYDataSource.getNPoints();
        if (n == 0) {
            this.xMin = Double.NaN;
            this.xMax = Double.NaN;
        } else {
            this.xMin = Double.MAX_VALUE;
            this.xMax = -1.7976931348623157E308;
            for (int i = 0; i < n; ++i) {
                double d = xYDataSource.getX(i);
                if (d < this.xMin) {
                    this.xMin = d;
                }
                if (!(d > this.xMax)) continue;
                this.xMax = d;
            }
            if (this.xMin > this.xMax) {
                this.xMin = 0.0;
                this.xMax = 1.0;
            } else {
                double d = (this.xMax - this.xMin) / 25.0;
                this.xMin -= d;
                this.xMax += d;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void calcYLimits() {
        if (!this.isBinned) {
            if (this.dataSource instanceof XYDataSource) {
                this.doXYBin();
            } else {
                this.doBin();
            }
            this.fittableDataSource.binningChanged();
        }
        this.yLimitsValid = true;
        var1_1 = 0;
        this.yLow = 1.7976931348623157E308;
        this.yHigh = -1.7976931348623157E308;
        var2_2 = this.style.getShowErrorBars();
        if (this.isRebinnable()) ** GOTO lbl-1000
        if (this.getAxisType() != 2) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = var3_3 = false;
        }
        if (this.dataSource instanceof Rebinnable1DHistogramData) {
            var4_4 = this.getXMin();
            var6_6 = (this.getXMax() - this.getXMin()) / (double)this.xBins;
            for (var8_7 = 0; var8_7 < this.xBins; ++var8_7) {
                if (var3_3) {
                    var9_8 = var4_4;
                    var11_9 = var4_4 += var6_6;
                    if (var11_9 < this.xLow || var9_8 > this.xHigh) continue;
                }
                if (Double.isNaN(var9_8 = this.data[var8_7])) continue;
                ++var1_1;
                this.yLow = Math.min(this.yLow, var9_8 - (var2_2 != false ? this.minusError[var8_7] : 0.0));
                this.yHigh = Math.max(this.yHigh, var9_8 + (var2_2 != false ? this.plusError[var8_7] : 0.0));
            }
        } else {
            for (var4_5 = 0; var4_5 < this.dataX.length; ++var4_5) {
                var5_10 = this.dataX[var4_5];
                if (var5_10 < this.xLow || var5_10 > this.xHigh || Double.isNaN(var7_11 = this.data[var4_5])) continue;
                ++var1_1;
                this.yLow = Math.min(this.yLow, var7_11 - (var2_2 != false ? this.minusError[var4_5] : 0.0));
                this.yHigh = Math.max(this.yHigh, var7_11 + (var2_2 != false ? this.plusError[var4_5] : 0.0));
            }
            var4_4 = (this.yHigh - this.yLow) / 25.0;
            this.yLow -= var4_4;
            this.yHigh += var4_4;
        }
        if (var1_1 == 0) {
            this.yLow = 0.0;
            this.yHigh = 1.0;
        } else if (this.normalization != null) {
            var4_4 = 1.0 / this.normalization.getNormalizationFactor();
            this.yLow *= var4_4;
            this.yHigh *= var4_4;
        }
    }

    public void update(Observable observable, Object object) {
        if (observable == this.dataSource) {
            HistogramUpdate histogramUpdate = (HistogramUpdate)object;
            this.isBinned = false;
            this.yLimitsValid = false;
            this.xLimitsValid = false;
            this.parent.update(histogramUpdate, this);
        } else if (observable == this.style) {
            this.yLimitsValid = false;
            this.parent.styleUpdate(this);
        } else if (observable == this.normalization) {
            this.normalizationChanged(false);
        }
    }

    void normalizationChanged(boolean bl) {
        HistogramUpdate histogramUpdate = new HistogramUpdate(2, bl);
        if (!this.isBinned || this.countObservers() == 0) {
            this.fittableDataSource.update(histogramUpdate);
        }
        this.isBinned = false;
        this.yLimitsValid = false;
        this.parent.update(histogramUpdate, this);
    }

    public boolean hasChanged() {
        return !this.isBinned;
    }

    double getYMin() {
        if (!this.yLimitsValid) {
            this.calcYLimits();
        }
        return this.yLow;
    }

    double getYMax() {
        if (!this.yLimitsValid) {
            this.calcYLimits();
        }
        return this.yHigh;
    }

    void validate() {
        if (!this.isBinned) {
            this.doBin();
        }
    }

    void axisChanged() {
        this.parent.axisChanged(this);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public DataSource getFittableDataSource() {
        return this.fittableDataSource;
    }

    public boolean getBinnable() {
        return true;
    }

    public int getBins() {
        return this.dataSource instanceof Rebinnable1DHistogramData ? ((Rebinnable1DHistogramData)this.dataSource).getBins() : ((XYDataSource)this.dataSource).getNPoints();
    }

    int getAxisType() {
        if (this.dataSource instanceof Rebinnable1DHistogramData) {
            return ((Rebinnable1DHistogramData)this.dataSource).getAxisType();
        }
        return ((XYDataSource)this.dataSource).getAxisType();
    }

    public JASHistStyle getStyle() {
        return this.style;
    }

    void destroy() {
        if (this.dataSource instanceof Observable) {
            ((Observable)((Object)this.dataSource)).deleteObserver(this);
        }
        this.style.deleteObserver(this);
        super.destroy();
    }

    class FittableDataSource
    extends Observable
    implements XYDataSource,
    Serializable {
        FittableDataSource() {
        }

        public int getAxisType() {
            return 1;
        }

        public String getTitle() {
            return JASHist1DHistogramData.this.dataSource.getTitle();
        }

        void update(Object object) {
            this.setChanged();
            this.notifyObservers(object);
        }

        void binningChanged() {
            this.setChanged();
            this.notifyObservers(hu);
        }

        JASHist1DHistogramData parent() {
            return JASHist1DHistogramData.this;
        }

        public double getMinusError(int n) {
            return JASHist1DHistogramData.this.minusError[n];
        }

        public double getPlusError(int n) {
            return JASHist1DHistogramData.this.plusError[n];
        }

        public double getX(int n) {
            if (JASHist1DHistogramData.this.dataX != null) {
                return JASHist1DHistogramData.this.dataX[n];
            }
            double d = (JASHist1DHistogramData.this.xHigh - JASHist1DHistogramData.this.xLow) / (double)JASHist1DHistogramData.this.xBins;
            return JASHist1DHistogramData.this.xLow + d * (double)n + d / 2.0;
        }

        public double getY(int n) {
            return JASHist1DHistogramData.this.data[n];
        }

        public int getNPoints() {
            return JASHist1DHistogramData.this.data.length;
        }

        public String toString() {
            return this.getTitle();
        }
    }
}

