/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.DataSource;
import jas.hist.Handle;
import jas.hist.HasHandles;
import jas.hist.SliceParameters;
import jas.plot.DoubleCoordinateTransformation;
import jas.plot.PlotGraphics;
import java.awt.Color;

class SliceData
implements HasHandles,
DataSource {
    private static final int[] signA = new int[]{1, 1, -1, -1};
    private static final int[] signB = new int[]{-1, 1, 1, -1};
    protected SliceParameters parm;

    SliceData(SliceParameters sliceParameters) {
        this.parm = sliceParameters;
    }

    void paint(PlotGraphics plotGraphics, DoubleCoordinateTransformation doubleCoordinateTransformation, DoubleCoordinateTransformation doubleCoordinateTransformation2) {
        plotGraphics.setColor(Color.lightGray);
        plotGraphics.drawLine(this.getCornerX(1), this.getCornerY(1), this.getCornerX(2), this.getCornerY(2));
        plotGraphics.drawLine(this.getCornerX(2), this.getCornerY(2), this.getCornerX(3), this.getCornerY(3));
        plotGraphics.drawLine(this.getCornerX(3), this.getCornerY(3), this.getCornerX(0), this.getCornerY(0));
        plotGraphics.setColor(Color.black);
        plotGraphics.drawLine(this.getCornerX(0), this.getCornerY(0), this.getCornerX(1), this.getCornerY(1));
    }

    private double getCornerX(int n) {
        return this.parm.getX() + (double)signB[n] * this.parm.getWidth() * Math.cos(this.parm.getPhi()) + (double)signA[n] * this.parm.getHeight() * Math.sin(this.parm.getPhi());
    }

    private double getCornerY(int n) {
        return this.parm.getY() - (double)signB[n] * this.parm.getWidth() * Math.sin(this.parm.getPhi()) + (double)signA[n] * this.parm.getHeight() * Math.cos(this.parm.getPhi());
    }

    private double getPhiOffset(int n) {
        return Math.atan2((double)signA[n] * this.parm.getHeight(), (double)signB[n] * this.parm.getWidth());
    }

    public Handle[] getHandles(double d, double d2, double d3, double d4) {
        int n;
        Handle[] handleArray = new Handle[9];
        for (n = 0; n < 4; ++n) {
            handleArray[n] = new CornerHandle(n);
        }
        for (n = 0; n < 4; ++n) {
            handleArray[n + 4] = new MiddleHandle(n);
        }
        handleArray[8] = new MoveHandle();
        return handleArray;
    }

    public String getTitle() {
        return null;
    }

    private class MoveHandle
    extends Handle {
        private MoveHandle() {
        }

        public double getX() {
            return SliceData.this.parm.getX();
        }

        public double getY() {
            return SliceData.this.parm.getY();
        }

        public void moveTo(double d, double d2) {
            SliceData.this.parm.setX(d);
            SliceData.this.parm.setY(d2);
        }
    }

    private class MiddleHandle
    extends Handle {
        private int index;

        MiddleHandle(int n) {
            this.index = n;
        }

        public double getX() {
            return (SliceData.this.getCornerX(this.index) + SliceData.this.getCornerX((this.index + 1) % 4)) / 2.0;
        }

        public double getY() {
            return (SliceData.this.getCornerY(this.index) + SliceData.this.getCornerY((this.index + 1) % 4)) / 2.0;
        }

        public void moveTo(double d, double d2) {
            double d3 = SliceData.this.parm.getX();
            double d4 = SliceData.this.parm.getY();
            double d5 = Math.atan2(d2 - d4, d - d3);
            double d6 = Math.sqrt((d - d3) * (d - d3) + (d2 - d4) * (d2 - d4));
            if (this.index % 2 == 0) {
                SliceData.this.parm.setHeight(Math.abs(d6 *= Math.sin(d5 - SliceData.this.parm.getPhi())));
            } else {
                SliceData.this.parm.setWidth(Math.abs(d6 *= Math.cos(d5 - SliceData.this.parm.getPhi())));
            }
        }
    }

    private class CornerHandle
    extends Handle {
        private int index;

        CornerHandle(int n) {
            this.index = n;
        }

        public double getX() {
            return SliceData.this.getCornerX(this.index);
        }

        public double getY() {
            return SliceData.this.getCornerY(this.index);
        }

        public void moveTo(double d, double d2) {
            double d3 = SliceData.this.parm.getX();
            double d4 = SliceData.this.parm.getY();
            double d5 = Math.atan2(d2 - d4, d - d3);
            SliceData.this.parm.setPhi(-d5 + SliceData.this.getPhiOffset(this.index));
        }
    }
}

