/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.DataManager;
import jas.hist.JASHist;
import jas.hist.JASHistAxis;
import jas.hist.JASHistData;
import jas.hist.StatisticsBlock;
import jas.hist.SupportsFunctions;
import jas.plot.DataArea;
import jas.plot.EditableLabel;
import jas.plot.Legend;
import jas.plot.MovableObject;
import jas.plot.Title;
import jas.util.ColorConverter;
import jas.util.ScientificFormat;
import jas.util.border.ShadowBorder;
import jas.util.xml.XMLWriter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.io.Writer;
import java.text.Format;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

final class XMLPrintWriter
extends XMLWriter {
    XMLPrintWriter(Writer writer) {
        super(writer);
    }

    void print(JASHist jASHist, boolean bl) {
        DataArea dataArea;
        this.printPlotHeader();
        Title title = jASHist.getTitleObject();
        if (title != null && title.isVisible()) {
            this.print(title);
        }
        this.print(jASHist.getLegend(), jASHist.getShowLegend());
        StatisticsBlock statisticsBlock = jASHist.getStats();
        if (statisticsBlock != null && statisticsBlock.isVisible()) {
            this.print(statisticsBlock);
        }
        if ((dataArea = jASHist.getDataArea()) != null && dataArea.isVisible()) {
            this.print(dataArea, jASHist.getDataManager(), bl);
        }
        this.setAttribute("width", jASHist.getWidth());
        this.setAttribute("height", jASHist.getHeight());
        this.printTag("bounds");
        this.printColorScheme(jASHist);
        this.printPlotFooter();
    }

    void printColorScheme(Component component) {
        Container container = component.getParent();
        Color color = component.getForeground();
        Color color2 = component.getBackground();
        if (container == null || color != container.getForeground() || color2 != container.getBackground()) {
            if (container == null || color != container.getForeground()) {
                this.setAttribute("foregroundColor", ColorConverter.colorToString(color));
            }
            if (container == null || color2 != container.getBackground()) {
                this.setAttribute("backgroundColor", ColorConverter.colorToString(color2));
            }
            this.printTag("colorScheme");
        }
    }

    void print(Title title) {
        this.openTag("title");
        this.print(title.getInsideBorder());
        this.printBounds(title);
        this.print(title.getLabel());
        this.printColorScheme(title);
        this.closeTag();
    }

    void print(JASHistAxis jASHistAxis, String string) {
        int n = jASHistAxis.getAxisType();
        this.setAttribute("location", string);
        this.setAttribute("type", XMLPrintWriter.convertAxisTypeToString(n));
        this.setAttribute("showOverflows", jASHistAxis.getShowOverflows());
        if (jASHistAxis.isBinned()) {
            this.setAttribute("numberOfBins", jASHistAxis.getBins());
        }
        if (n != 2) {
            this.setAttribute("logarithmic", jASHistAxis.isLogarithmic());
            this.setAttribute("allowSuppressedZero", jASHistAxis.getAllowSuppressedZero());
            if (!jASHistAxis.getRangeAutomatic()) {
                this.setAttribute("min", jASHistAxis.getMin());
                this.setAttribute("max", jASHistAxis.getMax());
            }
        }
        this.openTag("axis");
        EditableLabel editableLabel = jASHistAxis.getLabelObject();
        if (editableLabel != null) {
            this.print(editableLabel);
        }
        this.print(jASHistAxis.getFont());
        this.closeTag();
    }

    void print(EditableLabel editableLabel) {
        this.setAttribute("text", editableLabel.getText());
        this.openTag("label");
        this.print(editableLabel.getFont());
        this.closeTag();
    }

    void print(Legend legend, int n) {
        this.setAttribute("visible", XMLPrintWriter.convertLegendToString(n));
        this.openTag("legend");
        if (legend != null && legend.isVisible()) {
            this.print(legend.getInsideBorder());
            this.printBounds(legend);
            this.printColorScheme(legend);
            this.print(legend.getFont());
            int n2 = legend.getNEntries();
            for (int i = 0; i < n2; ++i) {
                String string = legend.getCurrentTitle(i);
                if (!legend.isTitleChanged(i)) continue;
                this.setAttribute("title", string);
                this.setAttribute("index", String.valueOf(i));
                this.printTag("legendEntry");
            }
        }
        this.closeTag();
    }

    void print(StatisticsBlock statisticsBlock) {
        String[] stringArray;
        this.setAttribute("showTitles", XMLPrintWriter.convertShowTitleToString(statisticsBlock.getShowTitles()));
        this.setAttribute("alignment", XMLPrintWriter.convertAlignmentToString(statisticsBlock.getSplitStringAlign()));
        this.openTag("stats");
        this.print(statisticsBlock.getInsideBorder());
        this.printBounds(statisticsBlock);
        this.printColorScheme(statisticsBlock);
        this.print(statisticsBlock.getFont());
        Format format = statisticsBlock.getFormat();
        if (format instanceof ScientificFormat) {
            this.print((ScientificFormat)statisticsBlock.getFormat());
        }
        if ((stringArray = statisticsBlock.getSelectedEntries()) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.setAttribute("name", stringArray[i]);
                this.printTag("statsEntry");
            }
        }
        this.closeTag();
    }

    void print(ScientificFormat scientificFormat) {
        this.setAttribute("maximumWidth", scientificFormat.getMaxWidth());
        this.setAttribute("significantDigits", scientificFormat.getSigDigits());
        if (scientificFormat.getScientificNotationStyle()) {
            this.setAttribute("style", "pure");
        }
        this.printTag("format");
    }

    void printBinnedDataAxisAttributes(String string, String string2, String string3, String string4, String string5) {
        this.setAttribute("axis", string);
        this.setAttribute("min", string2);
        this.setAttribute("max", string3);
        this.setAttribute("numberOfBins", string4);
        this.setAttribute("type", string5);
        this.printTag("binnedDataAxisAttributes");
    }

    void printPointDataAxisAttributes(String string, String string2) {
        this.setAttribute("axis", string);
        this.setAttribute("type", string2);
        this.printTag("pointDataAxisAttributes");
    }

    void print(DataArea dataArea, DataManager dataManager, boolean bl) {
        Object object;
        this.openTag("dataArea");
        this.print(dataArea.getInsideBorder());
        this.printBounds(dataArea);
        this.printColorScheme(dataArea);
        Enumeration enumeration = dataManager.getDataSources();
        while (enumeration.hasMoreElements()) {
            object = (JASHistData)enumeration.nextElement();
            if (!((JASHistData)object).isShowing()) continue;
            this.print((JASHistData)object, bl);
        }
        if (dataManager instanceof SupportsFunctions) {
            enumeration = ((SupportsFunctions)((Object)dataManager)).getFunctions();
            while (enumeration.hasMoreElements()) {
                object = (JASHistData)enumeration.nextElement();
                if (!((JASHistData)object).isShowing()) continue;
                this.print((JASHistData)object, bl);
            }
        }
        object = dataManager.getXAxis();
        this.print((JASHistAxis)object, "x0");
        JASHistAxis[] jASHistAxisArray = dataManager.getYAxes();
        for (int i = 0; i < jASHistAxisArray.length; ++i) {
            if (jASHistAxisArray[i] == null) continue;
            this.print(jASHistAxisArray[i], "y" + i);
        }
        this.closeTag();
    }

    void print(JASHistData jASHistData, boolean bl) {
        jASHistData.writeAsXML(this, bl);
    }

    void printPlotHeader() {
        this.openDoc("1.0", "ISO-8859-1", false);
        this.referToDTD("plotML", "plotML.dtd");
        this.openTag("plotML");
        this.openTag("plot");
    }

    void printPlotFooter() {
        this.closeTag();
        this.closeTag();
    }

    void printBounds(MovableObject movableObject) {
        if (!movableObject.hasDefaultPosition()) {
            this.setAttribute("x", movableObject.getX());
            this.setAttribute("y", movableObject.getY());
            this.setAttribute("width", movableObject.getWidth());
            this.setAttribute("height", movableObject.getHeight());
            this.printTag("bounds");
        }
    }

    void print(Border border) {
        if (border == null) {
            this.setAttribute("type", "None");
        } else if (border == BorderFactory.createLoweredBevelBorder()) {
            this.setAttribute("type", "Bevel In");
        } else if (border == BorderFactory.createRaisedBevelBorder()) {
            this.setAttribute("type", "Bevel Out");
        } else if (border == BorderFactory.createEtchedBorder()) {
            this.setAttribute("type", "Etched");
        } else if (border instanceof ShadowBorder) {
            this.setAttribute("type", "Shadow");
        } else if (border instanceof LineBorder) {
            this.setAttribute("type", "Line");
            this.setAttribute("color", ColorConverter.colorToString(((LineBorder)border).getLineColor()));
        } else {
            this.setAttribute("type", "None");
        }
        this.printTag("border");
    }

    void print(Font font) {
        String string;
        switch (font.getStyle()) {
            default: {
                string = "PLAIN";
                break;
            }
            case 1: {
                string = "BOLD";
                break;
            }
            case 2: {
                string = "ITALIC";
                break;
            }
            case 3: {
                string = "BOLD+ITALIC";
            }
        }
        this.setAttribute("face", font.getName());
        this.setAttribute("points", font.getSize());
        this.setAttribute("style", string);
        this.printTag("font");
    }

    static String convertStyleToString(int n) {
        switch (n) {
            case 1: {
                return "box";
            }
            case 8: {
                return "circle";
            }
            case 7: {
                return "cross";
            }
            case 3: {
                return "diamond";
            }
            case 0: {
                return "dot";
            }
            case 6: {
                return "horiz line";
            }
            case 9: {
                return "square";
            }
            case 4: {
                return "star";
            }
            case 2: {
                return "triangle";
            }
            case 5: {
                return "vert line";
            }
        }
        System.err.println("ERROR: unrecognized style, using default instead.");
        return "box";
    }

    static int convertStringToStyle(String string) {
        if (string.equalsIgnoreCase("box")) {
            return 1;
        }
        if (string.equalsIgnoreCase("circle")) {
            return 8;
        }
        if (string.equalsIgnoreCase("cross")) {
            return 7;
        }
        if (string.equalsIgnoreCase("diamond")) {
            return 3;
        }
        if (string.equalsIgnoreCase("dot")) {
            return 0;
        }
        if (string.equalsIgnoreCase("horiz line")) {
            return 6;
        }
        if (string.equalsIgnoreCase("square")) {
            return 9;
        }
        if (string.equalsIgnoreCase("star")) {
            return 4;
        }
        if (string.equalsIgnoreCase("triangle")) {
            return 2;
        }
        if (string.equalsIgnoreCase("vert line")) {
            return 5;
        }
        System.err.println("ERROR: unrecognized style, using default instead.");
        return 1;
    }

    static String convertAxisTypeToString(int n) {
        switch (n) {
            case 2: {
                return "string";
            }
            case 1: {
                return "double";
            }
            case 3: {
                return "date";
            }
            case 5: {
                return "time";
            }
        }
        System.err.println("ERROR: unrecognized axis type, using double instead.");
        return "double";
    }

    static int convertStringToAxisType(String string) {
        if (string.equalsIgnoreCase("string")) {
            return 2;
        }
        if (string.equalsIgnoreCase("double")) {
            return 1;
        }
        if (string.equalsIgnoreCase("date")) {
            return 3;
        }
        if (string.equalsIgnoreCase("time")) {
            return 5;
        }
        System.err.println("ERROR: unrecognized axis type, using double instead.");
        return 1;
    }

    private static String convertLegendToString(int n) {
        switch (n) {
            case 1: {
                return "automatic";
            }
            case 0: {
                return "never";
            }
            case 2: {
                return "always";
            }
        }
        System.err.println("ERROR: unrecognized legend type, using AUTOMATIC instead.");
        return "automatic";
    }

    static int convertStringToLegend(String string) {
        if (string.equalsIgnoreCase("automatic")) {
            return 1;
        }
        if (string.equalsIgnoreCase("always")) {
            return 2;
        }
        if (string.equalsIgnoreCase("never")) {
            return 0;
        }
        if (string.equalsIgnoreCase("true")) {
            return 2;
        }
        if (string.equalsIgnoreCase("false")) {
            return 0;
        }
        System.err.println("ERROR: unrecognized legend type, using AUTOMATIC instead");
        return 1;
    }

    private static String convertShowTitleToString(int n) {
        switch (n) {
            case 3: {
                return "automatic";
            }
            case 2: {
                return "never";
            }
            case 1: {
                return "always";
            }
        }
        System.err.println("ERROR: unrecognized showTitles type, using AUTOMATIC instead.");
        return "automatic";
    }

    static int convertStringToShowTitle(String string) {
        if (string.equalsIgnoreCase("automatic")) {
            return 3;
        }
        if (string.equalsIgnoreCase("never")) {
            return 2;
        }
        if (string.equalsIgnoreCase("always")) {
            return 1;
        }
        System.err.println("ERROR: unrecognized showTitle type, using SHOWTITLES_AUTOMATIC instead");
        return 3;
    }

    private static String convertAlignmentToString(int n) {
        switch (n) {
            case 1: {
                return "left";
            }
            case 2: {
                return "right";
            }
            case 3: {
                return "none";
            }
        }
        System.err.println("ERROR: unrecognized alignment type, using NONE instead.");
        return "none";
    }

    static int convertStringToAlignment(String string) {
        if (string.equalsIgnoreCase("left")) {
            return 1;
        }
        if (string.equalsIgnoreCase("right")) {
            return 2;
        }
        if (string.equalsIgnoreCase("none")) {
            return 3;
        }
        System.err.println("ERROR: unrecognized alignment type, using NOALIGNSPLIT instead");
        return 3;
    }
}

