/*
 * Decompiled with CFR 0.152.
 */
package jas.plot;

import jas.plot.AxisType;
import jas.plot.DataArea;
import jas.plot.DoubleAxis;
import jas.plot.EditableLabel;
import jas.plot.FontMenuItem;
import jas.plot.HasPopupItems;
import jas.plot.PlotComponent;
import jas.plot.PlotGraphics;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class Axis
extends PlotComponent
implements HasPopupItems {
    public static final int VERTICAL = 1;
    public static final int HORIZONTAL = 2;
    private Color axisColor = null;
    private Color axisOriginDotColor = null;
    private Color majorTickMarkColor = null;
    private Color minorTickMarkColor = null;
    private Color textColor = null;
    private int axisOrientation;
    AxisType type;
    private final Point location = new Point();
    private final Dimension size = new Dimension();
    private boolean isVisible = false;
    boolean onLeftSide;
    private static FontMenuItem fontMenuItem = null;
    private int lastAxisLength = -1;
    static final int padAroundEdge = 3;
    static final int padFromAxis = 7;
    static /* synthetic */ Class class$jas$plot$DataArea;

    public Axis() {
        this(new DoubleAxis(), 1, true);
    }

    public Axis(AxisType axisType, int n) {
        this(axisType, n, true);
    }

    public Axis(int n) {
        this(new DoubleAxis(), n, true);
    }

    public Axis(int n, boolean bl) {
        this(new DoubleAxis(), n, bl);
    }

    public Axis(AxisType axisType, boolean bl) {
        this(axisType, 1, bl);
    }

    public Axis(AxisType axisType, int n, boolean bl) {
        this.type = axisType;
        this.axisOrientation = n;
        this.onLeftSide = bl;
        axisType.setAxis(this);
    }

    public void modifyPopupMenu(JPopupMenu jPopupMenu, Component component) {
        if (jPopupMenu.getComponentCount() > 0) {
            jPopupMenu.addSeparator();
        }
        jPopupMenu.add(new FontMenuItem(this, "Axis"));
        final DataArea dataArea = (DataArea)SwingUtilities.getAncestorOfClass(class$jas$plot$DataArea == null ? (class$jas$plot$DataArea = Axis.class$("jas.plot.DataArea")) : class$jas$plot$DataArea, this);
        final EditableLabel editableLabel = dataArea.getLabel(this);
        jPopupMenu.add(new JCheckBoxMenuItem("Show Axis Label", editableLabel != null){

            protected final void fireActionPerformed(ActionEvent actionEvent) {
                if (this.isSelected()) {
                    EditableLabel editableLabel2 = new EditableLabel("Label", "Axis Label");
                    dataArea.setLabel(Axis.this, editableLabel2);
                    editableLabel2.edit();
                } else {
                    dataArea.remove(editableLabel);
                }
            }
        });
        if (editableLabel != null) {
            jPopupMenu.add(new JMenuItem("Edit label text"){

                protected final void fireActionPerformed(ActionEvent actionEvent) {
                    editableLabel.edit();
                }
            });
        }
    }

    public final void setType(AxisType axisType) {
        this.type = axisType;
        axisType.setAxis(this);
        if (this.isVisible) {
            this.revalidate();
        }
    }

    public final void setFont(Font font) {
        super.setFont(font);
        this.type.labelsValid = false;
        this.revalidate();
    }

    public final AxisType getType() {
        return this.type;
    }

    public final int getMinLocation() {
        if (this.axisOrientation == 1) {
            return this.size.height - this.type.spaceRequirements.height + this.location.y;
        }
        return this.type.spaceRequirements.width + this.location.x;
    }

    public final int getMaxLocation() {
        if (this.axisOrientation == 1) {
            return 3 + this.location.y + this.type.spaceRequirements.flowPastEnd;
        }
        return this.size.width - 3 + this.location.x - this.type.spaceRequirements.flowPastEnd;
    }

    final void paint(PlotGraphics plotGraphics) {
        Point point = new Point(this.onLeftSide ? this.type.spaceRequirements.width : this.size.width - this.type.spaceRequirements.width, this.size.height - this.type.spaceRequirements.height);
        point.translate(this.location.x, this.location.y);
        plotGraphics.setFont(this.getFont());
        int n = this.type.getMajorTickMarkLength();
        if (this.axisOrientation == 1) {
            plotGraphics.setColor(this.getAxisColor());
            plotGraphics.drawLine(point.x, point.y, point.x, this.location.y + 3 + this.type.spaceRequirements.flowPastEnd);
            plotGraphics.setColor(this.getAxisOriginDotColor());
            plotGraphics.drawRect(point.x - 1, point.y - 1, point.x + 1, point.y + 1);
            this.type.paintAxis(plotGraphics, point.x, point.y, point.y - 3 - this.type.spaceRequirements.flowPastEnd - this.location.y, this.getTextColor(), this.getMajorTickMarkColor(), this.getMinorTickMarkColor());
        } else if (this.axisOrientation == 2) {
            plotGraphics.setColor(this.getAxisColor());
            plotGraphics.drawLine(point.x, point.y, this.location.x + this.size.width - 3 - this.type.spaceRequirements.flowPastEnd, point.y);
            this.type.paintAxis(plotGraphics, point.x, point.y, this.size.width - 3 - this.type.spaceRequirements.flowPastEnd - point.x + this.location.x, this.getTextColor(), this.getMajorTickMarkColor(), this.getMinorTickMarkColor());
        }
    }

    public final void setBounds(int n, int n2, int n3, int n4) {
        this.size.setSize(n3, n4);
        this.location.setLocation(n, n2);
        super.setBounds(n, n2, n3, n4);
    }

    public final int getAxisOrientation() {
        return this.axisOrientation;
    }

    protected final void setAxisOrientation(int n) {
        this.axisOrientation = n;
    }

    public final boolean getOnLeftSide() {
        return this.onLeftSide;
    }

    public final void setOnLeftSide(boolean bl) {
        this.onLeftSide = bl;
    }

    final void assumeAxisLength(int n) {
        if (n != this.lastAxisLength || !this.type.labelsValid) {
            this.type.assumeAxisLength(n);
            this.lastAxisLength = n;
        }
    }

    public Color getAxisColor() {
        if (this.axisColor != null) {
            return this.axisColor;
        }
        return this.getForeground();
    }

    public void setAxisColor(Color color) {
        this.axisColor = color;
    }

    public Color getAxisOriginDotColor() {
        if (this.axisOriginDotColor != null) {
            return this.axisOriginDotColor;
        }
        return this.getAxisColor();
    }

    public void setAxisOriginDotColor(Color color) {
        this.axisOriginDotColor = color;
    }

    public Color getMajorTickMarkColor() {
        if (this.majorTickMarkColor != null) {
            return this.majorTickMarkColor;
        }
        return this.getAxisColor();
    }

    public void setMajorTickMarkColor(Color color) {
        this.majorTickMarkColor = color;
    }

    public Color getMinorTickMarkColor() {
        if (this.minorTickMarkColor != null) {
            return this.minorTickMarkColor;
        }
        return this.getAxisColor();
    }

    public void setMinorTickMarkColor(Color color) {
        this.minorTickMarkColor = color;
    }

    public Color getTextColor() {
        if (this.textColor != null) {
            return this.textColor;
        }
        return this.getAxisColor();
    }

    public void setTextColor(Color color) {
        this.textColor = color;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

