/*
 * Decompiled with CFR 0.152.
 */
package jas.plot;

import jas.plot.AxisLabel;
import jas.plot.AxisType;
import jas.plot.CoordinateTransformation;
import jas.plot.DateCoordinateTransformation;
import jas.plot.PlotGraphics;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Vector;

public final class DateAxis
extends AxisType
implements DateCoordinateTransformation {
    private TimeZone timeZone = TimeZone.getDefault();
    private final int majorTickLength = 5;
    private final int maxCharsPerLabel = 6;
    private final int minSpaceBetweenLabels = 3;
    private final int minNumberOfDivisions = 1;
    private long data_min;
    private long data_max;
    private long axis_min;
    private long axis_max;
    private DateLabel[] labels;
    private final JASCalendar calendar = new JASCalendar();
    private final SimpleDateFormat format = new SimpleDateFormat();
    private final Vector labelVector = new Vector();
    boolean useSuggestedRange = false;
    private final int MILLISECONDS = 0;
    private final int SECONDS = 1;
    private final int MINUTES = 2;
    private final int HOURS = 3;
    private final int DAYS = 4;
    private final int MONTHS = 5;
    private final int YEARS = 6;
    private static final long[] scaleFactors = new long[]{1L, 1000L, 60000L, 3600000L, 86400000L, 2592000000L, 31104000000L};
    private static final int[] calendarFields = new int[]{14, 13, 12, 11, 5, 2, 1};
    private final String[] normalTimeFormats = new String[]{"s.SSS", "s", "H:mm", "H:mm", "d", "MMM", "yyyy"};
    private final String[] horizontalAxisSecondLineFirstEntryTimeFormats = new String[]{"MMM d, yyyy, H:mm", "MMM d, yyyy, H:mm", "MMM d, yyyy", "MMM d, yyyy", "MMM, yyyy", "yyyy", null};
    private final String[] horizontalAxisSecondLineSubsequentEntryTimeFormats = new String[]{"H:mm", "H:mm", "MMM d", "MMM d", "MMM", "yyyy", null};
    private final String[] verticalAxisFirstEntryTimeFormats = new String[]{"MMM d, yyyy, H:mm:ss.SSS", "MMM d, yyyy, H:mm:ss", "MMM d, yyyy, H:mm", "MMM d, yyyy, H:mm", "MMM d, yyyy", "MMM, yyyy", "yyyy"};
    private final String[] verticalAxisChangedUnitsTimeFormatsPrefix = new String[]{"(H:mm) ", "(H:mm) ", "MMM d, ", "MMM d, ", "MMM ", "(yyyy) ", null};
    private final int[] monthLengths = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    CoordinateTransformation getCoordinateTransformation() {
        return this;
    }

    void assumeAxisLength(int n) {
        Font font = this.axis.getFont();
        FontMetrics fontMetrics = this.axis.getToolkit().getFontMetrics(font);
        int n2 = this.getMaxNumberOfDivisions(fontMetrics, n);
        if (!this.labelsValid || this.labels == null || this.labels.length > n2 || this.labels.length < n2 / 2) {
            this.labels = this.getAxisLabels(n2);
        }
        DateLabel dateLabel = this.labels[0];
        DateLabel dateLabel2 = this.labels[this.labels.length - 1];
        if (this.axis.getAxisOrientation() == 2) {
            this.spaceRequirements.height = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + 7;
            this.spaceRequirements.width = Math.max(fontMetrics.stringWidth(dateLabel.text) / 2 - (int)(dateLabel.position * (double)n), 0);
            if (dateLabel.subtext != null) {
                this.spaceRequirements.height += fontMetrics.getHeight();
                this.spaceRequirements.width = Math.max(fontMetrics.stringWidth(dateLabel.subtext) - (int)(dateLabel.position * (double)n), this.spaceRequirements.width);
            }
            int n3 = fontMetrics.stringWidth(dateLabel2.text);
            if (dateLabel2.subtext != null) {
                n3 = Math.max(fontMetrics.stringWidth(dateLabel2.subtext), n3);
            }
            this.spaceRequirements.flowPastEnd = Math.max(n3 / 2 + (int)(dateLabel2.position * (double)n) - n, 0);
        } else {
            int n4 = 0;
            for (int i = 0; i < this.labels.length; ++i) {
                n4 = Math.max(fontMetrics.stringWidth(this.labels[i].text), n4);
            }
            this.spaceRequirements.width = n4 + 7;
            this.spaceRequirements.height = Math.max(fontMetrics.getAscent() / 2 + fontMetrics.getMaxDescent() - (int)(dateLabel.position * (double)n), 0);
            this.spaceRequirements.flowPastEnd = Math.max(fontMetrics.getMaxAscent() - fontMetrics.getAscent() / 2 + (int)(dateLabel2.position * (double)n) - n, 0);
        }
    }

    void paintAxis(PlotGraphics plotGraphics, double d, double d2, double d3, Color color, Color color2, Color color3) {
        FontMetrics fontMetrics = plotGraphics.getFontMetrics();
        if (this.axis.getAxisOrientation() == 2) {
            double d4 = d2 + (double)fontMetrics.getMaxAscent() + 7.0;
            for (int i = 0; i < this.labels.length; ++i) {
                String string = this.labels[i].text;
                double d5 = d + this.labels[i].position * d3;
                plotGraphics.setColor(color);
                plotGraphics.drawString(string, d5 - (double)(fontMetrics.stringWidth(string) / 2), d4);
                String string2 = this.labels[i].subtext;
                if (string2 != null) {
                    plotGraphics.drawString(string2, i != 0 ? d5 - (double)(fontMetrics.stringWidth(string2) / 2) : d5 - (double)fontMetrics.stringWidth(string2), d4 + (double)fontMetrics.getHeight());
                }
                plotGraphics.setColor(color2);
                plotGraphics.drawLine(d5, d2 + 5.0, d5, d2 - 5.0);
            }
        } else {
            double d6 = this.axis.onLeftSide ? d - 7.0 : d + 7.0;
            double d7 = fontMetrics.getAscent() / 2;
            for (int i = 0; i < this.labels.length; ++i) {
                String string = this.labels[i].text;
                double d8 = d2 - this.labels[i].position * d3;
                plotGraphics.setColor(color2);
                plotGraphics.drawLine(d - 5.0, d8, d + 5.0, d8);
                plotGraphics.setColor(color);
                plotGraphics.drawString(string, this.axis.onLeftSide ? d6 - (double)fontMetrics.stringWidth(string) : d6, d8 + d7);
            }
        }
    }

    int getMajorTickMarkLength() {
        return 5;
    }

    public double convert(long l) {
        return this.timeToPixel(l);
    }

    public long map(double d) {
        int n = this.axis.getMinLocation();
        int n2 = this.axis.getMaxLocation();
        double d2 = (d - (double)n) / (double)(n2 - n);
        return this.axis_min + (long)(d2 * (double)(this.axis_max - this.axis_min));
    }

    private int getMaxNumberOfDivisions(FontMetrics fontMetrics, int n) {
        return Math.max(1, this.axis.getAxisOrientation() == 2 ? n / (fontMetrics.charWidth('5') * 6 + 3) : n / (fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + fontMetrics.getHeight() + 3));
    }

    private int getScaleIndex(long l) {
        long l2 = l * 2L;
        int n = scaleFactors.length;
        while (--n > 0 && l2 < scaleFactors[n]) {
        }
        return n;
    }

    private boolean setToZero(int n) {
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            int n2 = calendarFields[i];
            int n3 = this.calendar.getMinimum(n2);
            boolean bl2 = this.calendar.get(n2) == n3;
            boolean bl3 = bl = bl && bl2;
            if (bl2) continue;
            this.calendar.set(n2, n3);
        }
        return bl;
    }

    private DateLabel[] getAxisLabels(int n) {
        Object[] objectArray;
        int n2;
        int n3;
        int n4;
        this.calendar.setTimeInMillis(this.data_min);
        this.calendar.setTimeZone(this.timeZone);
        this.format.setTimeZone(this.timeZone);
        this.axis_min = this.data_min;
        this.axis_max = this.data_max;
        this.labelsValid = true;
        long l = this.data_max - this.data_min;
        int n5 = this.getScaleIndex(l / (long)n);
        int n6 = 1;
        if ((int)(l / scaleFactors[n5]) > n) {
            int[] nArray;
            n4 = (int)(l / (long)n / scaleFactors[n5]) + 1;
            if (n5 == 4) {
                int[] nArray2;
                nArray = nArray2 = new int[]{2, 5, 10, 15};
            } else if (n5 == 6) {
                if (n4 > 100) {
                    n3 = 1;
                    for (int i = n4; i > 100; i /= 100) {
                        n3 *= 100;
                    }
                    int[] nArray3 = new int[]{2 * n3, 5 * n3, 10 * n3, 25 * n3, 50 * n3, 100 * n3};
                    nArray = nArray3;
                } else {
                    int[] nArray4 = new int[]{2, 5, 10, 25, 50, 100};
                    nArray = nArray4;
                }
            } else if (n5 == 0) {
                int[] nArray5 = new int[]{2, 5, 10, 25, 50, 100, 200, 250, 500};
                nArray = nArray5;
            } else if (n5 == 5) {
                int[] nArray6 = new int[]{2, 3, 4, 6};
                nArray = nArray6;
            } else if (n5 == 3) {
                int[] nArray7 = new int[]{2, 3, 4, 6, 12};
                nArray = nArray7;
            } else {
                int[] nArray8 = new int[]{2, 5, 10, 15, 20, 30};
                nArray = nArray8;
            }
            n2 = 0;
            while (n2 - 1 < nArray.length && n4 > nArray[n2]) {
                ++n2;
            }
            n6 = nArray[n2];
        }
        n4 = this.setToZero(n5);
        if (this.useSuggestedRange) {
            int n7 = this.calendar.get(calendarFields[n5]);
            n2 = (n5 == 4 && n6 == 2 ? n7 - 1 : n7) % n6;
            if (n5 == 4 && n2 != 0 && n7 - n2 + n6 > this.monthLengths[this.calendar.get(2)]) {
                this.calendar.add(calendarFields[n5], -n2 - n6);
            } else if (n2 != 0) {
                if (n5 != 4 || n7 > n6) {
                    this.calendar.add(calendarFields[n5], -n2);
                } else {
                    this.calendar.set(5, 1);
                }
            }
            this.axis_min = this.calendar.getTimeInMillis();
            this.calendar.setTimeInMillis(this.data_max);
            n7 = this.calendar.get(calendarFields[n5]);
            n2 = (n5 == 4 && n6 == 2 ? n7 - 1 : n7) % n6;
            if (!this.setToZero(n5) || n2 != 0) {
                this.calendar.add(calendarFields[n5], n6 - n2);
            }
            this.axis_max = this.calendar.getTimeInMillis();
            this.calendar.setTimeInMillis(this.axis_min);
        } else if (n4 == 0) {
            if (n5 == 4 && this.calendar.get(5) % n6 != 0 && this.calendar.get(5) + n6 >= this.monthLengths[this.calendar.get(2)]) {
                this.calendar.set(5, 1);
                this.calendar.add(2, 1);
            } else if (n5 == 4 && this.calendar.get(5) < n6) {
                this.calendar.set(5, 1);
            } else {
                this.calendar.add(calendarFields[n5], n6 - this.calendar.get(calendarFields[n5]) % n6);
            }
        }
        String string = this.normalTimeFormats[n5];
        n2 = -1;
        n3 = this.axis.getAxisOrientation() == 2 ? 1 : 0;
        boolean bl = true;
        do {
            int n8;
            objectArray = new DateLabel();
            this.labelVector.addElement(objectArray);
            this.format.applyPattern(bl && n3 == 0 ? this.verticalAxisFirstEntryTimeFormats[n5] : string);
            objectArray.text = this.format.format(this.calendar.getTime());
            objectArray.position = this.timeToDouble(this.calendar.getTimeInMillis());
            if (bl) {
                String string2;
                bl = false;
                if (n3 != 0 && (string2 = this.horizontalAxisSecondLineFirstEntryTimeFormats[n5]) != null) {
                    this.format.applyPattern(string2);
                    objectArray.subtext = this.format.format(this.calendar.getTime());
                }
                if (n5 + 1 < calendarFields.length) {
                    n2 = this.calendar.get(calendarFields[this.getIndexForNextHighestField(n5)]);
                }
            } else if (n5 + 1 < calendarFields.length && (n8 = this.calendar.get(calendarFields[this.getIndexForNextHighestField(n5)])) != n2) {
                if (n3 != 0) {
                    this.format.applyPattern(this.horizontalAxisSecondLineSubsequentEntryTimeFormats[n5]);
                    objectArray.subtext = this.format.format(this.calendar.getTime());
                } else {
                    this.format.applyPattern(this.verticalAxisChangedUnitsTimeFormatsPrefix[n5]);
                    objectArray.text = this.format.format(this.calendar.getTime()).concat(objectArray.text);
                }
                n2 = n8;
            }
            if (n5 == 4 && n6 != 1) {
                int n9 = this.calendar.get(5);
                int n10 = n9 + n6;
                if (n9 == 1 && n6 != 2) {
                    --n10;
                }
                if (n10 + n6 / 2 > this.monthLengths[this.calendar.get(2)]) {
                    this.calendar.set(5, 1);
                    this.calendar.add(2, 1);
                    if (this.calendar.getTimeInMillis() <= this.axis_max || n10 > this.monthLengths[this.calendar.get(2)]) continue;
                    this.calendar.add(2, -1);
                    this.calendar.set(5, n10);
                    continue;
                }
                this.calendar.set(5, n10);
                continue;
            }
            this.calendar.add(calendarFields[n5], n6);
        } while (this.calendar.getTimeInMillis() <= this.axis_max);
        objectArray = new DateLabel[this.labelVector.size()];
        this.labelVector.copyInto(objectArray);
        this.labelVector.removeAllElements();
        return objectArray;
    }

    private int getIndexForNextHighestField(int n) {
        switch (n) {
            case 0: {
                return 2;
            }
            case 2: {
                return 4;
            }
        }
        return n + 1;
    }

    private double timeToPixel(long l) {
        int n = this.axis.getMinLocation();
        int n2 = this.axis.getMaxLocation();
        return (double)n + this.timeToDouble(l) * (double)(n2 - n);
    }

    private double timeToDouble(long l) {
        return (double)(l - this.axis_min) / (double)(this.axis_max - this.axis_min);
    }

    public void setMin(long l) {
        if (this.data_min != l) {
            this.labelsValid = false;
            this.data_min = l;
            if (this.axis != null) {
                this.axis.revalidate();
            }
        }
    }

    public void setMax(long l) {
        if (this.data_max != l) {
            this.labelsValid = false;
            this.data_max = l;
            if (this.axis != null) {
                this.axis.revalidate();
            }
        }
    }

    public long getDataMin() {
        return this.data_min;
    }

    public long getDataMax() {
        return this.data_max;
    }

    public long getAxisMin() {
        return this.axis_min;
    }

    public long getAxisMax() {
        return this.axis_max;
    }

    public void setTimeZone(TimeZone timeZone) {
        if (this.timeZone != timeZone) {
            this.labelsValid = false;
            this.timeZone = timeZone;
        }
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setUseSuggestedRange(boolean bl) {
        if (this.useSuggestedRange != bl) {
            this.labelsValid = false;
            this.useSuggestedRange = bl;
            if (this.axis != null) {
                this.axis.revalidate();
            }
        }
    }

    public boolean getUseSuggestedRange() {
        return this.useSuggestedRange;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeBoolean(this.useSuggestedRange);
        objectOutput.writeObject(this.timeZone);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.useSuggestedRange = objectInput.readBoolean();
        this.timeZone = (TimeZone)objectInput.readObject();
    }

    private static final class JASCalendar
    extends GregorianCalendar {
        private JASCalendar() {
        }

        public long getTimeInMillis() {
            return super.getTimeInMillis();
        }

        public void setTimeInMillis(long l) {
            super.setTimeInMillis(l);
        }
    }

    private static final class DateLabel
    extends AxisLabel {
        String subtext = null;

        private DateLabel() {
        }
    }
}

