/*
 * Decompiled with CFR 0.152.
 */
package jas.plot;

import jas.plot.AxisLabel;
import jas.plot.AxisType;
import jas.plot.CoordinateTransformation;
import jas.plot.DoubleCoordinateTransformation;
import jas.plot.DoubleNumberFormatter;
import jas.plot.PlotGraphics;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class DoubleAxis
extends AxisType
implements DoubleCoordinateTransformation {
    private final StringBuffer b = new StringBuffer();
    private final double log10 = Math.log(10.0);
    private final int majorTickLength = 5;
    private final int minorTickLength = 3;
    private final int maxCharsPerLabel = 5;
    private final int minSpaceBetweenLabels = 3;
    private final int minNumberOfDivisions = 1;
    private int nDivisions = 0;
    private double data_min = 0.0;
    private double data_max = 1.0;
    private double plot_min = 0.0;
    private double plot_max = 1.0;
    private AxisLabel[] labels;
    private double[] minorTickPositions;
    private boolean logarithmic;
    private int scale_power;
    private boolean useSuggestedRange = false;
    private boolean tryForNewLabelsOnExpansion;
    private boolean hideMinorTicks = false;

    public DoubleAxis() {
        this(false);
    }

    public DoubleAxis(boolean bl) {
        this.logarithmic = bl;
    }

    public void setLogarithmic(boolean bl) {
        if (this.logarithmic != bl) {
            this.labelsValid = false;
            this.logarithmic = bl;
            if (this.axis != null) {
                this.axis.revalidate();
            }
        }
    }

    public boolean isLogarithmic() {
        return this.logarithmic;
    }

    public void setUseSuggestedRange(boolean bl) {
        if (this.useSuggestedRange != bl) {
            this.labelsValid = false;
            this.useSuggestedRange = bl;
            if (this.axis != null) {
                this.axis.revalidate();
            }
        }
    }

    public boolean getUseSuggestedRange() {
        return this.useSuggestedRange;
    }

    public void setMin(double d) {
        if (this.data_min != d) {
            this.labelsValid = false;
            this.data_min = d;
            this.plot_min = d;
            if (this.axis != null) {
                this.axis.revalidate();
            }
        }
    }

    public void setMax(double d) {
        if (this.data_max != d) {
            this.labelsValid = false;
            this.data_max = d;
            this.plot_max = d;
            if (this.axis != null) {
                this.axis.revalidate();
            }
        }
    }

    public double getPlotMin() {
        return this.plot_min;
    }

    public double getPlotMax() {
        return this.plot_max;
    }

    public double getDataMin() {
        return this.data_min;
    }

    public double getDataMax() {
        return this.data_max;
    }

    private int stringWidth(FontMetrics fontMetrics, String string) {
        if (string.startsWith("e")) {
            return fontMetrics.stringWidth(string) + fontMetrics.stringWidth("10") - fontMetrics.charWidth('e');
        }
        return fontMetrics.stringWidth(string);
    }

    private int round(double d, boolean bl) {
        block3: {
            double d2;
            block2: {
                d2 = Math.round(d);
                if (d == d2) break block2;
                double d3 = Math.abs(d - d2);
                double d4 = d != 0.0 ? 1.0E-4 * Math.abs(d) : 1.0E-6;
                if (!(d3 < d4)) break block3;
            }
            return (int)d2;
        }
        return bl ? (int)Math.floor(d) : (int)Math.ceil(d);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean areEqual(double d, double d2) {
        if (d == d2) return true;
        double d3 = Math.abs(d2 - d);
        double d4 = d != 0.0 ? 1.0E-4 * d : 1.0E-6;
        if (!(d3 < Math.abs(d4))) return false;
        return true;
    }

    private int charsReq(int n) {
        if (n < 0) {
            return -n + 2;
        }
        return n + 1;
    }

    private void createNewLabels(int n) {
        this.labelsValid = true;
        double d = this.data_max == 0.0 ? 0.0 : Math.log(Math.abs(this.data_max)) / this.log10;
        int n2 = (int)Math.floor(d);
        this.scale_power = 0;
        if (n2 >= 5) {
            this.scale_power = n2;
        } else if (n2 <= -5) {
            this.scale_power = n2;
        }
        DoubleNumberFormatter doubleNumberFormatter = new DoubleNumberFormatter(this.scale_power);
        if (this.logarithmic) {
            double d2 = this.data_min == 0.0 ? 0.0 : Math.log(Math.abs(this.data_min)) / this.log10;
            int n3 = this.round(d2, this.useSuggestedRange);
            int n4 = this.round(d, !this.useSuggestedRange);
            int n5 = n4 - n3 + 1;
            if (n5 < (this.useSuggestedRange ? 3 : 2)) {
                this.tryForNewLabelsOnExpansion = true;
                this.minorTickPositions = null;
                int n6 = (int)Math.floor(Math.log(this.data_max - this.data_min) / this.log10) - (n > 40 ? 2 : 1);
                if (this.scale_power > 0 || n6 < 0) {
                    doubleNumberFormatter.setFractionDigits(this.scale_power - n6);
                } else {
                    doubleNumberFormatter.setFractionDigits(0);
                }
                double d3 = Math.pow(10.0, n6);
                this.nDivisions = Math.max(n, 2);
                if (this.useSuggestedRange) {
                    this.plot_min = Math.floor(this.data_min / d3) * d3;
                    this.plot_max = Math.ceil(this.data_max / d3) * d3;
                    d2 = Math.log(this.plot_min) / this.log10;
                    d = Math.log(this.plot_max) / this.log10;
                    this.labels = new AxisLabel[this.nDivisions];
                } else {
                    this.plot_min = this.data_min;
                    this.plot_max = this.data_max;
                    double d4 = Math.ceil(Math.pow(10.0, d) / d3) * d3;
                    this.labels = d4 < this.data_max || this.areEqual(d4, this.data_max) ? new AxisLabel[this.nDivisions] : new AxisLabel[this.nDivisions - 1];
                }
                for (int i = 0; i < this.labels.length; ++i) {
                    double d5 = Math.ceil(Math.pow(10.0, (double)i * (d - d2) / (double)(this.nDivisions - 1) + d2) / d3) * d3;
                    this.labels[i] = new AxisLabel();
                    this.labels[i].text = doubleNumberFormatter.format(d5);
                    this.labels[i].position = (Math.log(d5) / this.log10 - d2) / (d - d2);
                }
            } else {
                int n7;
                int n8;
                int n9;
                this.scale_power = 0;
                int n10 = n5;
                int n11 = 1;
                if (this.useSuggestedRange) {
                    d2 = n3;
                    d = n4;
                    this.plot_min = Math.pow(10.0, n3);
                    this.plot_max = Math.pow(10.0, n4);
                } else {
                    this.plot_min = this.data_min;
                    this.plot_max = this.data_max;
                }
                if (n5 > n && n > 1) {
                    this.tryForNewLabelsOnExpansion = true;
                    while (n11 + 1 < n5 && n5 / n11 >= n - 1) {
                        ++n11;
                    }
                    if (n11 != 1) {
                        n10 = n5 / n11;
                        if (this.useSuggestedRange) {
                            n9 = (n4 - n3) % n11;
                            if (n9 != 0) {
                                this.plot_max = Math.pow(10.0, n4 += n11 - n9);
                                d = n4;
                            }
                            ++n10;
                        }
                        if (n3 + n10 * n11 <= n4) {
                            ++n10;
                        }
                    }
                } else {
                    this.tryForNewLabelsOnExpansion = false;
                }
                this.nDivisions = n10;
                this.labels = new AxisLabel[n10];
                if (this.charsReq(n3) > 5 || this.charsReq(n4) > 5) {
                    n9 = n3;
                    for (n8 = 0; n8 < n10; ++n8) {
                        this.labels[n8] = new AxisLabel();
                        this.labels[n8].text = "e".concat(String.valueOf(n9));
                        this.labels[n8].position = ((double)n9 - d2) / (d - d2);
                        n9 += n11;
                    }
                } else if (n3 >= 0) {
                    this.b.setLength(0);
                    this.b.append('1');
                    for (n9 = 0; n9 < n3; ++n9) {
                        this.b.append('0');
                    }
                    for (n9 = 0; n9 < n10; ++n9) {
                        this.labels[n9] = new AxisLabel();
                        this.labels[n9].text = this.b.toString();
                        this.labels[n9].position = ((double)(n9 * n11 + n3) - d2) / (d - d2);
                        for (n8 = 0; n8 < n11; ++n8) {
                            this.b.append('0');
                        }
                    }
                } else if (n4 < 0) {
                    this.b.setLength(0);
                    this.b.append("0.1");
                    for (n9 = n4; n9 > -1; --n9) {
                        this.b.insert(2, '0');
                    }
                    for (n9 = n10 - 1; n9 >= 0; --n9) {
                        this.labels[n9] = new AxisLabel();
                        this.labels[n9].text = this.b.toString();
                        this.labels[n9].position = ((double)(n9 * n11 + n3) - d2) / (d - d2);
                        for (n8 = 0; n8 < n11; ++n8) {
                            this.b.insert(2, '0');
                        }
                    }
                } else {
                    n9 = n3;
                    for (n8 = 0; n8 < n10; ++n8) {
                        this.b.setLength(0);
                        if (n9 < 0) {
                            this.b.append("0.");
                            for (n7 = -1; n7 > n9; --n7) {
                                this.b.append('0');
                            }
                            this.b.append('1');
                        } else {
                            this.b.append('1');
                            for (n7 = 0; n7 < n9; ++n7) {
                                this.b.append('0');
                            }
                        }
                        this.labels[n8] = new AxisLabel();
                        this.labels[n8].text = this.b.toString();
                        this.labels[n8].position = ((double)n9 - d2) / (d - d2);
                        n9 += n11;
                    }
                }
                if (n11 == 1) {
                    double d6 = this.areEqual(n3, d2) ? this.plot_min : Math.pow(10.0, n3 - 1);
                    double d7 = this.plot_min / d6;
                    double d8 = Math.ceil(d7);
                    int n12 = d8 > d7 ? (int)d8 : (int)d8 + 1;
                    int n13 = (n4 - n3) * 8;
                    if (!this.useSuggestedRange) {
                        n13 += (int)((Math.pow(10.0, n3) - this.data_min) / Math.pow(10.0, n3 - 1));
                        n13 += (int)((this.data_max - Math.pow(10.0, n4)) / Math.pow(10.0, n4));
                    }
                    this.minorTickPositions = new double[n13];
                    for (int i = 0; i < n13; ++i) {
                        if (n12 > 9) {
                            n12 = 2;
                            d6 *= 10.0;
                        }
                        this.minorTickPositions[i] = (Math.log((double)n12 * d6) / this.log10 - d2) / (d - d2);
                        ++n12;
                    }
                } else {
                    this.minorTickPositions = null;
                    for (n9 = Math.min(6, n11); n9 > 1; --n9) {
                        if (n11 % n9 != 0) continue;
                        n8 = n11 / n9;
                        n7 = (n9 - 1) * (n4 - n3) / n11;
                        int n14 = n3 + n8;
                        this.minorTickPositions = new double[n7];
                        for (int i = 0; i < n7; ++i) {
                            if ((n14 - n3) % n11 == 0) {
                                n14 += n8;
                            }
                            this.minorTickPositions[i] = ((double)n14 - d2) / (d - d2);
                            n14 += n8;
                        }
                        break;
                    }
                }
            }
        } else {
            double d9;
            int n15;
            int n16;
            int n17;
            int n18;
            this.tryForNewLabelsOnExpansion = true;
            this.minorTickPositions = null;
            double d10 = this.data_max - this.data_min;
            double d11 = Math.floor(Math.log(d10) / this.log10) - 1.0;
            int n19 = 0;
            if (this.scale_power > 0) {
                n19 = this.scale_power - (int)d11;
            } else if (d11 < -0.5) {
                n19 = this.scale_power - (int)d11;
            }
            double d12 = Math.pow(10.0, d11);
            int n20 = this.round(this.data_min / d12, this.useSuggestedRange);
            int n21 = this.round(this.data_max / d12, !this.useSuggestedRange);
            if (this.useSuggestedRange) {
                this.plot_min = (double)n20 * d12;
                this.plot_max = (double)n21 * d12;
            } else {
                this.plot_min = this.data_min;
                this.plot_max = this.data_max;
            }
            int n22 = n21 - n20;
            int n23 = 1;
            if (n22 < n) {
                float f = (float)n22 / (float)n;
                n18 = 0;
                if (f < 0.5f) {
                    int[] nArray = new int[]{2, 4, 5, 10, 20};
                    for (n17 = 0; n17 < nArray.length && (double)(f * (float)(n16 = nArray[n17])) <= 1.0; ++n17) {
                        n18 = 1;
                        n23 = n16;
                    }
                }
                if (n18 != 0) {
                    n15 = this.useSuggestedRange ? n22 * n23 : n22 * n23 + (int)((this.plot_max / d12 - (double)n21) * (double)n23);
                    if (d11 < 0.5 || this.scale_power > 0) {
                        ++n19;
                    }
                    if (!(n23 != 4 && n23 != 20 || !(d11 < 1.5) && this.scale_power <= 0)) {
                        ++n19;
                    }
                } else {
                    n15 = Math.max(n22, 1);
                }
            } else if (n22 > n) {
                n15 = 1;
                int[] nArray = new int[]{2, 5, 10, 20, 25, 50};
                for (n18 = 0; n18 < nArray.length; ++n18) {
                    int n24 = n22 / nArray[n18];
                    if (n24 > n) continue;
                    n23 = nArray[n18];
                    n15 = n24;
                    if (this.useSuggestedRange) {
                        n17 = 0;
                        if (n20 % n23 != 0) {
                            n20 -= n20 % n23;
                            this.plot_min = (double)n20 * d12;
                            n17 = 1;
                        }
                        if (n21 % n23 != 0) {
                            n21 += n23 - n21 % n23;
                            this.plot_max = (double)n21 * d12;
                            n17 = 1;
                        }
                        if (n17 != 0) {
                            n15 = (n21 - n20) / n23;
                        }
                    }
                    if (n23 >= 10 && n23 != 25 && n19 > 0) {
                        --n19;
                    }
                    if (n20 % n23 != 0) {
                        int n25 = n17 = n20 > 0 ? n23 - n20 % n23 : -n20 % n23;
                        if (n17 > n21 - (n21 - n20) / n23 * n23 - n20) {
                            --n15;
                        }
                        n20 += n17;
                    }
                    break;
                }
            } else {
                n15 = Math.max(n22, 1);
            }
            double d13 = (double)n20 * d12;
            double d14 = d9 = n22 < n ? d12 / (double)n23 : d12 * (double)n23;
            if (n22 < n && d13 - d9 >= this.plot_min) {
                n16 = (int)((d13 - d9) / d9);
                d13 -= (double)n16 * d9;
                n15 += n16;
            }
            if (n15 < 0) {
                n15 = 0;
            }
            if (n15 > n) {
                n15 = n;
            }
            this.labels = new AxisLabel[n15 + 1];
            this.nDivisions = n15;
            doubleNumberFormatter.setFractionDigits(n19);
            for (n16 = 0; n16 < this.labels.length; ++n16) {
                double d15 = d13 + (double)n16 * d9;
                this.labels[n16] = new AxisLabel();
                this.labels[n16].text = doubleNumberFormatter.format(d15);
                this.labels[n16].position = (d15 - this.plot_min) / (this.plot_max - this.plot_min);
            }
        }
    }

    private int calculateMaxNDivisions(FontMetrics fontMetrics, int n) {
        int n2 = this.axis.getAxisOrientation() == 2 ? n / (fontMetrics.charWidth('5') * 5 + 3) : n / (fontMetrics.getHeight() + 3);
        return Math.max(1, n2);
    }

    private int getPowerOffset(FontMetrics fontMetrics) {
        return fontMetrics.getAscent() / 2;
    }

    void assumeAxisLength(int n) {
        Font font = this.axis.getFont();
        FontMetrics fontMetrics = this.axis.getToolkit().getFontMetrics(font);
        int n2 = this.calculateMaxNDivisions(fontMetrics, n);
        if (!this.labelsValid || this.labels == null || this.nDivisions < 2 || this.nDivisions > n2 || this.tryForNewLabelsOnExpansion && this.nDivisions < n2 / 2) {
            this.createNewLabels(n2);
        }
        this.hideMinorTicks = this.minorTickPositions == null || this.nDivisions > n2 / 3;
        int n3 = (int)((1.0 - this.labels[this.labels.length - 1].position) * (double)n);
        if (this.axis.getAxisOrientation() == 1) {
            this.spaceRequirements.width = this.longestStringLength(fontMetrics, this.labels) + 7;
            this.spaceRequirements.flowPastEnd = fontMetrics.getMaxAscent() - fontMetrics.getAscent() / 2 - n3;
            if (this.logarithmic && this.labels[0].text.startsWith("e")) {
                this.spaceRequirements.width += fontMetrics.stringWidth("10") - fontMetrics.charWidth('e');
                this.spaceRequirements.flowPastEnd += fontMetrics.getHeight() / 2;
            }
            if (this.scale_power != 0) {
                this.spaceRequirements.width = Math.max(fontMetrics.stringWidth("x10") + fontMetrics.stringWidth(String.valueOf(this.scale_power)), this.spaceRequirements.width);
                this.spaceRequirements.flowPastEnd += 3;
                if (this.spaceRequirements.flowPastEnd < 0) {
                    this.spaceRequirements.flowPastEnd = 0;
                }
                this.spaceRequirements.flowPastEnd += fontMetrics.getHeight() / 2 + fontMetrics.getAscent();
            } else if (this.spaceRequirements.flowPastEnd < 0) {
                this.spaceRequirements.flowPastEnd = 0;
            }
            int n4 = this.isLogarithmic() && this.labels[0].text.startsWith("e") ? fontMetrics.getHeight() / 2 + fontMetrics.getAscent() : fontMetrics.getAscent();
            this.spaceRequirements.height = Math.max(n4 / 2 - (int)(this.labels[0].position * (double)n), 0);
        } else {
            this.spaceRequirements.width = Math.max(this.stringWidth(fontMetrics, this.labels[0].text) / 2 - (int)(this.labels[0].position * (double)n), 0);
            this.spaceRequirements.flowPastEnd = this.stringWidth(fontMetrics, this.labels[this.labels.length - 1].text) / 2 - n3;
            int n5 = this.isLogarithmic() && this.labels[0].text.startsWith("e") ? fontMetrics.getHeight() / 2 + fontMetrics.getMaxAscent() + fontMetrics.getDescent() : fontMetrics.getMaxAscent() + fontMetrics.getDescent();
            this.spaceRequirements.height = n5 + 7;
            if (this.scale_power != 0) {
                this.spaceRequirements.height = Math.max(fontMetrics.getHeight() / 2 + fontMetrics.getAscent() + this.getPowerOffset(fontMetrics), this.spaceRequirements.height);
                this.spaceRequirements.flowPastEnd += 3;
                if (this.spaceRequirements.flowPastEnd < 0) {
                    this.spaceRequirements.flowPastEnd = 0;
                }
                this.spaceRequirements.flowPastEnd += fontMetrics.stringWidth("x10") + fontMetrics.stringWidth(String.valueOf(this.scale_power));
            } else if (this.spaceRequirements.flowPastEnd < 0) {
                this.spaceRequirements.flowPastEnd = 0;
            }
        }
    }

    public CoordinateTransformation getCoordinateTransformation() {
        return this;
    }

    void paintAxis(PlotGraphics plotGraphics, double d, double d2, double d3, Color color, Color color2, Color color3) {
        block18: {
            double d4;
            int n;
            boolean bl = this.axis.getAxisOrientation() == 2;
            boolean bl2 = !bl && this.axis.onLeftSide;
            double d5 = bl ? d : d2;
            double d6 = bl ? d + d3 : d2 - d3;
            FontMetrics fontMetrics = plotGraphics.getFontMetrics();
            int n2 = fontMetrics.getHeight();
            int n3 = fontMetrics.getAscent();
            int n4 = fontMetrics.getMaxAscent();
            if (this.labels == null) {
                return;
            }
            if (this.logarithmic) {
                n = this.labels[0].text.startsWith("e") ? 1 : 0;
                for (int i = 0; i < this.labels.length; ++i) {
                    double d7;
                    String string = this.labels[i].text;
                    String string2 = null;
                    if (n != 0) {
                        string2 = string.substring(1);
                        string = "10";
                        d4 = fontMetrics.stringWidth(string) + fontMetrics.stringWidth(string2);
                    } else {
                        d4 = fontMetrics.stringWidth(string);
                    }
                    double d8 = d5 + (double)((int)(this.labels[i].position * (d6 - d5)));
                    if (bl) {
                        plotGraphics.setColor(color2);
                        plotGraphics.drawLine(d8, d2 + 5.0, d8, d2 - 5.0);
                        d7 = d2 + (double)n4 + 7.0;
                        d8 -= d4 / 2.0;
                        plotGraphics.setColor(color);
                        if (n != 0) {
                            plotGraphics.drawString(string2, d8 + (double)fontMetrics.stringWidth(string), d7);
                            d7 += (double)(n2 / 2);
                        }
                        plotGraphics.drawString(string, d8, d7);
                        continue;
                    }
                    plotGraphics.setColor(color2);
                    plotGraphics.drawLine(d - 5.0, d8, d + 5.0, d8);
                    d7 = bl2 ? d - d4 - 7.0 : d + 7.0;
                    d8 += (double)(n3 / 2);
                    plotGraphics.setColor(color);
                    if (n != 0) {
                        plotGraphics.drawString(string2, d7 + (double)fontMetrics.stringWidth(string), d8 - (double)(n2 / 2));
                    }
                    plotGraphics.drawString(string, d7, d8);
                }
            } else {
                for (n = 0; n < this.labels.length; ++n) {
                    String string = this.labels[n].text;
                    double d9 = d5 + this.labels[n].position * (d6 - d5);
                    if (bl) {
                        plotGraphics.setColor(color2);
                        plotGraphics.drawLine(d9, d2 + 5.0, d9, d2 - 5.0);
                        d4 = d2 + (double)n4 + 7.0;
                        plotGraphics.setColor(color);
                        plotGraphics.drawString(string, d9 - (double)(fontMetrics.stringWidth(string) / 2), d4);
                        continue;
                    }
                    plotGraphics.setColor(color2);
                    plotGraphics.drawLine(d - 5.0, d9, d + 5.0, d9);
                    d4 = bl2 ? d - (double)fontMetrics.stringWidth(string) - 7.0 : d + 7.0;
                    plotGraphics.setColor(color);
                    plotGraphics.drawString(string, d4, d9 + (double)(n3 / 2));
                }
            }
            if (this.scale_power != 0) {
                plotGraphics.setColor(color);
                String string = String.valueOf(this.scale_power);
                if (bl) {
                    double d10 = d2 + (double)n3 + (double)this.getPowerOffset(fontMetrics);
                    double d11 = this.axis.getSize().width - 3 - fontMetrics.stringWidth(string);
                    plotGraphics.drawString("x10", d11 - (double)fontMetrics.stringWidth("x10"), d10 + (double)(n2 / 2));
                    plotGraphics.drawString(string, d11, d10);
                } else {
                    double d12 = n3 + 3;
                    double d13 = bl2 ? d - (double)fontMetrics.stringWidth(string) : d;
                    plotGraphics.drawString("x10", bl2 ? d13 - (double)fontMetrics.stringWidth("x10") : d13, d12 + (double)(n2 / 2));
                    plotGraphics.drawString(string, bl2 ? d13 : d13 + (double)fontMetrics.stringWidth("x10"), d12);
                }
            }
            if (this.hideMinorTicks || this.minorTickPositions == null || this.minorTickPositions.length == 0) break block18;
            plotGraphics.setColor(color3);
            if (bl) {
                for (int i = 0; i < this.minorTickPositions.length; ++i) {
                    double d14 = d5 + (double)((int)(this.minorTickPositions[i] * (d6 - d5)));
                    plotGraphics.drawLine(d14, d2 + 3.0, d14, d2 - 3.0);
                }
            } else {
                for (int i = 0; i < this.minorTickPositions.length; ++i) {
                    double d15 = d5 + (double)((int)(this.minorTickPositions[i] * (d6 - d5)));
                    plotGraphics.drawLine(d - 3.0, d15, d + 3.0, d15);
                }
            }
        }
    }

    int getMajorTickMarkLength() {
        return 5;
    }

    public double convert(double d) {
        int n = this.axis.getMinLocation();
        int n2 = this.axis.getMaxLocation();
        if (this.logarithmic) {
            double d2 = Math.log(this.plot_min) / this.log10;
            double d3 = Math.log(this.plot_max) / this.log10;
            d = d > 0.0 ? Math.log(d) / this.log10 : d2;
            double d4 = (d - d2) / (d3 - d2);
            return (double)n + d4 * (double)(n2 - n);
        }
        double d5 = (d - this.plot_min) / (this.plot_max - this.plot_min);
        return (double)n + d5 * (double)(n2 - n);
    }

    public double unConvert(double d) {
        int n = this.axis.getMinLocation();
        int n2 = this.axis.getMaxLocation();
        double d2 = (d - (double)n) / (double)(n2 - n);
        if (this.logarithmic) {
            double d3 = Math.log(this.plot_min) / this.log10;
            double d4 = Math.log(this.plot_max) / this.log10;
            return this.plot_min + d2 * (d4 - d3);
        }
        return this.plot_min + d2 * (this.plot_max - this.plot_min);
    }

    public double getIntersection() {
        return this.plot_min;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeBoolean(this.logarithmic);
        objectOutput.writeBoolean(this.useSuggestedRange);
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        this.logarithmic = objectInput.readBoolean();
        this.useSuggestedRange = objectInput.readBoolean();
    }
}

