/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import jas.util.DateListener;
import jas.util.DateModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;

class CalendarPane
extends JComponent
implements DateListener,
ActionListener {
    private JButton selectedButton;
    private Color fg;
    private Color bg;
    private Dimension buttonSize;
    private Dimension panelSize;
    private Point hidden;
    private DateModel model;
    private JButton[] days;
    private static final String[] labels = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};

    CalendarPane(DateModel dateModel) {
        int n;
        this.model = dateModel;
        dateModel.addDateListener(this);
        this.setLayout(null);
        Insets insets = new Insets(1, 1, 1, 1);
        this.days = new JButton[31];
        for (n = 0; n < 31; ++n) {
            this.days[n] = new JButton(String.valueOf(n + 1));
            this.days[n].addActionListener(this);
            this.add(this.days[n]);
        }
        this.fg = this.days[30].getForeground();
        this.bg = this.days[30].getBackground();
        this.buttonSize = this.days[30].getPreferredSize();
        this.panelSize = new Dimension(this.buttonSize.width * 7, this.buttonSize.height * 7);
        this.hidden = new Point(this.buttonSize.width * 10, this.buttonSize.height * 10);
        for (n = 0; n < 31; ++n) {
            this.days[n].setSize(this.buttonSize);
        }
        for (n = 0; n < 7; ++n) {
            JLabel jLabel = new JLabel(labels[n], 0);
            this.add(jLabel);
            jLabel.setLocation(n * this.buttonSize.width, 0);
            jLabel.setSize(this.buttonSize);
        }
        this.layoutCalendar();
    }

    public Dimension getPreferredSize() {
        return this.panelSize;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        int n = Integer.valueOf(string);
        this.model.set(5, n);
    }

    public void dateChanged() {
        this.layoutCalendar();
    }

    void layoutCalendar() {
        int n;
        Calendar calendar = this.model.getCalendar();
        int n2 = calendar.get(5) - 1;
        if (this.selectedButton != this.days[n2]) {
            if (this.selectedButton != null) {
                this.selectedButton.setForeground(this.fg);
                this.selectedButton.setBackground(this.bg);
                this.selectedButton.repaint();
            }
            this.selectedButton = this.days[n2];
            this.selectedButton.setForeground(UIManager.getColor("textHighlightText"));
            this.selectedButton.setBackground(UIManager.getColor("textHighlight"));
            this.selectedButton.repaint();
        }
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.set(5, 1);
        for (n = 0; n < this.model.getDaysInMonth(); ++n) {
            int n3 = (calendar2.get(7) - 1) * this.buttonSize.width;
            int n4 = calendar2.get(4) * this.buttonSize.height;
            this.days[n].setLocation(n3, n4);
            calendar2.add(5, 1);
        }
        while (n < 31) {
            this.days[n].setLocation(this.hidden);
            ++n;
        }
    }
}

