/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class GetOptions {
    protected String[] params;
    protected Vector pVector = null;
    protected Hashtable shortToLongMap = new Hashtable();
    protected Hashtable longToIsFlagMap = new Hashtable();
    protected Hashtable longToComment;
    protected Hashtable longToOptionsMap = new Hashtable();

    public GetOptions() {
        this.longToComment = new Hashtable();
        this.params = new String[0];
    }

    public void addOption(String string, boolean bl) {
        this.longToIsFlagMap.put(string, new Boolean(bl));
    }

    public void addOption(String string, boolean bl, String string2) {
        this.longToIsFlagMap.put(string, new Boolean(bl));
        this.longToComment.put(string, string2);
    }

    public void addOption(char c, boolean bl) {
        this.addOption(new Character(c).toString(), c, bl);
    }

    public void addOption(char c, boolean bl, String string) {
        this.addOption(new Character(c).toString(), c, bl, string);
    }

    public void addOption(String string, char c, boolean bl) {
        this.addOption(string, c, bl, null);
    }

    public void addOption(String string, char c, boolean bl, String string2) {
        this.shortToLongMap.put(new Character(c).toString(), string);
        this.longToIsFlagMap.put(string, new Boolean(bl));
        if (string2 != null) {
            this.longToComment.put(string, string2);
        }
    }

    public boolean isLegalOption(String string) {
        return this.longToIsFlagMap.containsKey(string);
    }

    public boolean hasOption(String string) {
        return this.longToOptionsMap.containsKey(string);
    }

    public String getOption(String string) {
        return this.longToOptionsMap.get(string).toString();
    }

    public String getComment(String string) {
        if (this.longToComment.containsKey(string)) {
            return this.longToComment.get(string).toString();
        }
        return null;
    }

    public void dumpOptions() {
        System.out.println("Options:");
        System.out.println();
        System.out.println("Short Long         Value    Comment");
        System.out.println("Name  Name         Required");
        System.out.println("----- ------------ -------- ---------------------------");
        Enumeration enumeration = this.getValidOptions();
        while (enumeration.hasMoreElements()) {
            System.out.println(enumeration.nextElement());
        }
    }

    private Enumeration getValidOptions() {
        Enumeration enumeration = this.shortToLongMap.keys();
        Vector<String> vector = new Vector<String>();
        String string = "";
        String string2 = "";
        while (enumeration.hasMoreElements()) {
            string = enumeration.nextElement().toString();
            string2 = this.shortToLongMap.get(string).toString();
            vector.addElement(this.formElement(string, string2));
        }
        Enumeration enumeration2 = this.longToIsFlagMap.keys();
        while (enumeration2.hasMoreElements()) {
            string2 = enumeration2.nextElement().toString();
            if (this.shortToLongMap.containsKey(string)) continue;
            vector.addElement(this.formElement(" ", string2));
        }
        return vector.elements();
    }

    private String formElement(String string, String string2) {
        String string3 = (Boolean)this.longToIsFlagMap.get(string2) != false ? "no" : "yes";
        return this.pad(string, 5) + " " + this.pad(string2, 12) + " " + this.pad(string3, 8) + " " + this.getComment(string2);
    }

    private String pad(String string, int n) {
        String string2 = "                                                       ";
        int n2 = string.length();
        if (n2 == n) {
            return string;
        }
        if (n2 < n) {
            return string + string2.substring(0, n - n2);
        }
        return string.substring(n);
    }

    public void parseArgs(String[] stringArray) throws BadArguments {
        try {
            int n;
            int n2;
            block6: for (n2 = 0; n2 < stringArray.length; ++n2) {
                Boolean bl;
                String string;
                if (stringArray[n2] == "-" || stringArray[n2] == "--") {
                    ++n2;
                    break;
                }
                if (stringArray[n2].charAt(0) != '-') break;
                if (stringArray[n2].charAt(1) == '-') {
                    string = stringArray[n2].substring(2);
                    try {
                        bl = (Boolean)this.longToIsFlagMap.get(string);
                        if (!bl.booleanValue()) {
                            this.longToOptionsMap.put(string, stringArray[++n2]);
                            continue;
                        }
                        this.longToOptionsMap.put(string, "FLAG");
                        continue;
                    }
                    catch (Exception exception) {
                        String string2 = this.isLegalOption(string) ? "The " + string + " option needs a different number of arguments than you provided." : "There is no long option called \"" + string + "\".";
                        throw new BadArguments(string2);
                    }
                }
                for (n = 1; n < stringArray[n2].length(); ++n) {
                    String string3 = stringArray[n2].substring(n, n + 1);
                    try {
                        string = this.shortToLongMap.get(string3).toString();
                        bl = (Boolean)this.longToIsFlagMap.get(string);
                    }
                    catch (Exception exception) {
                        throw new BadArguments("There is no short option called \"" + string3 + "\".");
                    }
                    if (bl == null) {
                        throw new BadArguments("There is no short option called \"" + string3 + "\".");
                    }
                    if (!bl.booleanValue()) {
                        if (n == stringArray[n2].length() - 1) {
                            this.longToOptionsMap.put(string, stringArray[++n2]);
                            continue block6;
                        }
                        this.longToOptionsMap.put(string, stringArray[n2].substring(n + 1));
                        continue block6;
                    }
                    this.longToOptionsMap.put(string, bl.toString());
                }
            }
            this.params = new String[stringArray.length - n2];
            n = 0;
            while (n2 < stringArray.length) {
                this.params[n] = stringArray[n2];
                ++n2;
                ++n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new BadArguments("The last option you specified requires a value and you did not provide one.");
        }
    }

    public String[] getParams() {
        if (this.pVector != null) {
            this.params = new String[this.pVector.size()];
            this.pVector.copyInto(this.params);
            this.pVector = null;
        }
        return this.params;
    }

    public String getParam(int n) {
        if (this.pVector != null) {
            this.params = new String[this.pVector.size()];
            this.pVector.copyInto(this.params);
            this.pVector = null;
        }
        return this.params[n];
    }

    public int numParams() {
        if (this.pVector == null) {
            return this.params.length;
        }
        return this.pVector.size();
    }

    public void addParam(String string) {
        if (this.pVector == null) {
            int n = this.params.length > 0 ? this.params.length : 5;
            this.pVector = new Vector(n, 5);
            for (int i = 1; i < this.params.length; ++i) {
                this.pVector.addElement(this.params[i]);
            }
        }
        this.pVector.addElement(string);
    }

    public static class BadArguments
    extends Exception {
        public BadArguments() {
        }

        public BadArguments(String string) {
            super(string);
        }
    }
}

