/*
 * Decompiled with CFR 0.152.
 */
package jas.util.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public class ShadowBorder
extends AbstractBorder {
    public final int NORTHEAST = 1;
    public final int NORTHWEST = 2;
    public final int SOUTHEAST = 3;
    public final int SOUTHWEST = 4;
    private int size;
    private Color color;
    private int orientation;
    private static ShadowBorder defaultInstance = new ShadowBorder();

    public ShadowBorder() {
        this(null, 0, 5);
    }

    public ShadowBorder(Color color, int n, int n2) {
        this.color = color;
        this.orientation = n;
        this.size = n2;
    }

    public static ShadowBorder createShadowBorder() {
        return defaultInstance;
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(this.color == null ? component.getBackground().darker() : this.color);
        switch (this.orientation) {
            case 2: {
                graphics.fillRect(n, n2, n3 - this.size, this.size);
                graphics.fillRect(n, n2, this.size, n4 - this.size);
            }
            case 1: {
                graphics.fillRect(n + this.size, n2, n3 - this.size, this.size);
                graphics.fillRect(n + n3 - this.size, n2, this.size, n4 - this.size);
            }
            case 4: {
                graphics.fillRect(n, n2 + n4 - this.size, n3 - this.size, this.size);
                graphics.fillRect(n, n2 + this.size, this.size, n4 - this.size);
            }
        }
        graphics.fillRect(n + this.size, n2 + n4 - this.size, n3 - this.size, this.size);
        graphics.fillRect(n + n3 - this.size, n2 + this.size, this.size, n4 - this.size);
    }

    public Insets getBorderInsets(Component component) {
        return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
    }

    public Insets getBorderInsets(Component component, Insets insets) {
        switch (this.orientation) {
            case 2: {
                insets.left = this.size;
                insets.right = 0;
                insets.top = this.size;
                insets.bottom = 0;
                break;
            }
            case 1: {
                insets.left = 0;
                insets.right = this.size;
                insets.top = this.size;
                insets.bottom = 0;
                break;
            }
            case 4: {
                insets.left = this.size;
                insets.right = 0;
                insets.top = 0;
                insets.bottom = this.size;
                break;
            }
            default: {
                insets.left = 0;
                insets.right = this.size;
                insets.top = 0;
                insets.bottom = this.size;
            }
        }
        return insets;
    }
}

