/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.ComponentNodeTraverser;
import jas.hist.JASHist;
import jas.hist.XMLPrintWriter;
import jas.plot.Legend;
import jas.util.xml.XMLNodeTraverser;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class LegendNodeTraverser
extends ComponentNodeTraverser {
    private Node node;
    private Legend legend;
    private JASHist plot;

    LegendNodeTraverser() {
    }

    void traverse(Node node, Legend legend, JASHist jASHist) throws XMLNodeTraverser.BadXMLException {
        this.plot = jASHist;
        this.legend = legend;
        this.node = node;
    }

    protected void handleElement(Element element, String string) throws XMLNodeTraverser.BadXMLException {
        if (string.equals("legendEntry")) {
            int n = this.toInt(element.getAttribute("index"));
            this.legend.setCurrentTitle(n, element.getAttribute("title"));
        } else {
            super.handleElement(element, string);
        }
    }

    protected void handleAttributeNode(Attr attr, String string, String string2) throws XMLNodeTraverser.BadXMLException {
        if (string.equals("visible")) {
            this.plot.setShowLegend(this.toVisibility(string2));
        } else {
            super.handleAttributeNode(attr, string, string2);
        }
    }

    void applyLegendEntries() throws XMLNodeTraverser.BadXMLException {
        if (this.node != null) {
            super.traverse(this.node, this.legend);
        }
    }

    private int toVisibility(String string) throws XMLNodeTraverser.BadXMLException {
        return XMLPrintWriter.convertStringToLegend(string);
    }
}

