/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.math.minuit;

import org.freehep.math.minuit.MnCross;
import org.freehep.math.minuit.MnPrint;
import org.freehep.math.minuit.MnUserParameterState;
import org.freehep.math.minuit.Point;

public class MinosError {
    private int theParameter;
    private double theMinValue;
    private MnCross theUpper;
    private MnCross theLower;

    MinosError() {
        this.theUpper = new MnCross();
        this.theLower = new MnCross();
    }

    MinosError(int par, double min, MnCross low, MnCross up) {
        this.theParameter = par;
        this.theMinValue = min;
        this.theUpper = up;
        this.theLower = low;
    }

    public Point range() {
        return new Point(this.lower(), this.upper());
    }

    public double lower() {
        return -1.0 * this.lowerState().error(this.parameter()) * (1.0 + this.theLower.value());
    }

    public double upper() {
        return this.upperState().error(this.parameter()) * (1.0 + this.theUpper.value());
    }

    public int parameter() {
        return this.theParameter;
    }

    public MnUserParameterState lowerState() {
        return this.theLower.state();
    }

    public MnUserParameterState upperState() {
        return this.theUpper.state();
    }

    public boolean isValid() {
        return this.theLower.isValid() && this.theUpper.isValid();
    }

    public boolean lowerValid() {
        return this.theLower.isValid();
    }

    public boolean upperValid() {
        return this.theUpper.isValid();
    }

    public boolean atLowerLimit() {
        return this.theLower.atLimit();
    }

    public boolean atUpperLimit() {
        return this.theUpper.atLimit();
    }

    public boolean atLowerMaxFcn() {
        return this.theLower.atMaxFcn();
    }

    public boolean atUpperMaxFcn() {
        return this.theUpper.atMaxFcn();
    }

    public boolean lowerNewMin() {
        return this.theLower.newMinimum();
    }

    public boolean upperNewMin() {
        return this.theUpper.newMinimum();
    }

    public int nfcn() {
        return this.theUpper.nfcn() + this.theLower.nfcn();
    }

    public double min() {
        return this.theMinValue;
    }

    public String toString() {
        return MnPrint.toString(this);
    }
}

