/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.math.minuit;

import org.freehep.math.minuit.FunctionGradient;
import org.freehep.math.minuit.GradientCalculator;
import org.freehep.math.minuit.MinimumError;
import org.freehep.math.minuit.MinimumParameters;
import org.freehep.math.minuit.MinimumState;
import org.freehep.math.minuit.MnAlgebraicSymMatrix;
import org.freehep.math.minuit.MnAlgebraicVector;
import org.freehep.math.minuit.MnFcn;
import org.freehep.math.minuit.MnLineSearch;
import org.freehep.math.minuit.MnMachinePrecision;
import org.freehep.math.minuit.MnParabolaPoint;
import org.freehep.math.minuit.MnUtils;
import org.freehep.math.minuit.VariableMetricEDMEstimator;

abstract class NegativeG2LineSearch {
    NegativeG2LineSearch() {
    }

    static MinimumState search(MnFcn fcn, MinimumState st, GradientCalculator gc, MnMachinePrecision prec) {
        boolean negG2 = NegativeG2LineSearch.hasNegativeG2(st.gradient(), prec);
        if (!negG2) {
            return st;
        }
        int n = st.parameters().vec().size();
        FunctionGradient dgrad = st.gradient();
        MinimumParameters pa = st.parameters();
        boolean iterate = false;
        int iter = 0;
        block0: do {
            iterate = false;
            for (int i = 0; i < n; ++i) {
                if (!(dgrad.g2().get(i) < prec.eps2())) continue;
                MnAlgebraicVector step = new MnAlgebraicVector(n);
                step.set(i, dgrad.gstep().get(i) * dgrad.vec().get(i));
                if (Math.abs(dgrad.vec().get(i)) > prec.eps2()) {
                    step.set(i, step.get(i) * (-1.0 / Math.abs(dgrad.vec().get(i))));
                }
                double gdel = step.get(i) * dgrad.vec().get(i);
                MnParabolaPoint pp = MnLineSearch.search(fcn, pa, step, gdel, prec);
                step = MnUtils.mul(step, pp.x());
                pa = new MinimumParameters(MnUtils.add(pa.vec(), step), pp.y());
                dgrad = gc.gradient(pa, dgrad);
                iterate = true;
                continue block0;
            }
        } while (iter++ < 2 * n && iterate);
        MnAlgebraicSymMatrix mat = new MnAlgebraicSymMatrix(n);
        for (int i = 0; i < n; ++i) {
            mat.set(i, i, Math.abs(dgrad.g2().get(i)) > prec.eps2() ? 1.0 / dgrad.g2().get(i) : 1.0);
        }
        MinimumError err = new MinimumError(mat, 1.0);
        double edm = new VariableMetricEDMEstimator().estimate(dgrad, err);
        return new MinimumState(pa, err, dgrad, edm, fcn.numOfCalls());
    }

    static boolean hasNegativeG2(FunctionGradient grad, MnMachinePrecision prec) {
        for (int i = 0; i < grad.vec().size(); ++i) {
            if (!(grad.g2().get(i) < prec.eps2())) continue;
            return true;
        }
        return false;
    }
}

