/*
 * Decompiled with CFR 0.152.
 */
package hep.aida;

import hep.aida.IDataPointSetFactory;
import hep.aida.IFitFactory;
import hep.aida.IFunctionFactory;
import hep.aida.IHistogramFactory;
import hep.aida.IPlotterFactory;
import hep.aida.ITree;
import hep.aida.ITreeFactory;
import hep.aida.ITupleFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public abstract class IAnalysisFactory {
    static /* synthetic */ Class class$hep$aida$IAnalysisFactory;

    public static IAnalysisFactory create() {
        Throwable detail;
        String msg;
        block10: {
            msg = null;
            detail = null;
            try {
                String factory = IAnalysisFactory.findFactory("hep.aida.IAnalysisFactory");
                if (factory == null) {
                    msg = "No concrete IAnalysisFactory could be located";
                    break block10;
                }
                try {
                    Class<?> factoryClass = Class.forName(factory);
                    return (IAnalysisFactory)factoryClass.newInstance();
                }
                catch (ClassCastException x) {
                    detail = x;
                    msg = "Class " + factory + " is not an IAnalysis Factory";
                }
                catch (ClassNotFoundException x) {
                    detail = x;
                    msg = "Class " + factory + " not found";
                }
                catch (IllegalAccessException x) {
                    detail = x;
                    msg = "Class " + factory + " does not have a zero-argument constructor";
                }
                catch (InstantiationException x) {
                    detail = x;
                    msg = "Error while instantiating " + factory;
                }
                catch (NoClassDefFoundError x) {
                    detail = x;
                    msg = "You may have an old version of aida or freehep in your JDK_HOME/jre/lib/ext directory";
                }
                catch (Throwable x) {
                    detail = x;
                    msg = "Unknown Error";
                }
            }
            catch (IOException x) {
                detail = x;
                msg = "IOException while searching for IAnalysisFactory service";
            }
        }
        System.err.println(detail);
        System.err.println("Error: Unable to create IAnalysisFactory");
        System.err.println("Error: " + msg);
        System.err.println("Error: Please check your CLASSPATH and see the AIDA Users Guide");
        System.err.println("===============================================================");
        RuntimeException x = new RuntimeException(msg);
        throw x;
    }

    private static String findFactory(String factoryName) throws IOException {
        String factory = null;
        try {
            factory = System.getProperty(factoryName);
            if (factory != null) {
                return factory;
            }
        }
        catch (SecurityException securityexception) {
            // empty catch block
        }
        String service1 = "meta-inf/services/" + factoryName;
        String service2 = "META-INF/services/" + factoryName;
        ClassLoader loader = (class$hep$aida$IAnalysisFactory == null ? (class$hep$aida$IAnalysisFactory = IAnalysisFactory.class$("hep.aida.IAnalysisFactory")) : class$hep$aida$IAnalysisFactory).getClassLoader();
        InputStream stream = null;
        stream = loader == null ? ClassLoader.getSystemResourceAsStream(service1) : loader.getResourceAsStream(service1);
        if (stream == null) {
            stream = loader == null ? ClassLoader.getSystemResourceAsStream(service2) : loader.getResourceAsStream(service2);
        }
        if (stream != null) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            factory = reader.readLine();
            reader.close();
            if (factory != null && !factory.equals("")) {
                return factory;
            }
        }
        return null;
    }

    public abstract ITreeFactory createTreeFactory();

    public abstract IHistogramFactory createHistogramFactory(ITree var1) throws IllegalArgumentException;

    public abstract IDataPointSetFactory createDataPointSetFactory(ITree var1) throws IllegalArgumentException;

    public abstract ITupleFactory createTupleFactory(ITree var1) throws IllegalArgumentException;

    public abstract IFunctionFactory createFunctionFactory(ITree var1) throws IllegalArgumentException;

    public abstract IPlotterFactory createPlotterFactory();

    public abstract IFitFactory createFitFactory();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

