/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref;

import hep.aida.IAnnotation;
import hep.aida.ref.ReadOnlyException;
import java.util.Vector;

public class Annotation
implements IAnnotation {
    protected Vector keyVector = new Vector();
    protected Vector valVector = new Vector();
    protected Vector stkVector = new Vector();
    protected boolean fillable = true;
    public static String titleKey = "Title";

    public Annotation() {
        this.addItem(titleKey, "", true);
    }

    public void setFillable(boolean fillable) {
        this.fillable = fillable;
    }

    public void addItem(String key, String value) {
        if (!this.fillable) {
            throw new ReadOnlyException();
        }
        this.addItem(key, value, false);
    }

    public void addItem(String key, String value, boolean sticky) {
        if (!this.fillable) {
            throw new ReadOnlyException();
        }
        if (this.keyVector.contains(key)) {
            this.setValue(key, value);
            this.setSticky(key, sticky);
        } else {
            this.keyVector.add(key);
            this.valVector.add(value);
            this.stkVector.add(new Boolean(sticky));
        }
    }

    public void removeItem(String key) {
        if (!this.fillable) {
            throw new ReadOnlyException();
        }
        if (!this.keyVector.contains(key)) {
            throw new IllegalArgumentException("Item " + key + " does not exist");
        }
        int index = this.keyVector.indexOf(key);
        if (this.isSticky(index)) {
            throw new IllegalArgumentException("Item " + key + " is sticky; it cannot be removed");
        }
        this.keyVector.remove(index);
        this.valVector.remove(index);
        this.stkVector.remove(index);
    }

    public String value(String key) {
        if (!this.keyVector.contains(key)) {
            throw new IllegalArgumentException("Item " + key + " does not exist");
        }
        int index = this.keyVector.indexOf(key);
        return (String)this.valVector.get(index);
    }

    public void setValue(String key, String value) {
        if (!this.fillable) {
            throw new ReadOnlyException();
        }
        if (!this.keyVector.contains(key)) {
            throw new IllegalArgumentException("Item " + key + " does not exist");
        }
        int index = this.keyVector.indexOf(key);
        this.valVector.set(index, value);
    }

    public boolean isSticky(String key) {
        if (!this.keyVector.contains(key)) {
            throw new IllegalArgumentException("Item " + key + " does not exist");
        }
        int index = this.keyVector.indexOf(key);
        return (Boolean)this.stkVector.get(index);
    }

    public void setSticky(String key, boolean sticky) {
        if (!this.fillable) {
            throw new ReadOnlyException();
        }
        if (!this.keyVector.contains(key)) {
            throw new IllegalArgumentException("Item " + key + " does not exist");
        }
        int index = this.keyVector.indexOf(key);
        this.stkVector.set(index, new Boolean(sticky));
    }

    public int size() {
        return this.keyVector.size();
    }

    public String key(int index) {
        this.checkIndex(index);
        return (String)this.keyVector.get(index);
    }

    public String value(int index) {
        this.checkIndex(index);
        return (String)this.valVector.get(index);
    }

    public boolean isSticky(int index) {
        this.checkIndex(index);
        return (Boolean)this.stkVector.get(index);
    }

    public void reset() {
        if (!this.fillable) {
            throw new ReadOnlyException();
        }
        Object[] stkVct = this.stkVector.toArray();
        for (int i = stkVct.length - 1; i > -1; --i) {
            if (((Boolean)stkVct[i]).booleanValue()) continue;
            this.keyVector.remove(i);
            this.valVector.remove(i);
            this.stkVector.remove(i);
        }
    }

    protected void checkIndex(int index) {
        if (index + 1 > this.size()) {
            throw new IllegalArgumentException("Index " + index + " exceeds the dimension of the Annotation: " + this.size());
        }
        if (index < 0) {
            throw new IllegalArgumentException("Index " + index + " cannot be negative");
        }
    }
}

