/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.function;

import hep.aida.IAnalysisFactory;
import hep.aida.IBaseHistogram;
import hep.aida.IFunction;
import hep.aida.IFunctionFactory;
import hep.aida.IHistogram1D;
import hep.aida.IHistogramFactory;
import hep.aida.IModelFunction;
import hep.aida.IPlotter;
import hep.aida.IPlotterFactory;
import hep.aida.ITree;
import hep.aida.ref.function.BaseModelFunction;
import hep.aida.ref.function.JELFunctionCore;
import java.util.StringTokenizer;

public class JELBaseModelFunction
extends BaseModelFunction {
    private JELBaseModelFunction() {
    }

    public JELBaseModelFunction(String treeName, int dim, String valexpr, String parameters, String description, String gradexpr) {
        this.setName(treeName);
        JELFunctionCore f = this.createJELFunctionCore(dim, valexpr, parameters, gradexpr);
        this.init(description, f, f);
    }

    public JELFunctionCore createJELFunctionCore(int dim, String valexpr, String parameters, String gradexpr) {
        JELFunctionCore core = null;
        String[] parNames = null;
        int nPar = 0;
        if (parameters != null && !parameters.equals("")) {
            StringTokenizer st = new StringTokenizer(parameters, ",;");
            nPar = st.countTokens();
            if (nPar > 0) {
                parNames = new String[nPar];
            }
            int i = 0;
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                this.checkParameterName(token);
                parNames[i] = token;
                ++i;
            }
        }
        String[] gr = null;
        int nGr = 0;
        if (gradexpr != null && !gradexpr.equals("") && !gradexpr.trim().toLowerCase().equals("null")) {
            StringTokenizer st = new StringTokenizer(gradexpr, ",;");
            nGr = st.countTokens();
            if (nGr != dim) {
                throw new IllegalArgumentException("Dimension of the gradient (" + nGr + ") is not equal to the dimension of the function (" + dim + ")");
            }
            gr = new String[dim];
            int i = 0;
            while (st.hasMoreTokens()) {
                String token;
                gr[i] = token = st.nextToken().trim();
                ++i;
            }
        }
        core = new JELFunctionCore(dim, nPar, valexpr, parNames, gr);
        return core;
    }

    private void checkParameterName(String token) {
        if (token.startsWith("x") || token.startsWith("X")) {
            String tmp = token.substring(1);
            try {
                int i = Integer.parseInt(tmp);
            }
            catch (NumberFormatException e) {
                return;
            }
            String mess = "Illegal parameter name: \"" + token + "\".\nNames like x0, x1, x2, ..., are reserved. Please rename this parameter..";
            throw new IllegalArgumentException(mess);
        }
    }

    public static void main(String[] args) {
        IAnalysisFactory af = IAnalysisFactory.create();
        ITree tree = af.createTreeFactory().create();
        IHistogramFactory hf = af.createHistogramFactory(tree);
        IFunctionFactory ff = af.createFunctionFactory(tree);
        IPlotterFactory pf = af.createPlotterFactory();
        IPlotter plotter = pf.create("Function Plotter");
        IHistogram1D hist1 = hf.createHistogram1D("hist1", "hist1", 100, -5.0, 5.0);
        IModelFunction f1 = (IModelFunction)ff.createFunctionFromScript("My Test Function", 1, "a*x[0]+b", "a, b", "linear");
        plotter.createRegions(1, 1);
        plotter.region(0).plot((IBaseHistogram)hist1);
        plotter.region(0).plot((IFunction)f1);
        plotter.show();
    }
}

