/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.hbook;

import hep.aida.ITuple;
import hep.aida.ref.hbook.HBookRowwiseTupleColumn;
import hep.aida.ref.tuple.AbstractTuple;
import hep.io.hbook.RowwiseTuple;
import hep.io.hbook.RowwiseTupleColumn;
import hep.tuple.Cursor;
import hep.tuple.interfaces.FTuple;
import hep.tuple.interfaces.FTupleColumn;
import hep.tuple.interfaces.FTupleCursor;
import org.freehep.util.Value;

class HBookRowwiseTuple
extends AbstractTuple
implements FTuple {
    private RowwiseTuple tuple;
    private Cursor cursor;
    private HBookRowwiseTupleColumn[] columns;

    HBookRowwiseTuple(RowwiseTuple tuple) {
        super(String.valueOf(tuple.id()));
        this.setTitle(tuple.getName());
        this.tuple = tuple;
        int nCols = tuple.nChildren();
        this.columns = new HBookRowwiseTupleColumn[nCols];
        for (int i = 0; i < nCols; ++i) {
            this.columns[i] = new HBookRowwiseTupleColumn((RowwiseTupleColumn)tuple.getChild(i), tuple);
        }
        this.cursor = new Cursor(0, this.rows(), this.supportsRandomAccess());
    }

    public double columnMax(int column) throws IllegalArgumentException {
        RowwiseTupleColumn child = (RowwiseTupleColumn)this.tuple.getChild(column);
        return child.getMax();
    }

    public double columnMean(int column) throws IllegalArgumentException {
        return Double.NaN;
    }

    public double columnMin(int column) throws IllegalArgumentException {
        RowwiseTupleColumn child = (RowwiseTupleColumn)this.tuple.getChild(column);
        return child.getMin();
    }

    public String columnName(int column) throws IllegalArgumentException {
        return this.tuple.getChild(column).getName();
    }

    public String[] columnNames() throws IllegalArgumentException {
        String[] names = new String[this.columns.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.columnName(i);
        }
        return names;
    }

    public double columnRms(int column) throws IllegalArgumentException {
        return Double.NaN;
    }

    public Class columnType(int column) throws IllegalArgumentException {
        return Float.TYPE;
    }

    public Class[] columnTypes() throws IllegalArgumentException {
        Class[] types = new Class[this.columns()];
        for (int i = 0; i < types.length; ++i) {
            types[i] = Float.TYPE;
        }
        return types;
    }

    public int columns() {
        return this.tuple.nChildren();
    }

    public int findColumn(String name) throws IllegalArgumentException {
        int index = this.tuple.getIndex(name);
        if (index < 0) {
            throw new IllegalArgumentException("Column " + name + " does not exist");
        }
        return index;
    }

    public boolean getBoolean(int param) throws ClassCastException {
        throw new ClassCastException();
    }

    public byte getByte(int param) throws ClassCastException {
        throw new ClassCastException();
    }

    public char getChar(int param) throws ClassCastException {
        throw new ClassCastException();
    }

    public double getDouble(int column) throws ClassCastException {
        RowwiseTupleColumn child = (RowwiseTupleColumn)this.tuple.getChild(column);
        return child.getDouble();
    }

    public float getFloat(int column) throws ClassCastException {
        RowwiseTupleColumn child = (RowwiseTupleColumn)this.tuple.getChild(column);
        return (float)child.getDouble();
    }

    public int getInt(int param) throws ClassCastException {
        throw new ClassCastException();
    }

    public long getLong(int param) throws ClassCastException {
        throw new ClassCastException();
    }

    public Object getObject(int param) throws ClassCastException {
        throw new ClassCastException();
    }

    public short getShort(int param) throws ClassCastException {
        throw new ClassCastException();
    }

    public String getString(int param) throws ClassCastException {
        throw new ClassCastException();
    }

    public ITuple getTuple(int param) {
        throw new ClassCastException();
    }

    public boolean next() {
        boolean advanced = this.cursor.next();
        if (advanced) {
            this.tuple.setCurrentRow(this.cursor.row() + 1);
        }
        return advanced;
    }

    public int rows() {
        return this.tuple.getRows();
    }

    public void setRow(int row) throws IllegalArgumentException {
        if (row < 0 || row >= this.rows()) {
            throw new IllegalArgumentException("Invalid ntuple row: " + row);
        }
        this.tuple.setCurrentRow(row + 1);
    }

    public void skip(int n) throws IllegalArgumentException {
        this.cursor.skip(n);
        this.tuple.setCurrentRow(this.cursor.row() + 1);
    }

    public void start() {
        this.cursor.start();
    }

    public int columnIndexByName(String name) {
        return this.findColumn(name);
    }

    public FTuple tuple(int index) {
        return (FTuple)this.getTuple(index);
    }

    public boolean supportsRandomAccess() {
        return true;
    }

    public boolean supportsMultipleCursors() {
        return true;
    }

    public FTupleColumn column(int index) {
        return this.columns[index];
    }

    public FTupleColumn columnByName(String name) {
        return this.columns[this.columnIndexByName(name)];
    }

    public void columnValue(int column, FTupleCursor cursor, Value value) {
        this.columns[column].value(cursor, value);
    }

    public FTupleCursor cursor() {
        return new Cursor(0, this.rows(), this.supportsRandomAccess());
    }

    public void close() {
    }

    public boolean isInMemory() {
        return false;
    }
}

