/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.histogram;

import hep.aida.IAxis;
import hep.aida.IBaseHistogram;
import hep.aida.ICloud1D;
import hep.aida.ICloud2D;
import hep.aida.ICloud3D;
import hep.aida.IHistogram1D;
import hep.aida.IHistogram2D;
import hep.aida.IHistogram3D;
import hep.aida.IHistogramFactory;
import hep.aida.IManagedObject;
import hep.aida.IProfile1D;
import hep.aida.IProfile2D;
import hep.aida.ITree;
import hep.aida.ref.AidaUtils;
import hep.aida.ref.histogram.Cloud1D;
import hep.aida.ref.histogram.Cloud2D;
import hep.aida.ref.histogram.Cloud3D;
import hep.aida.ref.histogram.FixedAxis;
import hep.aida.ref.histogram.HistMath;
import hep.aida.ref.histogram.Histogram1D;
import hep.aida.ref.histogram.Histogram2D;
import hep.aida.ref.histogram.Histogram3D;
import hep.aida.ref.histogram.Profile1D;
import hep.aida.ref.histogram.Profile2D;
import hep.aida.ref.histogram.VariableAxis;
import hep.aida.ref.tree.Tree;

public class HistogramFactory
implements IHistogramFactory {
    private Tree tree;
    private static final int defaultMaxEntries = 100000;
    private HistMath histMath;
    private static final char separatorChar = '/';

    private String nameInPath(String path) {
        return AidaUtils.parseName(path);
    }

    private String parentPath(String path) {
        return AidaUtils.parseDirName(path);
    }

    public HistogramFactory(ITree tree) {
        this((Tree)tree);
    }

    public HistogramFactory(Tree tree) {
        this.tree = tree;
        this.histMath = new HistMath();
    }

    public void destroy(IBaseHistogram hist) throws IllegalArgumentException {
        if (this.tree != null) {
            String path = this.tree.findPath((IManagedObject)hist);
            this.tree.rm(path);
        }
    }

    public ICloud1D createCloud1D(String path, String title, int nMax, String options) {
        Cloud1D result = new Cloud1D(this.nameInPath(path), title, nMax, options);
        if (this.tree != null) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public ICloud1D createCloud1D(String path, String title, int nMax) {
        return this.createCloud1D(path, title, nMax, "");
    }

    public ICloud1D createCloud1D(String path, String title) {
        return this.createCloud1D(path, title, 100000);
    }

    public ICloud1D createCloud1D(String pathAndTitle) {
        return this.createCloud1D(pathAndTitle, this.nameInPath(pathAndTitle));
    }

    public ICloud1D createCopy(String path, ICloud1D cloud) {
        Cloud1D oldCloud = (Cloud1D)cloud;
        Cloud1D newCloud = new Cloud1D(this.nameInPath(path), oldCloud.title(), oldCloud.maxEntries(), oldCloud.getOptions());
        if (oldCloud.isConverted()) {
            newCloud.setHistogram(this.copy(this.nameInPath(path), oldCloud.histogram()));
        } else {
            for (int i = 0; i < oldCloud.entries(); ++i) {
                newCloud.fill(oldCloud.value(i), oldCloud.weight(i));
            }
        }
        newCloud.setLowerEdge(oldCloud.lowerEdge());
        newCloud.setUpperEdge(oldCloud.upperEdge());
        if (this.tree != null) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)newCloud);
        }
        return newCloud;
    }

    public ICloud2D createCloud2D(String path, String title, int nMax, String options) {
        Cloud2D result = new Cloud2D(this.nameInPath(path), title, nMax, options);
        if (this.tree != null) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public ICloud2D createCloud2D(String path, String title, int nMax) {
        return this.createCloud2D(path, title, nMax, "");
    }

    public ICloud2D createCloud2D(String path, String title) {
        return this.createCloud2D(path, title, 100000);
    }

    public ICloud2D createCloud2D(String pathAndTitle) {
        return this.createCloud2D(pathAndTitle, this.nameInPath(pathAndTitle));
    }

    public ICloud2D createCopy(String path, ICloud2D cloud) {
        Cloud2D oldCloud = (Cloud2D)cloud;
        Cloud2D newCloud = new Cloud2D(this.nameInPath(path), oldCloud.title(), oldCloud.maxEntries(), oldCloud.getOptions());
        if (oldCloud.isConverted()) {
            newCloud.setHistogram(this.copy(this.nameInPath(path), oldCloud.histogram()));
        } else {
            for (int i = 0; i < oldCloud.entries(); ++i) {
                newCloud.fill(oldCloud.valueX(i), oldCloud.valueY(i), oldCloud.weight(i));
            }
        }
        newCloud.setLowerEdgeX(oldCloud.lowerEdgeX());
        newCloud.setUpperEdgeX(oldCloud.upperEdgeX());
        newCloud.setLowerEdgeY(oldCloud.lowerEdgeY());
        newCloud.setUpperEdgeY(oldCloud.upperEdgeY());
        if (this.tree != null) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)newCloud);
        }
        return newCloud;
    }

    public ICloud3D createCloud3D(String path, String title, int nMax, String options) {
        Cloud3D result = new Cloud3D(this.nameInPath(path), title, nMax, options);
        if (this.tree != null) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public ICloud3D createCloud3D(String path, String title, int nMax) {
        return this.createCloud3D(path, title, nMax, "");
    }

    public ICloud3D createCloud3D(String path, String title) {
        return this.createCloud3D(path, title, 100000);
    }

    public ICloud3D createCloud3D(String pathAndTitle) {
        return this.createCloud3D(pathAndTitle, this.nameInPath(pathAndTitle));
    }

    public ICloud3D createCopy(String path, ICloud3D cloud) {
        Cloud3D oldCloud = (Cloud3D)cloud;
        Cloud3D newCloud = new Cloud3D(this.nameInPath(path), oldCloud.title(), oldCloud.maxEntries(), oldCloud.getOptions());
        if (oldCloud.isConverted()) {
            newCloud.setHistogram(this.copy(this.nameInPath(path), oldCloud.histogram()));
        } else {
            for (int i = 0; i < oldCloud.entries(); ++i) {
                newCloud.fill(oldCloud.valueX(i), oldCloud.valueY(i), oldCloud.valueZ(i), oldCloud.weight(i));
            }
        }
        newCloud.setLowerEdgeX(oldCloud.lowerEdgeX());
        newCloud.setUpperEdgeX(oldCloud.upperEdgeX());
        newCloud.setLowerEdgeY(oldCloud.lowerEdgeY());
        newCloud.setUpperEdgeY(oldCloud.upperEdgeY());
        newCloud.setLowerEdgeZ(oldCloud.lowerEdgeZ());
        newCloud.setUpperEdgeZ(oldCloud.upperEdgeZ());
        if (this.tree != null) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)newCloud);
        }
        return newCloud;
    }

    private IAxis copy(IAxis axis) {
        if (axis instanceof FixedAxis) {
            return new FixedAxis(axis.bins(), axis.lowerEdge(), axis.upperEdge());
        }
        double[] edges = new double[axis.bins() + 1];
        edges[0] = axis.binLowerEdge(0);
        for (int i = 0; i < axis.bins(); ++i) {
            edges[i + 1] = axis.binUpperEdge(i);
        }
        return new VariableAxis(edges);
    }

    public IHistogram1D createHistogram1D(String path, String title, int nBins, double lowerEdge, double upperEdge, String options) {
        FixedAxis axis = new FixedAxis(nBins, lowerEdge, upperEdge);
        Histogram1D result = new Histogram1D(this.nameInPath(path), title, axis, options);
        if (this.tree != null) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram1D createHistogram1D(String path, String title, int nBins, double lowerEdge, double upperEdge) {
        return this.createHistogram1D(path, title, nBins, lowerEdge, upperEdge, "");
    }

    public IHistogram1D createHistogram1D(String pathAndTitle, int nBins, double lowerEdge, double upperEdge) {
        return this.createHistogram1D(pathAndTitle, this.nameInPath(pathAndTitle), nBins, lowerEdge, upperEdge);
    }

    public IHistogram1D createHistogram1D(String path, String title, double[] binEdges, String options) {
        VariableAxis axis = new VariableAxis(binEdges);
        Histogram1D result = new Histogram1D(this.nameInPath(path), title, axis, options);
        if (this.tree != null) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram1D createHistogram1D(String path, String title, double[] binEdges) {
        return this.createHistogram1D(path, title, binEdges, "");
    }

    public IHistogram1D createCopy(String path, IHistogram1D hist) {
        Histogram1D newHist = this.copy(this.nameInPath(path), hist);
        if (this.tree != null) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)newHist);
        }
        return newHist;
    }

    private Histogram1D copy(String name, IHistogram1D hist) {
        Histogram1D oldHist = (Histogram1D)hist;
        IAxis axis = oldHist.axis();
        Histogram1D newHist = new Histogram1D(name, oldHist.title(), this.copy(axis), oldHist.options());
        int bins = axis.bins() + 2;
        double[] heights = new double[bins];
        double[] errors = new double[bins];
        double[] means = new double[bins];
        double[] rmss = new double[bins];
        int[] entries = new int[bins];
        for (int i = -2; i < bins - 2; ++i) {
            int bin = oldHist.mapBinNumber(i, axis);
            heights[bin] = oldHist.binHeight(i);
            errors[bin] = oldHist.binError(i);
            entries[bin] = oldHist.binEntries(i);
            means[bin] = oldHist.binMean(i);
            rmss[bin] = oldHist.binRms(i);
        }
        newHist.setContents(heights, errors, entries, means, rmss);
        newHist.setMean(oldHist.mean());
        newHist.setRms(oldHist.rms());
        newHist.setNEntries(oldHist.allEntries());
        newHist.setFillable(oldHist.isFillable());
        return newHist;
    }

    public IHistogram2D createHistogram2D(String path, String title, int nBinsX, double lowerEdgeX, double upperEdgeX, int nBinsY, double lowerEdgeY, double upperEdgeY, String options) {
        FixedAxis xAxis = new FixedAxis(nBinsX, lowerEdgeX, upperEdgeX);
        FixedAxis yAxis = new FixedAxis(nBinsY, lowerEdgeY, upperEdgeY);
        Histogram2D result = new Histogram2D(this.nameInPath(path), title, xAxis, yAxis, options);
        if (this.tree != null) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram2D createHistogram2D(String path, String title, int nBinsX, double lowerEdgeX, double upperEdgeX, int nBinsY, double lowerEdgeY, double upperEdgeY) {
        return this.createHistogram2D(path, title, nBinsX, lowerEdgeX, upperEdgeX, nBinsY, lowerEdgeY, upperEdgeY, "");
    }

    public IHistogram2D createHistogram2D(String pathAndTitle, int nBinsX, double lowerEdgeX, double upperEdgeX, int nBinsY, double lowerEdgeY, double upperEdgeY) {
        return this.createHistogram2D(pathAndTitle, this.nameInPath(pathAndTitle), nBinsX, lowerEdgeX, upperEdgeX, nBinsY, lowerEdgeY, upperEdgeY);
    }

    public IHistogram2D createHistogram2D(String path, String title, double[] binEdgesX, double[] binEdgesY, String options) {
        VariableAxis xAxis = new VariableAxis(binEdgesX);
        VariableAxis yAxis = new VariableAxis(binEdgesY);
        Histogram2D result = new Histogram2D(this.nameInPath(path), title, xAxis, yAxis, options);
        if (this.tree != null) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram2D createHistogram2D(String path, String title, double[] binEdgesX, double[] binEdgesY) {
        return this.createHistogram2D(path, title, binEdgesX, binEdgesY, "");
    }

    public IHistogram2D createCopy(String path, IHistogram2D hist) {
        Histogram2D newHist = this.copy(this.nameInPath(path), hist);
        if (this.tree != null) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)newHist);
        }
        return newHist;
    }

    private Histogram2D copy(String name, IHistogram2D hist) {
        Histogram2D oldHist = (Histogram2D)hist;
        IAxis xAxis = oldHist.xAxis();
        IAxis yAxis = oldHist.yAxis();
        Histogram2D newHist = new Histogram2D(name, oldHist.title(), this.copy(xAxis), this.copy(yAxis), oldHist.options());
        int xBins = xAxis.bins() + 2;
        int yBins = yAxis.bins() + 2;
        double[][] heights = new double[xBins][yBins];
        double[][] errors = new double[xBins][yBins];
        double[][] meanXs = new double[xBins][yBins];
        double[][] rmsXs = new double[xBins][yBins];
        double[][] meanYs = new double[xBins][yBins];
        double[][] rmsYs = new double[xBins][yBins];
        int[][] entries = new int[xBins][yBins];
        for (int i = -2; i < xBins - 2; ++i) {
            for (int j = -2; j < yBins - 2; ++j) {
                int xbin = oldHist.mapBinNumber(i, xAxis);
                int ybin = oldHist.mapBinNumber(j, yAxis);
                heights[xbin][ybin] = oldHist.binHeight(i, j);
                errors[xbin][ybin] = oldHist.binError(i, j);
                entries[xbin][ybin] = oldHist.binEntries(i, j);
                meanXs[xbin][ybin] = oldHist.binMeanX(i, j);
                rmsXs[xbin][ybin] = oldHist.binRmsX(i, j);
                meanYs[xbin][ybin] = oldHist.binMeanY(i, j);
                rmsYs[xbin][ybin] = oldHist.binRmsY(i, j);
            }
        }
        newHist.setContents(heights, errors, entries, meanXs, rmsXs, meanYs, rmsYs);
        newHist.setMeanX(oldHist.meanX());
        newHist.setRmsX(oldHist.rmsX());
        newHist.setMeanY(oldHist.meanY());
        newHist.setRmsY(oldHist.rmsY());
        newHist.setNEntries(oldHist.allEntries());
        newHist.setFillable(oldHist.isFillable());
        return newHist;
    }

    public IHistogram3D createHistogram3D(String path, String title, int nBinsX, double lowerEdgeX, double upperEdgeX, int nBinsY, double lowerEdgeY, double upperEdgeY, int nBinsZ, double lowerEdgeZ, double upperEdgeZ, String options) {
        FixedAxis xAxis = new FixedAxis(nBinsX, lowerEdgeX, upperEdgeX);
        FixedAxis yAxis = new FixedAxis(nBinsY, lowerEdgeY, upperEdgeY);
        FixedAxis zAxis = new FixedAxis(nBinsZ, lowerEdgeZ, upperEdgeZ);
        Histogram3D result = new Histogram3D(this.nameInPath(path), title, xAxis, yAxis, zAxis, options);
        if (this.tree != null) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram3D createHistogram3D(String path, String title, int nBinsX, double lowerEdgeX, double upperEdgeX, int nBinsY, double lowerEdgeY, double upperEdgeY, int nBinsZ, double lowerEdgeZ, double upperEdgeZ) {
        return this.createHistogram3D(path, title, nBinsX, lowerEdgeX, upperEdgeX, nBinsY, lowerEdgeY, upperEdgeY, nBinsZ, lowerEdgeZ, upperEdgeZ, "");
    }

    public IHistogram3D createHistogram3D(String pathAndTitle, int nBinsX, double lowerEdgeX, double upperEdgeX, int nBinsY, double lowerEdgeY, double upperEdgeY, int nBinsZ, double lowerEdgeZ, double upperEdgeZ) {
        return this.createHistogram3D(pathAndTitle, this.nameInPath(pathAndTitle), nBinsX, lowerEdgeX, upperEdgeX, nBinsY, lowerEdgeY, upperEdgeY, nBinsZ, lowerEdgeZ, upperEdgeZ, "");
    }

    public IHistogram3D createHistogram3D(String path, String title, double[] binEdgesX, double[] binEdgesY, double[] binEdgesZ, String options) {
        VariableAxis xAxis = new VariableAxis(binEdgesX);
        VariableAxis yAxis = new VariableAxis(binEdgesY);
        VariableAxis zAxis = new VariableAxis(binEdgesZ);
        Histogram3D result = new Histogram3D(this.nameInPath(path), title, xAxis, yAxis, zAxis, options);
        if (this.tree != null) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram3D createHistogram3D(String path, String title, double[] binEdgesX, double[] binEdgesY, double[] binEdgesZ) {
        return this.createHistogram3D(path, title, binEdgesX, binEdgesY, binEdgesZ, "");
    }

    public IHistogram3D createCopy(String path, IHistogram3D hist) {
        Histogram3D newHist = this.copy(this.nameInPath(path), hist);
        if (this.tree != null) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)newHist);
        }
        return newHist;
    }

    private Histogram3D copy(String name, IHistogram3D hist) {
        Histogram3D oldHist = (Histogram3D)hist;
        IAxis xAxis = oldHist.xAxis();
        IAxis yAxis = oldHist.yAxis();
        IAxis zAxis = oldHist.zAxis();
        Histogram3D newHist = new Histogram3D(name, oldHist.title(), this.copy(xAxis), this.copy(yAxis), this.copy(zAxis), oldHist.options());
        int xBins = xAxis.bins() + 2;
        int yBins = yAxis.bins() + 2;
        int zBins = zAxis.bins() + 2;
        double[][][] heights = new double[xBins][yBins][zBins];
        double[][][] errors = new double[xBins][yBins][zBins];
        double[][][] meanXs = new double[xBins][yBins][zBins];
        double[][][] rmsXs = new double[xBins][yBins][zBins];
        double[][][] meanYs = new double[xBins][yBins][zBins];
        double[][][] rmsYs = new double[xBins][yBins][zBins];
        double[][][] meanZs = new double[xBins][yBins][zBins];
        double[][][] rmsZs = new double[xBins][yBins][zBins];
        int[][][] entries = new int[xBins][yBins][zBins];
        for (int i = -2; i < xBins - 2; ++i) {
            for (int j = -2; j < yBins - 2; ++j) {
                for (int k = -2; k < zBins - 2; ++k) {
                    int xbin = oldHist.mapBinNumber(i, xAxis);
                    int ybin = oldHist.mapBinNumber(j, yAxis);
                    int zbin = oldHist.mapBinNumber(k, zAxis);
                    heights[xbin][ybin][zbin] = oldHist.binHeight(i, j, k);
                    errors[xbin][ybin][zbin] = oldHist.binError(i, j, k);
                    entries[xbin][ybin][zbin] = oldHist.binEntries(i, j, k);
                    meanXs[xbin][ybin][zbin] = oldHist.binMeanX(i, j, k);
                    rmsXs[xbin][ybin][zbin] = oldHist.binRmsX(i, j, k);
                    meanYs[xbin][ybin][zbin] = oldHist.binMeanY(i, j, k);
                    rmsYs[xbin][ybin][zbin] = oldHist.binRmsY(i, j, k);
                    meanZs[xbin][ybin][zbin] = oldHist.binMeanZ(i, j, k);
                    rmsZs[xbin][ybin][zbin] = oldHist.binRmsZ(i, j, k);
                }
            }
        }
        newHist.setContents(heights, errors, entries, meanXs, rmsXs, meanYs, rmsYs, meanZs, rmsZs);
        newHist.setMeanX(oldHist.meanX());
        newHist.setRmsX(oldHist.rmsX());
        newHist.setMeanY(oldHist.meanY());
        newHist.setRmsY(oldHist.rmsY());
        newHist.setMeanZ(oldHist.meanZ());
        newHist.setRmsZ(oldHist.rmsZ());
        newHist.setNEntries(oldHist.allEntries());
        newHist.setFillable(oldHist.isFillable());
        return newHist;
    }

    public IProfile1D createProfile1D(String path, String title, int nBins, double lowerEdge, double upperEdge, String options) {
        FixedAxis axis = new FixedAxis(nBins, lowerEdge, upperEdge);
        Profile1D result = new Profile1D(this.nameInPath(path), title, axis, options);
        if (this.tree != null) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IProfile1D createProfile1D(String path, String title, int nBins, double lowerEdge, double upperEdge) {
        return this.createProfile1D(path, title, nBins, lowerEdge, upperEdge, "");
    }

    public IProfile1D createProfile1D(String path, String title, int nBins, double lowerEdge, double upperEdge, double lowerValue, double upperValue, String options) {
        return this.createProfile1D(path, title, nBins, lowerEdge, upperEdge, "");
    }

    public IProfile1D createProfile1D(String path, String title, int nBins, double lowerEdge, double upperEdge, double lowerValue, double upperValue) {
        return this.createProfile1D(path, title, nBins, lowerEdge, upperEdge, "");
    }

    public IProfile1D createProfile1D(String pathAndTitle, int nBins, double lowerEdge, double upperEdge) {
        return this.createProfile1D(pathAndTitle, this.nameInPath(pathAndTitle), nBins, lowerEdge, upperEdge, "");
    }

    public IProfile1D createProfile1D(String pathAndTitle, int nBins, double lowerEdge, double upperEdge, double lowerValue, double upperValue) {
        return this.createProfile1D(pathAndTitle, this.nameInPath(pathAndTitle), nBins, lowerEdge, upperEdge, "");
    }

    public IProfile1D createProfile1D(String path, String title, double[] binEdges, String options) {
        VariableAxis axis = new VariableAxis(binEdges);
        Profile1D result = new Profile1D(this.nameInPath(path), title, axis, options);
        if (this.tree != null) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IProfile1D createProfile1D(String path, String title, double[] binEdges) {
        return this.createProfile1D(path, title, binEdges, "");
    }

    public IProfile1D createProfile1D(String path, String title, double[] binEdges, double lowerValue, double upperValue, String options) {
        return this.createProfile1D(path, title, binEdges, "");
    }

    public IProfile1D createProfile1D(String path, String title, double[] binEdges, double lowerValue, double upperValue) {
        return this.createProfile1D(path, title, binEdges, lowerValue, upperValue, "");
    }

    public IProfile1D createCopy(String path, IProfile1D profile) {
        Profile1D oldProfile = (Profile1D)profile;
        Profile1D newProfile = new Profile1D(this.nameInPath(path), oldProfile.title(), this.copy(oldProfile.axis()), oldProfile.options());
        newProfile.setHistogram(this.copy(this.nameInPath(path), oldProfile.histogram()));
        if (this.tree != null) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)newProfile);
        }
        return newProfile;
    }

    public IProfile2D createProfile2D(String path, String title, int nBinsX, double lowerEdgeX, double upperEdgeX, int nBinsY, double lowerEdgeY, double upperEdgeY, String options) {
        FixedAxis xAxis = new FixedAxis(nBinsX, lowerEdgeX, upperEdgeX);
        FixedAxis yAxis = new FixedAxis(nBinsY, lowerEdgeY, upperEdgeY);
        Profile2D result = new Profile2D(this.nameInPath(path), title, xAxis, yAxis, options);
        if (this.tree != null) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IProfile2D createProfile2D(String path, String title, int nBinsX, double lowerEdgeX, double upperEdgeX, int nBinsY, double lowerEdgeY, double upperEdgeY) {
        return this.createProfile2D(path, title, nBinsX, lowerEdgeX, upperEdgeX, nBinsY, lowerEdgeY, upperEdgeY, "");
    }

    public IProfile2D createProfile2D(String path, String title, int nBinsX, double lowerEdgeX, double upperEdgeX, int nBinsY, double lowerEdgeY, double upperEdgeY, double lowerValue, double upperValue, String options) {
        return this.createProfile2D(path, title, nBinsX, lowerEdgeX, upperEdgeX, nBinsY, lowerEdgeY, upperEdgeY, "");
    }

    public IProfile2D createProfile2D(String path, String title, int nBinsX, double lowerEdgeX, double upperEdgeX, int nBinsY, double lowerEdgeY, double upperEdgeY, double lowerValue, double upperValue) {
        return this.createProfile2D(path, title, nBinsX, lowerEdgeX, upperEdgeX, nBinsY, lowerEdgeY, upperEdgeY, "");
    }

    public IProfile2D createProfile2D(String pathAndTitle, int nBinsX, double lowerEdgeX, double upperEdgeX, int nBinsY, double lowerEdgeY, double upperEdgeY) {
        return this.createProfile2D(pathAndTitle, this.nameInPath(pathAndTitle), nBinsX, lowerEdgeX, upperEdgeX, nBinsY, lowerEdgeY, upperEdgeY, "");
    }

    public IProfile2D createProfile2D(String pathAndTitle, int nBinsX, double lowerEdgeX, double upperEdgeX, int nBinsY, double lowerEdgeY, double upperEdgeY, double lowerValue, double upperValue) {
        return this.createProfile2D(pathAndTitle, this.nameInPath(pathAndTitle), nBinsX, lowerEdgeX, upperEdgeX, nBinsY, lowerEdgeY, upperEdgeY, "");
    }

    public IProfile2D createProfile2D(String path, String title, double[] binEdgesX, double[] binEdgesY, String options) {
        VariableAxis xAxis = new VariableAxis(binEdgesX);
        VariableAxis yAxis = new VariableAxis(binEdgesY);
        Profile2D result = new Profile2D(this.nameInPath(path), title, xAxis, yAxis, options);
        if (this.tree != null) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IProfile2D createProfile2D(String path, String title, double[] binEdgesX, double[] binEdgesY) {
        return this.createProfile2D(path, title, binEdgesX, binEdgesY, "");
    }

    public IProfile2D createProfile2D(String path, String title, double[] binEdgesX, double[] binEdgesY, double lowerValue, double upperValue, String options) {
        return this.createProfile2D(path, title, binEdgesX, binEdgesY, "");
    }

    public IProfile2D createProfile2D(String path, String title, double[] binEdgesX, double[] binEdgesY, double lowerValue, double upperValue) {
        return this.createProfile2D(path, title, binEdgesX, binEdgesY, lowerValue, upperValue, "");
    }

    public IProfile2D createCopy(String path, IProfile2D profile) {
        Profile2D oldProfile = (Profile2D)profile;
        Profile2D newProfile = new Profile2D(this.nameInPath(path), oldProfile.title(), this.copy(oldProfile.xAxis()), this.copy(oldProfile.yAxis()), oldProfile.options());
        newProfile.setHistogram(this.copy(this.nameInPath(path), oldProfile.histogram()));
        if (this.tree != null) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)newProfile);
        }
        return newProfile;
    }

    public IHistogram1D add(String path, IHistogram1D a, IHistogram1D b) throws IllegalArgumentException {
        IHistogram1D result = this.histMath.add(this.nameInPath(path), a, b);
        if (this.tree != null && result instanceof IManagedObject) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram1D subtract(String path, IHistogram1D a, IHistogram1D b) throws IllegalArgumentException {
        IHistogram1D result = this.histMath.sub(this.nameInPath(path), a, b);
        if (this.tree != null && result instanceof IManagedObject) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram1D multiply(String path, IHistogram1D a, IHistogram1D b) throws IllegalArgumentException {
        IHistogram1D result = this.histMath.mul(this.nameInPath(path), a, b);
        if (this.tree != null && result instanceof IManagedObject) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram1D divide(String path, IHistogram1D a, IHistogram1D b) throws IllegalArgumentException {
        IHistogram1D result = this.histMath.div(this.nameInPath(path), a, b);
        if (this.tree != null && result instanceof IManagedObject) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram2D add(String path, IHistogram2D a, IHistogram2D b) throws IllegalArgumentException {
        IHistogram2D result = this.histMath.add(this.nameInPath(path), a, b);
        if (this.tree != null && result instanceof IManagedObject) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram2D subtract(String path, IHistogram2D a, IHistogram2D b) throws IllegalArgumentException {
        IHistogram2D result = this.histMath.sub(this.nameInPath(path), a, b);
        if (this.tree != null && result instanceof IManagedObject) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram2D multiply(String path, IHistogram2D a, IHistogram2D b) throws IllegalArgumentException {
        IHistogram2D result = this.histMath.mul(this.nameInPath(path), a, b);
        if (this.tree != null && result instanceof IManagedObject) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram2D divide(String path, IHistogram2D a, IHistogram2D b) throws IllegalArgumentException {
        IHistogram2D result = this.histMath.div(this.nameInPath(path), a, b);
        if (this.tree != null && result instanceof IManagedObject) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram3D add(String path, IHistogram3D a, IHistogram3D b) throws IllegalArgumentException {
        IHistogram3D result = this.histMath.add(this.nameInPath(path), a, b);
        if (this.tree != null && result instanceof IManagedObject) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram3D subtract(String path, IHistogram3D a, IHistogram3D b) throws IllegalArgumentException {
        IHistogram3D result = this.histMath.sub(this.nameInPath(path), a, b);
        if (this.tree != null && result instanceof IManagedObject) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram3D multiply(String path, IHistogram3D a, IHistogram3D b) throws IllegalArgumentException {
        IHistogram3D result = this.histMath.mul(this.nameInPath(path), a, b);
        if (this.tree != null && result instanceof IManagedObject) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram3D divide(String path, IHistogram3D a, IHistogram3D b) throws IllegalArgumentException {
        IHistogram3D result = this.histMath.div(this.nameInPath(path), a, b);
        if (this.tree != null && result instanceof IManagedObject) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram1D projectionX(String path, IHistogram2D h) {
        IHistogram1D result = this.histMath.sliceX(h, this.nameInPath(path), -2, -1);
        if (this.tree != null && result instanceof IManagedObject) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram1D projectionY(String path, IHistogram2D h) {
        IHistogram1D result = this.histMath.sliceY(h, this.nameInPath(path), -2, -1);
        if (this.tree != null && result instanceof IManagedObject) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram1D sliceX(String path, IHistogram2D h, int indexY) {
        IHistogram1D result = this.histMath.sliceX(h, this.nameInPath(path), indexY, indexY);
        if (this.tree != null && result instanceof IManagedObject) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram1D sliceY(String path, IHistogram2D h, int indexX) {
        IHistogram1D result = this.histMath.sliceY(h, this.nameInPath(path), indexX, indexX);
        if (this.tree != null && result instanceof IManagedObject) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram1D sliceX(String path, IHistogram2D h, int indexY1, int indexY2) {
        IHistogram1D result = this.histMath.sliceX(h, this.nameInPath(path), indexY1, indexY2);
        if (this.tree != null && result instanceof IManagedObject) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram1D sliceY(String path, IHistogram2D h, int indexX1, int indexX2) {
        IHistogram1D result = this.histMath.sliceY(h, this.nameInPath(path), indexX1, indexX2);
        if (this.tree != null && result instanceof IManagedObject) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram2D projectionXY(String path, IHistogram3D h) {
        IHistogram2D result = this.histMath.sliceXY(h, this.nameInPath(path), -2, -1);
        if (this.tree != null && result instanceof IManagedObject) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram2D projectionXZ(String path, IHistogram3D h) {
        IHistogram2D result = this.histMath.sliceXZ(h, this.nameInPath(path), -2, -1);
        if (this.tree != null && result instanceof IManagedObject) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram2D projectionYZ(String path, IHistogram3D h) {
        IHistogram2D result = this.histMath.sliceYZ(h, this.nameInPath(path), -2, -1);
        if (this.tree != null && result instanceof IManagedObject) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram2D sliceXY(String path, IHistogram3D h, int indexZ1, int indexZ2) {
        IHistogram2D result = this.histMath.sliceXY(h, this.nameInPath(path), indexZ1, indexZ2);
        if (this.tree != null && result instanceof IManagedObject) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram2D sliceXZ(String path, IHistogram3D h, int indexY1, int indexY2) {
        IHistogram2D result = this.histMath.sliceXZ(h, this.nameInPath(path), indexY1, indexY2);
        if (this.tree != null && result instanceof IManagedObject) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }

    public IHistogram2D sliceYZ(String path, IHistogram3D h, int indexX1, int indexX2) {
        IHistogram2D result = this.histMath.sliceYZ(h, this.nameInPath(path), indexX1, indexX2);
        if (this.tree != null && result instanceof IManagedObject) {
            this.tree.addFromFactory(this.parentPath(path), (IManagedObject)result);
        }
        return result;
    }
}

