/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.histogram.binner;

import hep.aida.ref.histogram.binner.Binner1D;

public class BasicBinner1D
implements Binner1D {
    private int[] entries;
    private double[] heights;
    private double[] plusErrors;
    private double[] means;
    private double[] rmss;
    private int bins;

    public BasicBinner1D(int bins) {
        if (bins < 0) {
            throw new IllegalArgumentException("Number of bins cannot be negative!!! " + bins);
        }
        this.setNumberOfBins(bins);
    }

    public void fill(int bin, double x, double weight) {
        int n = bin;
        this.entries[n] = this.entries[n] + 1;
        int n2 = bin;
        this.heights[n2] = this.heights[n2] + weight;
        int n3 = bin;
        this.plusErrors[n3] = this.plusErrors[n3] + weight * weight;
        int n4 = bin;
        this.means[n4] = this.means[n4] + x * weight;
        int n5 = bin;
        this.rmss[n5] = this.rmss[n5] + x * x * weight;
    }

    public void clear() {
        this.createArrays(this.bins);
    }

    private void setNumberOfBins(int bins) {
        this.bins = bins;
        this.createArrays(bins);
    }

    public int entries(int bin) {
        return this.entries[bin];
    }

    public double height(int bin) {
        return this.heights[bin];
    }

    public double plusError(int bin) {
        return Math.sqrt(this.plusErrors[bin]);
    }

    public double minusError(int bin) {
        return this.plusError(bin);
    }

    public double mean(int bin) {
        double h = this.height(bin);
        if (h != 0.0) {
            return this.means[bin] / h;
        }
        return 0.0;
    }

    public double rms(int bin) {
        double h = this.height(bin);
        double m = this.mean(bin);
        if (h != 0.0) {
            return Math.sqrt(Math.abs(this.rmss[bin] / h - m * m));
        }
        return 0.0;
    }

    public void setBinContent(int bin, int entries, double height, double plusError, double minusError, double mean, double rms) {
        this.heights[bin] = height;
        this.entries[bin] = entries;
        this.plusErrors[bin] = plusError * plusError;
        this.means[bin] = 0.0;
        this.rmss[bin] = 0.0;
        if (height != 0.0) {
            this.means[bin] = mean * height;
            this.rmss[bin] = rms * rms * height + mean * mean * height;
        }
    }

    public void scale(double scaleFactor) {
        int bin = 0;
        while (bin < this.bins) {
            int n = bin;
            this.heights[n] = this.heights[n] * scaleFactor;
            int n2 = bin;
            this.plusErrors[n2] = this.plusErrors[n2] * (scaleFactor * scaleFactor);
            int n3 = bin;
            this.means[n3] = this.means[n3] * scaleFactor;
            int n4 = bin++;
            this.rmss[n4] = this.rmss[n4] * scaleFactor;
        }
    }

    private void createArrays(int n) {
        this.entries = new int[n];
        this.heights = new double[n];
        this.plusErrors = new double[n];
        this.means = new double[n];
        this.rmss = new double[n];
    }
}

