/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.pdf;

import hep.aida.IAnnotation;
import hep.aida.IFitData;
import hep.aida.IFunction;
import hep.aida.dev.IDevFitData;
import hep.aida.dev.IDevFitDataIterator;
import hep.aida.ext.IFitMethod;
import hep.aida.ext.IOptimizer;
import hep.aida.ext.IOptimizerFactory;
import hep.aida.ext.IVariableSettings;
import hep.aida.ref.fitter.fitData.FitDataCreator;
import hep.aida.ref.pdf.Function;
import hep.aida.ref.pdf.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.freehep.util.FreeHEPLookup;
import org.openide.util.Lookup;

public class PdfFitter {
    private String engineType;
    private IOptimizer optimizer = null;
    private String fitMethodType;
    private IFitMethod fitMethod = null;
    private boolean useGradient = true;

    public PdfFitter(String fitMethodType, String engineType) throws IllegalArgumentException {
        this.setFitMethod(fitMethodType);
        this.setEngine(engineType);
    }

    public void setEngine(String engineType) throws IllegalArgumentException {
        if (engineType == null || engineType.length() == 0) {
            engineType = "uncmin";
        }
        String enType = engineType.toLowerCase();
        IOptimizerFactory tmpOptimizerFactory = null;
        Lookup.Template template = new Lookup.Template(IOptimizerFactory.class);
        Lookup.Result result = FreeHEPLookup.instance().lookup(template);
        Collection c = result.allInstances();
        Iterator i = c.iterator();
        block0: while (i.hasNext()) {
            IOptimizerFactory of = (IOptimizerFactory)i.next();
            String[] names = of.optimizerFactoryNames();
            if (names == null || names.length == 0) {
                throw new IllegalArgumentException("IOptimizerFactory with illegal names!");
            }
            for (int j = 0; j < names.length; ++j) {
                if (!enType.equals(names[j].toLowerCase())) continue;
                tmpOptimizerFactory = of;
                continue block0;
            }
        }
        if (tmpOptimizerFactory == null) {
            throw new IllegalArgumentException("Cannot create IOptimizer of type: " + engineType);
        }
        this.engineType = engineType;
        this.optimizer = tmpOptimizerFactory.create(engineType);
    }

    public String engineName() {
        return this.engineType;
    }

    public void setFitMethod(String fitMethodType) throws IllegalArgumentException {
        if (fitMethodType == null || fitMethodType.length() == 0) {
            fitMethodType = "chi2";
        }
        String fitMet = fitMethodType.toLowerCase();
        IFitMethod tmpFitMethod = null;
        Lookup.Template template = new Lookup.Template(IFitMethod.class);
        Lookup.Result result = FreeHEPLookup.instance().lookup(template);
        Collection c = result.allInstances();
        Iterator i = c.iterator();
        block0: while (i.hasNext()) {
            IFitMethod fm = (IFitMethod)i.next();
            String[] names = fm.fitMethodNames();
            if (names == null || names.length == 0) {
                throw new IllegalArgumentException("IFitMethod with illegal names!");
            }
            for (int j = 0; j < names.length; ++j) {
                if (!fitMet.equals(names[j].toLowerCase())) continue;
                tmpFitMethod = fm;
                continue block0;
            }
        }
        if (tmpFitMethod == null) {
            throw new IllegalArgumentException("Unknown IFitMethod type: " + fitMethodType);
        }
        this.fitMethodType = fitMethodType;
        this.fitMethod = tmpFitMethod;
    }

    public String fitMethodName() {
        return this.fitMethodType;
    }

    public void fit(Object[] objs, Function[] functions) {
        IFitData[] data = new IFitData[objs.length];
        for (int i = 0; i < data.length; ++i) {
            data[i] = FitDataCreator.create(objs[i]);
        }
        this.fit(data, functions);
    }

    public void fit(IFitData[] data, Function[] functions) {
        int i;
        int i2;
        int nData = data.length;
        if (nData != functions.length) {
            throw new IllegalArgumentException("Inconsistent number of data sets (" + nData + ") and functions (" + functions.length + ").");
        }
        int fitType = this.fitMethod.fitType();
        for (i2 = 0; i2 < nData; ++i2) {
            if (fitType != ((IDevFitData)data[i2]).fitType()) {
                throw new IllegalArgumentException("This FitData is incompatible with the selected fit method");
            }
            if (data[i2].dimension() == functions[i2].numberOfDependents()) continue;
            throw new IllegalArgumentException("Dimension mismatch!! Function's dimension " + functions[i2].numberOfDependents() + " FitData's dimension " + data[i2].dimension());
        }
        if (nData > 1) {
            for (i2 = 0; i2 < nData; ++i2) {
                functions[i2].normalizationParameter().setName("norm_" + i2);
            }
        }
        this.fitMethod.clear();
        this.optimizer.reset();
        this.setErrorDefinition();
        boolean normalizeFunction = fitType == 1;
        for (int i3 = 0; i3 < nData; ++i3) {
            functions[i3].normalize(normalizeFunction);
        }
        InternalObjectiveFunction objectiveFunction = new InternalObjectiveFunction(data, functions);
        for (i = 0; i < objectiveFunction.dimension(); ++i) {
            Parameter p = objectiveFunction.getVariable(i);
            IVariableSettings varSet = this.optimizer.variableSettings(p.name());
            varSet.setValue(p.value());
            varSet.setFixed(p.isFixed());
            double stepSize = p.stepSize();
            if (Double.isNaN(stepSize) && (stepSize = 0.1 * Math.abs(p.value())) < 1.0) {
                stepSize = 1.0;
            }
            varSet.setStepSize(stepSize);
            if (!p.useBounds()) continue;
            varSet.setBounds(p.lowerBound(), p.upperBound());
        }
        this.optimizer.setFunction(objectiveFunction);
        this.optimizer.configuration().setUseFunctionGradient(objectiveFunction.providesGradient() && this.useFunctionGradient());
        this.optimizer.configuration().setMaxIterations(500);
        this.optimizer.optimize();
        if (nData > 1) {
            for (i = 0; i < nData; ++i) {
                functions[i].normalizationParameter().setName("norm");
            }
        }
    }

    public void fit(Object obj, Function function) {
        IFitData data = FitDataCreator.create(obj);
        this.fit(data, function);
    }

    public void fit(IFitData data, Function function) {
        this.fit(new IFitData[]{data}, new Function[]{function});
    }

    public boolean useFunctionGradient() {
        return this.useGradient;
    }

    public void setUseFunctionGradient(boolean useGradient) {
        this.useGradient = useGradient;
    }

    private void setErrorDefinition() {
        if (this.fitMethod.fitType() == 0) {
            this.optimizer.configuration().setErrorDefinition(1);
        } else {
            this.optimizer.configuration().setErrorDefinition(2);
        }
    }

    private class InternalObjectiveFunction
    implements IFunction {
        private ArrayList vars = new ArrayList();
        private Function[] functions;
        private IDevFitDataIterator[] iters;

        InternalObjectiveFunction(IFitData[] data, Function[] functions) {
            this.functions = functions;
            this.iters = new IDevFitDataIterator[data.length];
            for (int i = 0; i < functions.length; ++i) {
                this.iters[i] = ((IDevFitData)data[i]).dataIterator();
                Function f = functions[i];
                for (int j = 0; j < f.numberOfParameters(); ++j) {
                    Parameter p = f.getParameter(j);
                    if (this.vars.contains(p)) continue;
                    this.vars.add(p);
                }
            }
        }

        public Parameter getVariable(int index) {
            return (Parameter)this.vars.get(index);
        }

        public double value(double[] values) {
            int i;
            double value = 0.0;
            for (i = 0; i < this.vars.size(); ++i) {
                ((Parameter)this.vars.get(i)).setValue(values[i]);
            }
            for (i = 0; i < this.functions.length; ++i) {
                Function f = this.functions[i];
                value += PdfFitter.this.fitMethod.evaluate(this.iters[i], (IFunction)f);
            }
            return value;
        }

        public boolean providesGradient() {
            for (int i = 0; i < this.functions.length; ++i) {
                Function f = this.functions[i];
                for (int j = 0; j < f.numberOfParameters(); ++j) {
                    if (f.providesGradientWithRespectToVariable(f.getParameter(i))) continue;
                    return false;
                }
            }
            return true;
        }

        public int dimension() {
            return this.vars.size();
        }

        public double[] gradient(double[] values) {
            int i;
            double[] grad = new double[this.vars.size()];
            for (i = 0; i < this.vars.size(); ++i) {
                ((Parameter)this.vars.get(i)).setValue(values[i]);
            }
            for (i = 0; i < this.functions.length; ++i) {
                Function f = this.functions[i];
                int fPars = f.numberOfParameters();
                double[] g = PdfFitter.this.fitMethod.evaluateGradient(fPars, this.iters[i], (IFunction)f);
                for (int j = 0; j < fPars; ++j) {
                    Parameter p = f.getParameter(j);
                    int n = this.vars.indexOf(p);
                    grad[n] = grad[n] + g[j];
                }
            }
            return grad;
        }

        public int numberOfParameters() {
            return 0;
        }

        public String variableName(int index) {
            return ((Parameter)this.vars.get(index)).name();
        }

        public String[] variableNames() {
            String[] names = new String[this.vars.size()];
            for (int i = 0; i < names.length; ++i) {
                names[i] = ((Parameter)this.vars.get(i)).name();
            }
            return names;
        }

        public IAnnotation annotation() {
            throw new UnsupportedOperationException();
        }

        public String codeletString() {
            throw new UnsupportedOperationException();
        }

        public int indexOfParameter(String str) {
            throw new UnsupportedOperationException();
        }

        public boolean isEqual(IFunction iFunction) {
            throw new UnsupportedOperationException();
        }

        public double parameter(String str) {
            throw new UnsupportedOperationException();
        }

        public String[] parameterNames() {
            throw new UnsupportedOperationException();
        }

        public double[] parameters() {
            throw new UnsupportedOperationException();
        }

        public void setParameter(String str, double param) throws IllegalArgumentException {
            throw new UnsupportedOperationException();
        }

        public void setParameters(double[] values) throws IllegalArgumentException {
            throw new UnsupportedOperationException();
        }

        public void setTitle(String str) throws IllegalArgumentException {
            throw new UnsupportedOperationException();
        }

        public String title() {
            throw new UnsupportedOperationException();
        }
    }
}

