/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter;

import hep.aida.IBrushStyle;
import hep.aida.ref.plotter.BaseStyle;

abstract class BrushStyle
extends BaseStyle
implements IBrushStyle {
    private static String colorPar = "color";
    private static String opacityPar = "opacity";

    BrushStyle() {
    }

    protected void initializeBaseStyle() {
        this.addParameter(colorPar);
        this.addParameter(opacityPar, "-1");
        this.initializeBrushStyle();
    }

    protected abstract void initializeBrushStyle();

    public String[] availableColors() {
        return this.availableParameterOptions(colorPar);
    }

    public String color() {
        return this.parameterValue(colorPar);
    }

    public double opacity() {
        String opacityStr = this.parameterValue(opacityPar);
        if (opacityStr == null) {
            opacityStr = this.parameterDefaultValue(opacityPar);
        }
        return Double.parseDouble(opacityStr);
    }

    public boolean setColor(String color) {
        return this.setParameter(colorPar, color);
    }

    public boolean setOpacity(double opacity) {
        if (opacity < 0.0 || opacity > 1.0) {
            return this.setParameter(opacityPar);
        }
        return this.setParameter(opacityPar, String.valueOf(opacity));
    }
}

