/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote;

import hep.aida.AlreadyConvertedException;
import hep.aida.IAnnotation;
import hep.aida.IBaseHistogram;
import hep.aida.ICloud1D;
import hep.aida.IHistogram1D;
import hep.aida.dev.IDevMutableStore;
import hep.aida.ref.ReadOnlyException;
import hep.aida.ref.event.HistogramEvent;
import hep.aida.ref.remote.RemoteHistogram1D;
import hep.aida.ref.remote.RemoteManagedObject;
import java.util.EventObject;

public class RemoteCloud1D
extends RemoteManagedObject
implements ICloud1D {
    private RemoteHistogram1D hist;
    private boolean isConverted;
    private int entries;
    private int maxEntries;
    private double lowerEdge;
    private double upperEdge;
    protected double sumOfWeights;
    private double mean;
    private double rms;
    private double[] values;
    private double[] weights;

    public RemoteCloud1D(String name) {
        this(null, name);
    }

    public RemoteCloud1D(IDevMutableStore store, String name) {
        this(store, name, name);
    }

    public RemoteCloud1D(IDevMutableStore store, String name, String title) {
        super(name);
        this.aidaType = "ICloud1D";
        this.store = store;
        this.hist = new RemoteHistogram1D(name);
        this.hist.setFillable(true);
        this.hist.setDataValid(true);
        if (!name.equals(title)) {
            this.hist.setTitle(title);
        }
        this.dataIsValid = false;
    }

    protected EventObject createEvent() {
        return new HistogramEvent((IBaseHistogram)this);
    }

    public void setConverted(boolean b) {
        this.isConverted = b;
    }

    public void setMaxEntries(int i) {
        this.maxEntries = i;
    }

    public void setEntries(int i) {
        this.entries = i;
    }

    public void setLowerEdge(double d) {
        this.lowerEdge = d;
    }

    public void setUpperEdge(double d) {
        this.upperEdge = d;
    }

    public void setSummOfWeights(double d) {
        this.sumOfWeights = d;
    }

    public void setMean(double d) {
        this.mean = d;
    }

    public void setRms(double d) {
        this.rms = d;
    }

    public void setValues(double[] a) {
        this.values = a;
    }

    public void setWeights(double[] a) {
        this.weights = a;
    }

    public IAnnotation annotation() {
        this.makeSureDataIsValid();
        return this.hist.annotation();
    }

    public int dimension() {
        this.makeSureDataIsValid();
        return 1;
    }

    public int entries() {
        this.makeSureDataIsValid();
        if (this.isConverted()) {
            return this.hist.allEntries();
        }
        return this.entries;
    }

    public IHistogram1D histogram() throws RuntimeException {
        this.makeSureDataIsValid();
        return this.hist;
    }

    public boolean isConverted() {
        this.makeSureDataIsValid();
        return this.isConverted;
    }

    public double lowerEdge() {
        this.makeSureDataIsValid();
        return this.lowerEdge;
    }

    public int maxEntries() {
        this.makeSureDataIsValid();
        return this.maxEntries;
    }

    public double mean() {
        this.makeSureDataIsValid();
        if (this.isConverted()) {
            return this.hist.mean();
        }
        return this.mean;
    }

    public double rms() {
        this.makeSureDataIsValid();
        if (this.isConverted()) {
            return this.hist.rms();
        }
        return this.rms;
    }

    public void setTitle(String str) throws IllegalArgumentException {
        this.hist.setTitle(str);
    }

    public double sumOfWeights() {
        this.makeSureDataIsValid();
        if (this.isConverted()) {
            return this.hist.sumAllBinHeights();
        }
        return this.sumOfWeights;
    }

    public String title() {
        this.makeSureDataIsValid();
        return this.hist.title();
    }

    public double upperEdge() {
        this.makeSureDataIsValid();
        return this.upperEdge;
    }

    public double value(int param) throws AlreadyConvertedException {
        this.makeSureDataIsValid();
        if (this.isConverted()) {
            throw new RuntimeException("Cloud has been converted");
        }
        return this.values[param];
    }

    public double weight(int param) throws AlreadyConvertedException {
        this.makeSureDataIsValid();
        if (this.isConverted()) {
            throw new RuntimeException("Cloud has been converted");
        }
        return this.weights[param];
    }

    public void convert(double[] values) throws AlreadyConvertedException {
        throw new ReadOnlyException();
    }

    public void convert(int param, double param1, double param2) throws AlreadyConvertedException {
        throw new ReadOnlyException();
    }

    public void convertToHistogram() throws AlreadyConvertedException {
        throw new ReadOnlyException();
    }

    public void fill(double param) throws IllegalArgumentException {
        throw new ReadOnlyException();
    }

    public void fill(double param, double param1) throws IllegalArgumentException {
        throw new ReadOnlyException();
    }

    public void fillHistogram(IHistogram1D iHistogram1D) throws RuntimeException {
        throw new ReadOnlyException();
    }

    public void reset() throws RuntimeException {
        throw new ReadOnlyException();
    }

    public void scale(double param) throws IllegalArgumentException {
        throw new ReadOnlyException();
    }
}

