/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote;

import hep.aida.IManagedObject;
import hep.aida.dev.IDevMutableStore;
import hep.aida.ref.AidaUtils;
import hep.aida.ref.ManagedObject;
import hep.aida.ref.event.IsObservable;
import hep.aida.ref.remote.RemoteMutableStore;
import java.util.logging.Logger;

public abstract class RemoteManagedObject
extends ManagedObject
implements IsObservable {
    protected IDevMutableStore store = null;
    protected String treePath = null;
    protected String aidaType = "IManagedObject";
    protected boolean dataIsValid = false;
    protected Logger remoteLogger = Logger.getLogger("hep.aida.ref.remote");

    public RemoteManagedObject(String name) {
        super(name);
        this.fillable = false;
    }

    protected void makeSureDataIsValid() {
        if (this.dataIsValid || this.fillable) {
            return;
        }
        if (this.store instanceof RemoteMutableStore) {
            ((RemoteMutableStore)this.store).handleDataUpdate((IManagedObject)this, this.treePath, this.aidaType);
        } else {
            this.store.updateData(this.treePath, this.aidaType);
        }
    }

    public String getAIDAType() {
        if (this.aidaType != null && !this.aidaType.trim().equals("")) {
            return this.aidaType;
        }
        return super.getAIDAType();
    }

    public void setStore(IDevMutableStore store) {
        this.store = store;
    }

    public void setTreeFolder(String treeFolder) {
        String histName;
        String string = histName = this.name() == null ? "Unknown" : this.name();
        if (histName.startsWith("/")) {
            histName = histName.substring(1);
            histName = AidaUtils.modifyName(histName);
            histName = "/" + histName;
        } else {
            histName = AidaUtils.modifyName(histName);
        }
        if (treeFolder.endsWith("//")) {
            treeFolder = treeFolder.substring(0, treeFolder.length() - 2);
        }
        if (!treeFolder.startsWith("/")) {
            treeFolder = "/" + treeFolder;
        } else if (treeFolder.startsWith("//")) {
            treeFolder = treeFolder.substring(1);
        }
        this.treePath = treeFolder.equals("/") && histName.startsWith("/") ? histName : (treeFolder.endsWith("/") && histName.startsWith("/") ? treeFolder + histName.substring(1) : (treeFolder.endsWith("/") || histName.startsWith("/") ? treeFolder + histName : treeFolder + "/" + histName));
    }

    public String getTreePath() {
        return this.treePath;
    }

    public void setDataValid(boolean dataIsValid) {
        this.remoteLogger.finest("RemoteMutableObject.setDataValid  DATA: new=" + dataIsValid + ", old=" + this.dataIsValid + ", throwEvent=" + this.isValid + ", path=" + this.treePath);
        if (this.dataIsValid != dataIsValid) {
            this.dataIsValid = dataIsValid;
            if (this.isValid) {
                this.fireStateChanged();
            }
        }
    }

    public boolean isDataValid() {
        return this.dataIsValid;
    }
}

