/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote;

import hep.aida.IBaseHistogram;
import hep.aida.IDataPointSet;
import hep.aida.IManagedObject;
import hep.aida.dev.IDevTree;
import hep.aida.ref.Annotation;
import hep.aida.ref.ManagedObject;
import hep.aida.ref.event.AIDAListener;
import hep.aida.ref.event.DataPointSetEvent;
import hep.aida.ref.event.HistogramEvent;
import hep.aida.ref.event.IsObservable;
import hep.aida.ref.event.TreeEvent;
import hep.aida.ref.remote.RemoteManagedObject;
import hep.aida.ref.remote.RemoteServerQueue;
import hep.aida.ref.remote.RemoteUpdateEvent;
import hep.aida.ref.remote.interfaces.AidaTreeClient;
import hep.aida.ref.remote.interfaces.AidaTreeServant;
import hep.aida.ref.remote.interfaces.AidaUpdateEvent;
import hep.aida.ref.tree.Tree;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;

public class RemoteServant
implements AidaTreeServant,
AIDAListener {
    private IDevTree tree;
    private AidaTreeClient client;
    private String clientID;
    private boolean duplex;
    private boolean appendAxisType;
    private boolean keepRunning;
    private Vector sources;
    private Hashtable hash;
    private RemoteServerQueue eventQueue;
    protected boolean useValidation;
    protected Logger remoteLogger;

    public RemoteServant(IDevTree tree, String clientID) {
        this.tree = tree;
        this.clientID = clientID;
        this.duplex = false;
        this.appendAxisType = false;
        this.eventQueue = new RemoteServerQueue();
        this.remoteLogger = Logger.getLogger("hep.aida.ref.remote");
        this.init();
    }

    public RemoteServant(IDevTree tree, AidaTreeClient client) {
        this.tree = tree;
        this.client = client;
        this.duplex = true;
        this.appendAxisType = false;
        this.eventQueue = new RemoteServerQueue(client);
        this.remoteLogger = Logger.getLogger("hep.aida.ref.remote");
        this.init();
    }

    public void setAppendAxisType(boolean a) {
        this.appendAxisType = a;
    }

    public boolean getAppendAxisType() {
        return this.appendAxisType;
    }

    protected void init() {
        this.sources = new Vector();
        this.hash = new Hashtable();
        this.useValidation = true;
        this.keepRunning = this.duplex;
        Object lock = this.tree.getLock();
        if (lock != null) {
            if (this.tree instanceof IsObservable) {
                ((IsObservable)((Object)this.tree)).addListener(this);
                this.sources.add(this.tree);
                ((IsObservable)((Object)this.tree)).setValid(this);
            }
            if (this.tree instanceof Tree) {
                ((Tree)this.tree).setFolderIsWatched("/", true);
            }
        } else {
            if (this.tree instanceof IsObservable) {
                ((IsObservable)((Object)this.tree)).addListener(this);
                this.sources.add(this.tree);
                ((IsObservable)((Object)this.tree)).setValid(this);
            }
            if (this.tree instanceof Tree) {
                ((Tree)this.tree).setFolderIsWatched("/", true);
            }
        }
    }

    public synchronized void setUseValidation(boolean state) {
        this.useValidation = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        RemoteServant remoteServant = this;
        synchronized (remoteServant) {
            this.remoteLogger.fine("\n\tClosing RemoteServant ... ");
            this.keepRunning = false;
            this.eventQueue.close();
            Object lock = this.tree.getLock();
            if (lock != null) {
                if (this.tree instanceof IsObservable) {
                    ((IsObservable)((Object)this.tree)).removeListener(this);
                }
                for (int i = 0; i < this.sources.size(); ++i) {
                    IsObservable o = (IsObservable)this.sources.get(i);
                    if (o == null) continue;
                    o.removeListener(this);
                }
            } else {
                if (this.tree instanceof IsObservable) {
                    ((IsObservable)((Object)this.tree)).removeListener(this);
                }
                for (int i = 0; i < this.sources.size(); ++i) {
                    IsObservable o = (IsObservable)this.sources.get(i);
                    if (o == null) continue;
                    o.removeListener(this);
                }
            }
        }
        this.sources.clear();
        this.hash.clear();
        this.sources = null;
        this.hash = null;
        this.tree = null;
        this.client = null;
        this.eventQueue = null;
        this.remoteLogger.fine("  ... RemoteServant is closed\n");
    }

    public void setValid(String path) {
        if (path == null || path.equals("") || path.equals("/")) {
            if (this.tree instanceof IsObservable) {
                ((IsObservable)((Object)this.tree)).setValid(this);
            }
        } else {
            IManagedObject mo = this.tree.find(path);
            if (!this.sources.contains(mo) && mo instanceof IsObservable) {
                ((IsObservable)mo).addListener(this);
                this.sources.add(mo);
            }
            if (mo instanceof IsObservable) {
                ((IsObservable)mo).setValid(this);
            }
        }
    }

    public Object find(String path) {
        this.remoteLogger.finest("RemoteServant.find for path=" + path);
        IManagedObject mo = this.tree.find(path);
        this.remoteLogger.finest("RemoteServant.find for path=" + path + ",  found MO=" + mo.toString());
        if (mo instanceof IsObservable && !this.sources.contains((IsObservable)mo)) {
            ((IsObservable)mo).addListener(this);
            this.sources.add((IsObservable)mo);
            this.hash.put(path, mo);
            if (!this.useValidation) {
                ((IsObservable)mo).setValid(this);
            }
        }
        return mo;
    }

    public String[] listObjectNames(String path) {
        this.remoteLogger.finest("RemoteServant.listObjectNames for path=" + path);
        if (this.tree instanceof Tree) {
            ((Tree)this.tree).setFolderIsWatched(path, true);
        }
        String[] list = this.tree.listObjectNames(path);
        return list;
    }

    public String[] listObjectTypes(String path) {
        this.remoteLogger.finest("RemoteServant.listObjectTypes for path=" + path + ",  appendAxisType=" + this.appendAxisType);
        if (this.tree instanceof Tree) {
            ((Tree)this.tree).setFolderIsWatched(path, true);
        }
        String[] names = this.tree.listObjectNames(path);
        String[] list = this.tree.listObjectTypes(path);
        if (list == null || list.length == 0) {
            return list;
        }
        if (this.tree instanceof Tree) {
            Tree tTree = (Tree)this.tree;
            for (int i = 0; i < names.length; ++i) {
                String objPath = names[i];
                IManagedObject mo = tTree.findObject(objPath);
                if (this.appendAxisType && mo instanceof RemoteManagedObject) {
                    String tmp;
                    String xType = "double";
                    RemoteManagedObject rmo = (RemoteManagedObject)mo;
                    rmo.setFillable(true);
                    Annotation a = null;
                    if (rmo instanceof IBaseHistogram) {
                        try {
                            a = (Annotation)((IBaseHistogram)rmo).annotation();
                            a.setFillable(true);
                            tmp = a.value("xAxisType");
                            if (tmp != null && !tmp.equals("")) {
                                xType = tmp;
                                list[i] = list[i] + ":" + xType;
                            }
                        }
                        catch (IllegalArgumentException e) {}
                    } else if (rmo instanceof IDataPointSet) {
                        try {
                            a = (Annotation)((IDataPointSet)rmo).annotation();
                            a.setFillable(true);
                            tmp = a.value("xAxisType");
                            if (tmp != null && !tmp.equals("")) {
                                xType = tmp;
                                list[i] = list[i] + ":" + xType;
                            }
                        }
                        catch (IllegalArgumentException e) {
                            // empty catch block
                        }
                    }
                    if (a != null) {
                        a.setFillable(false);
                    }
                    rmo.setFillable(false);
                }
                if (this.useValidation || !(mo instanceof IsObservable)) continue;
                ((IsObservable)mo).setValid(this);
            }
        }
        return list;
    }

    public void setValid(String[] path) {
        if (path != null && path.length != 0) {
            for (int i = 0; i < path.length; ++i) {
                this.setValid(path[i]);
            }
        }
    }

    public AidaUpdateEvent[] updates() {
        AidaUpdateEvent[] events = this.eventQueue.getEvents();
        return events;
    }

    public void stateChanged(EventObject ev) {
        String tmp;
        Object mo;
        this.remoteLogger.finest("RemoteServant: got   Event: " + ev.toString());
        RemoteUpdateEvent event = null;
        int id = -1;
        String pathString = "";
        String nodeType = "null";
        String xAxisType = "double";
        if (ev instanceof AidaUpdateEvent) {
            String tmp2;
            String nodeTypeString;
            AidaUpdateEvent aev = (AidaUpdateEvent)((Object)ev);
            id = aev.id();
            pathString = aev.path();
            nodeType = nodeTypeString = aev.nodeType();
            xAxisType = "double";
            int indexT = nodeTypeString.lastIndexOf(":");
            if (indexT > 0) {
                nodeType = nodeTypeString.substring(0, indexT);
                String tmpType = nodeTypeString.substring(indexT + 1);
                if (tmpType != null && !tmpType.equals("")) {
                    xAxisType = tmpType;
                }
            } else if (event instanceof RemoteUpdateEvent && (tmp2 = ((RemoteUpdateEvent)event).getXAxisType()) != null) {
                xAxisType = tmp2;
            }
        } else if (ev instanceof TreeEvent) {
            String[] path;
            TreeEvent tev = (TreeEvent)ev;
            if (tev.getType() != null) {
                nodeType = tev.getType().getName();
            }
            if (tev.getFlags() == 1) {
                nodeType = "dir";
            }
            if ((path = tev.getPath()) != null) {
                for (int i = 0; i < path.length; ++i) {
                    pathString = pathString + "/" + path[i];
                }
            }
            if (tev.getID() == 1) {
                id = 1;
            } else if (tev.getID() == 2) {
                id = 2;
            }
        } else if (ev instanceof HistogramEvent) {
            mo = (IBaseHistogram)ev.getSource();
            try {
                tmp = mo.annotation().value("xAxisType");
                if (tmp != null) {
                    xAxisType = tmp;
                }
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            pathString = this.tree.findPath((IManagedObject)mo);
            id = 0;
            nodeType = mo instanceof ManagedObject ? ((ManagedObject)mo).getAIDAType() : mo.getClass().getName();
        } else if (ev instanceof DataPointSetEvent) {
            mo = (IDataPointSet)ev.getSource();
            try {
                tmp = mo.annotation().value("xAxisType");
                if (tmp != null) {
                    xAxisType = tmp;
                }
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            pathString = this.tree.findPath((IManagedObject)mo);
            id = 0;
            nodeType = mo instanceof ManagedObject ? ((ManagedObject)mo).getAIDAType() : mo.getClass().getName();
        } else {
            this.remoteLogger.fine("RemoteServant.stateChanged Unknown Event: " + ev);
            return;
        }
        if (!pathString.equalsIgnoreCase("dir") && pathString.endsWith("/")) {
            pathString = pathString.substring(0, pathString.length() - 1);
        }
        if (pathString.equalsIgnoreCase("dir") && !pathString.endsWith("/")) {
            pathString = pathString + "/";
        }
        if (id == 1) {
            if (!nodeType.equalsIgnoreCase("dir")) {
                try {
                    mo = this.tree.find(pathString);
                    try {
                        if (mo instanceof IBaseHistogram) {
                            tmp = mo.annotation().value("xAxisType");
                            if (tmp != null) {
                                xAxisType = tmp;
                            }
                        } else if (mo instanceof IDataPointSet && (tmp = ((IDataPointSet)mo).annotation().value("xAxisType")) != null) {
                            xAxisType = tmp;
                        }
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    if (mo instanceof ManagedObject) {
                        nodeType = ((ManagedObject)mo).getAIDAType();
                    }
                }
                catch (IllegalArgumentException ex) {
                    ex.printStackTrace();
                }
            }
        } else if (id == 2) {
            if (nodeType.equalsIgnoreCase("dir")) {
                Enumeration en = this.hash.keys();
                while (en.hasMoreElements()) {
                    IsObservable mo2;
                    String tmpPath = (String)en.nextElement();
                    if (!tmpPath.startsWith(pathString) || (mo2 = (IsObservable)this.hash.remove(pathString)) == null) continue;
                    mo2.removeListener(this);
                    this.sources.remove(mo2);
                }
            } else {
                mo = (IsObservable)this.hash.remove(pathString);
                if (mo != null) {
                    mo.removeListener(this);
                    this.sources.remove(mo);
                }
            }
        }
        if (id < 0) {
            this.remoteLogger.fine("RemoteServant.stateChanged wrong event ID=" + id);
            return;
        }
        if (!this.useValidation && this.tree instanceof IsObservable) {
            ((IsObservable)((Object)this.tree)).setValid(this);
        }
        this.remoteLogger.finest("RemoteServant: process Event: id = " + id + ",  path = " + pathString + ",  type = " + nodeType + ",  xAxisType=" + xAxisType);
        event = new RemoteUpdateEvent(id, pathString, nodeType, xAxisType);
        this.eventQueue.schedule(event);
    }
}

