/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote.basic;

import hep.aida.IAnalysisFactory;
import hep.aida.IBaseHistogram;
import hep.aida.IHistogram1D;
import hep.aida.IHistogramFactory;
import hep.aida.IManagedObject;
import hep.aida.IPlotter;
import hep.aida.ITree;
import hep.aida.ITreeFactory;
import hep.aida.dev.IDevTree;
import hep.aida.ref.event.AIDAListener;
import hep.aida.ref.event.HistogramEvent;
import hep.aida.ref.event.IsObservable;
import hep.aida.ref.event.TreeEvent;
import hep.aida.ref.remote.basic.BasicTreeServer;
import hep.aida.ref.tree.Tree;
import java.util.EventObject;
import java.util.Random;

public class TestBasic
implements AIDAListener {
    private Tree tree;

    public TestBasic(Tree tree) {
        this.tree = tree;
        tree.addListener(this);
        tree.setFolderIsWatched("/", true);
        tree.setValid(this);
    }

    public void stateChanged(EventObject ev) {
        System.out.println("TestBasic.stateChanged GOT Event: " + ev);
        if (ev instanceof TreeEvent) {
            TreeEvent tev = (TreeEvent)ev;
        } else if (ev instanceof HistogramEvent) {
            IBaseHistogram hist = (IBaseHistogram)ev.getSource();
            boolean id = false;
            String pathString = this.tree.findPath((IManagedObject)hist);
            String nodeType = hist.getClass().getName();
            ((IsObservable)hist).setValid(this);
        }
    }

    public static void main(String[] args) {
        Random r = new Random();
        IAnalysisFactory af = IAnalysisFactory.create();
        IPlotter plotter = af.createPlotterFactory().create("Plot");
        plotter.createRegions(2, 2, 0);
        ITreeFactory tf = af.createTreeFactory();
        IDevTree clientTree = (IDevTree)tf.create();
        ITree serverTree = tf.create();
        TestBasic bt = new TestBasic((Tree)serverTree);
        IHistogramFactory histogramFactory = af.createHistogramFactory(serverTree);
        int nEntries = 1000;
        int xbins = 10;
        double xLowerEdge = -10.0;
        double xUpperEdge = 10.0;
        serverTree.mkdir("/dir1");
        IHistogram1D h1 = histogramFactory.createHistogram1D("Hist-1", xbins, xLowerEdge, xUpperEdge);
        IHistogram1D h2 = histogramFactory.createHistogram1D("Hist-2", xbins, xLowerEdge, xUpperEdge);
        for (int i = 0; i < nEntries; ++i) {
            double xval = r.nextGaussian() * 3.0 + 2.0;
            h1.fill(xval);
            xval = r.nextGaussian() * 3.0 + 2.0;
            h2.fill(xval);
        }
        System.out.println("Creating TreeServer ...");
        BasicTreeServer server = new BasicTreeServer(serverTree, "Server_Tree");
    }
}

