/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote.rmi.data;

import hep.aida.IAxis;
import java.io.Serializable;

public class RmiAxis
implements IAxis,
Serializable {
    static final long serialVersionUID = 8424716035826782276L;
    private int nBins;
    private double lowerEdge;
    private double upperEdge;
    private boolean fixedBinning;

    public RmiAxis(int nBins, double lowerEdge, double upperEdge) {
        this.nBins = nBins;
        this.lowerEdge = lowerEdge;
        this.upperEdge = upperEdge;
        this.fixedBinning = true;
    }

    public double binLowerEdge(int index) {
        if (index == -2) {
            return Double.NEGATIVE_INFINITY;
        }
        if (index == -1) {
            return this.upperEdge();
        }
        return this.lowerEdge + this.binWidth(0) * (double)index;
    }

    public double binUpperEdge(int index) {
        if (index == -2) {
            return this.lowerEdge;
        }
        if (index == -1) {
            return Double.POSITIVE_INFINITY;
        }
        return this.lowerEdge + this.binWidth(0) * (double)(index + 1);
    }

    public double binWidth(int index) {
        return (this.upperEdge - this.lowerEdge) / (double)this.nBins;
    }

    public int bins() {
        return this.nBins;
    }

    public int coordToIndex(double coord) {
        if (coord < this.lowerEdge) {
            return -2;
        }
        int index = (int)Math.floor((coord - this.lowerEdge) / this.binWidth(0));
        if (index >= this.nBins) {
            return -1;
        }
        return index;
    }

    public boolean isFixedBinning() {
        return this.fixedBinning;
    }

    public double lowerEdge() {
        return this.lowerEdge;
    }

    public double upperEdge() {
        return this.upperEdge;
    }
}

